unit Testcnt;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, MBUtils, StdCtrls, Grids, Outline;

type
  TmbCounterSample = class(TForm)
    eNextCounter: TEdit;
    Button1: TButton;
    MBCounter1: TMBCounter;
    GroupBox1: TGroupBox;
    eCounterKey: TEdit;
    Label1: TLabel;
    eIncrement: TEdit;
    Label2: TLabel;
    eMin: TEdit;
    Label3: TLabel;
    eMax: TEdit;
    Label4: TLabel;
    eCurrent: TEdit;
    Label5: TLabel;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    procedure Button1Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  mbCounterSample: TmbCounterSample;

implementation

{$R *.DFM}

procedure TmbCounterSample.Button1Click(Sender: TObject);
var
   myValue: longInt;
  iCurrent, iIncrement, iMin, iMax: longInt;
begin
   try
      myValue := MBCounter1.nextCounterValue;
      eNextCounter.Text := intToStr(myValue);
      MBCounter1.getCounterInfo( iCurrent, iIncrement, iMin, iMax );
      eCounterKey.Text := MBCounter1.CounterKeyValue;
      eCurrent.Text := intToStr(iCurrent);
      eIncrement.Text := intToStr(iIncrement);
      eMin.Text := intToStr(iMin);
      eMax.Text := intToStr(iMax);
   except
     on E: EMBCounter do
        messageDlg('EMBCounter raised: ' + e.Message, mtInformation, [mbOk], 0);
   end;
end;

procedure TmbCounterSample.Button3Click(Sender: TObject);
var
  iCurrent, iIncrement, iMin, iMax: longInt;
begin
   MBCounter1.getCounterInfo( iCurrent, iIncrement, iMin, iMax );
   eCounterKey.Text := MBCounter1.CounterKeyValue;
   eCurrent.Text := intToStr(iCurrent);
   eIncrement.Text := intToStr(iIncrement);
   eMin.Text := intToStr(iMin);
   eMax.Text := intToStr(iMax);
end;

procedure TmbCounterSample.Button2Click(Sender: TObject);
var
  iCurrent, iIncrement, iMin, iMax: longInt;
begin
   MBCounter1.CounterKeyValue := eCounterKey.Text;
   iCurrent := StrToInt(eCurrent.Text);
   iIncrement := StrToInt(eIncrement.Text);
   iMin := StrToInt(eMin.Text);
   iMax := StrToInt(eMax.Text);
   MBCounter1.setCounterInfo( iCurrent, iIncrement, iMin, iMax );
end;

procedure TmbCounterSample.Button4Click(Sender: TObject);
var
  iCurrent, iIncrement, iMin, iMax: longInt;
begin
   MBCounter1.CounterKeyValue := eCounterKey.Text;
   iCurrent := StrToInt(eCurrent.Text);
   iIncrement := StrToInt(eIncrement.Text);
   iMin := StrToInt(eMin.Text);
   iMax := StrToInt(eMax.Text);
   MBCounter1.CreateCounter( iCurrent, iIncrement, iMin, iMax );
end;

procedure TmbCounterSample.FormCreate(Sender: TObject);
var
  iCurrent, iIncrement, iMin, iMax: longInt;
begin
   MBCounter1.getCounterInfo( iCurrent, iIncrement, iMin, iMax );
   eCounterKey.Text := MBCounter1.CounterKeyValue;
   eCurrent.Text := intToStr(iCurrent);
   eIncrement.Text := intToStr(iIncrement);
   eMin.Text := intToStr(iMin);
   eMax.Text := intToStr(iMax);
end;

end.
