unit Main;

interface  

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls, Menus, Findfile, FileCtrl,
  TabNotBk;

type
  TfrmMainForm = class(TForm)
    tabSearch: TTabbedNotebook;
    Label6: TLabel;
    lstMatched: TListBox;
    butDelete: TButton;
    chkConfirm: TCheckBox;
    FF1: TFindFiles;
    Label8: TLabel;
    DriveComboBox1: TDriveComboBox;
    dirList: TDirectoryListBox;
    Label9: TLabel;
    labStartDir: TLabel;
    chkSearchSubDirs: TCheckBox;
    GroupBox1: TGroupBox;
    chkBackups: TCheckBox;
    chkDelphi: TCheckBox;
    chkTemp: TCheckBox;
    chkText: TCheckBox;
    chkReadme: TCheckBox;
    chkArchive: TCheckBox;
    txtOther: TEdit;
    chkOther: TCheckBox;
    butScan: TButton;
    butClose: TButton;
    GroupBox2: TGroupBox;
    labCurDir: TLabel;
    labMatchCount: TLabel;
    labMatchSize: TLabel;
    labAllCount: TLabel;
    labAllSize: TLabel;
    Label4: TLabel;
    Label3: TLabel;
    Label2: TLabel;
    Label1: TLabel;
    Label5: TLabel;
    lstInitDir: TListBox;
    butAdd: TButton;
    butDel: TButton;
    procedure butScanClick(Sender: TObject);
    procedure butCloseClick(Sender: TObject);
    procedure FF1DirChange(Sender: TObject);
    procedure butDeleteClick(Sender: TObject);
    procedure chkSearchSubDirsClick(Sender: TObject);
    procedure butAddClick(Sender: TObject);
    procedure butDelClick(Sender: TObject);
    procedure FF1SearchEnd(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  end;

var
  frmMainForm: TfrmMainForm;

implementation

{$R *.DFM}

procedure TfrmMainForm.butScanClick(Sender: TObject);
var
    suba: byte;
begin
    lstMatched.Clear;
    butScan.Enabled := False;
    butDelete.Enabled := True;
    butClose.Caption := '&Cancel';

    FF1.InitDirs.Clear;
    if lstInitDir.Items.Count > 0 then
        for suba := 0 to lstInitDir.Items.Count -1 do
        begin
            FF1.InitDirs.Add(lstInitDir.Items[suba]);
        end;

    FF1.PatternList.Clear;
    if chkBackups.State = cbChecked then
        FF1.PatternList.Add('*.bak');
    if chkDelphi.State = cbChecked then
        FF1.PatternList.Add('*.~*');
    if chkTemp.State = cbChecked then
        FF1.PatternList.Add('*.tmp');
    if chkText.State = cbChecked then
        FF1.PatternList.Add('*.txt');
    if chkReadme.State = cbChecked then
        FF1.PatternList.Add('readme.*');
    if chkArchive.State = cbChecked then
    begin
        FF1.PatternList.Add('*.zip');
        FF1.PatternList.Add('*.arc');
    end;
    if chkOther.State = cbChecked then
        if txtOther.Text <> '' then
            FF1.PatternList.Add(txtOther.Text);

    tabSearch.PageIndex := 1;
    FF1.BeginFind;

    butScan.Enabled := True;
    butDelete.Enabled := True;
    butClose.Caption := '&Close';
end;

procedure TfrmMainForm.butCloseClick(Sender: TObject);
begin
    if butClose.Caption = '&Cancel' then
        FF1.CancelFind
      else
        close;
end;

procedure TfrmMainForm.FF1DirChange(Sender: TObject);
begin
    labCurDir.Caption := UpperCase(FF1.CurrentDir);
    labMatchCount.Caption := IntToStr(FF1.MatchCount);
    labMatchSize.Caption := IntToStr(FF1.MatchSize);
    labAllCount.Caption := IntToStr(FF1.TotalCount);
    labAllSize.Caption := IntToStr(FF1.TotalSize);
    application.processmessages;
end;

procedure TfrmMainForm.butDeleteClick(Sender: TObject);
var
    suba: longint;
    CurStr: Pchar;
begin
    CurStr := StrAlloc(255);
    for suba := 1 to lstMatched.Items.Count do
    begin
        if (lstMatched.Selected[suba-1]) and (lstMatched.Items.Strings[suba-1] <> '') then
        begin
            StrPCopy(CurStr, 'Are you sure you want to delete' + #10 + lstMatched.Items.Strings[suba-1]);
            if chkConfirm.State = cbChecked then
                if Application.MessageBox(CurStr,
                                         'Confirm Delete',
                                         mb_YesNo+mb_DefButton2+mb_IconQuestion) = IDYES then
                begin
                    DeleteFile(lstMatched.Items.Strings[suba-1]);
                    lstMatched.Items.Strings[suba-1] := '';
                end
                else
              else
                begin
                    DeleteFile(lstMatched.Items.Strings[suba-1]);
                    lstMatched.Items.Strings[suba-1] := '';
                end;
        end;
    end;
    StrDispose(CurStr);
end;

procedure TfrmMainForm.chkSearchSubDirsClick(Sender: TObject);
begin
    if chkSearchSubDirs.State = cbChecked then
        FF1.SearchSubDirs := True
      else
        FF1.SearchSubDirs := False;
end;

procedure TfrmMainForm.butAddClick(Sender: TObject);
var
    suba: byte;
begin
    if chkSearchSubDirs.Checked then
        if lstInitDir.Items.Count > 0 then
            for suba:= 0 to (lstInitDir.Items.Count - 1) do
            begin
                if length(lstInitDir.Items[suba]) <= length(labStartDir.Caption) then
                    if copy((lstInitDir.Items[suba]+'\'),1,255) =
                       copy((labStartDir.Caption+'\'),1,length(lstInitDir.Items[suba]+'\')) then
                        exit;
            end;

    lstInitDir.Items.Add(labStartDir.Caption);
end;

procedure TfrmMainForm.butDelClick(Sender: TObject);
begin
    if lstInitDir.ItemIndex > -1 then
        lstInitDir.Items.Delete(lstInitDir.ItemIndex);
end;

procedure TfrmMainForm.FF1SearchEnd(Sender: TObject);
begin
    MessageDlg('Search Operation Completed',mtInformation,[mbOK],0);
end;

procedure TfrmMainForm.FormCreate(Sender: TObject);
begin
    frmMainForm.Left := (Screen.Width - frmMainForm.Width) div 2;
    frmMainForm.Top := (Screen.Height - frmMainForm.Height) div 2;
end;

end.
