unit CShape;

{  TCShape component is a descendant of tShape.  New property,
   ChangeColor, is used to change the default fill color of white.
   Values for the property ChangeColor are chosen from tColor.
                 Frank DeBlanc@70713,640        }

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls;

type
  TCShape = class(TShape)
  private
    { Private declarations }
  protected
  FColorOfShape: TColor;
    { Protected declarations }
  procedure SetColorOfShape(Value: TColor);
  public
    { Public declarations }
  Constructor Create(AOwner: TComponent); override;
  published
    { Published declarations }
  Property ChangeColor: TColor read FColorOfShape write SetColorOfShape;
  end;

procedure Register;

implementation

Constructor TCShape.Create(AOwner: TComponent);
begin
inherited Create(AOwner);
FColorOfShape := clWhite;
end;

procedure TCShape.SetColorOfShape(Value: TColor);
begin
  if FColorOfShape <> Value then
     begin
      FColorOfShape := Value;
      Self.Brush.Color := FColorOfShape;
     end;
end;

procedure Register;
begin
  RegisterComponents('Samples', [TCShape]);
end;

end.
 