unit Neocmbox;

{ v1.0 - released to CIS's delphi forum }

{ this is a varation on the TComboBox class, it remaps the CBN_SELECTCHANGE
  message and causes it to generate an OnListPick event if its defined.  I
  needed the OnListPick because I really did not want to be notified when
  the user was just typing in the ComboBox's edit field. }

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls;

type
  TNeoComboBox = class(TComboBox)
  private
    procedure CNCommand(var Message: TWMCommand); message CN_COMMAND;
  protected
    FOnListPick: TNotifyEvent;
    procedure ListPick; dynamic;
  published
    property OnListPick: TNotifyEvent read FOnListPick write FOnListPick;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Samples', [TNeoComboBox]);
end;

{ lets see if there is something to do? }
procedure TNeoComboBox.ListPick;
begin
     if Assigned(FOnListPick) then FOnListPick(Self);
end;

{ slightly modified CNCommand handler }
procedure TNeoComboBox.CNCommand(var Message: TWMCommand);
begin
  case Message.NotifyCode of
    CBN_SELCHANGE: { in this case only, we will take over }
      begin
        Text := Items[ItemIndex];
        ListPick;
      end;
  else             { let mom handle the rest }
      inherited;
  end;
end;

end.
