unit Blob2u1;
{written by Jay Baker, CIS 73530,3146}

(*
  This is an example of using blobs to store arbitrary data.
  The record is written to a Paradox record as a blob, then read back again.
  In this example, the object being written has its own methods
  to read and write itself to the blob, and the table has a TBlobField defined
  using the Fields Editor.
*)

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, DBTables, DB;

type
  TForm1 = class(TForm)
    Table1: TTable;
    Table1Id: TStringField;
    Table1Theblob: TBlobField;
    Button1: TButton;
    Label1: TLabel;
    Button2: TButton;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

type
  tx=class
    a:array[1..4] of longint;
    procedure WriteToBlob(Blob:TBlobField);
    procedure ReadFromBlob(Blob:TBlobField);
    end;

procedure tx.writetoblob(Blob:TBlobField);
var
  BlobStream: TBlobStream;
begin
  BlobStream := TBlobStream.Create(Blob, bmWrite);
  try
    BlobStream.Write(a,sizeof(a));
  finally
    BlobStream.Free;
    end;
  end; {WriteToBlob}

procedure tx.ReadFromBlob(Blob:TBlobField);
var
  BlobStream: TBlobStream;
begin
  BlobStream := TBlobStream.Create(Blob, bmRead);
  try
    BlobStream.Read(a,sizeof(a));
  finally
    BlobStream.Free;
    end;
  end; {ReadFromBlob}

procedure TForm1.Button1Click(Sender: TObject);
var
  x:tx;
begin
  with Table1 do begin
    Close;
    if DatabaseName='' then
      DatabaseName:=ExtractFilePath(ParamStr(0));
    Open;
    First;
    Edit;
    end;
  x:=tx.create;
  x.a[1]:=20;
  x.a[2]:=30;
  x.a[3]:=17;
  x.a[4]:=11;
  x.WriteToBlob(Table1TheBlob);
  x.Free;
  Table1.Post;
  Table1.Close;
  end;

procedure TForm1.Button2Click(Sender: TObject);
var
  x:tx;
begin
  Table1.Open;
  Table1.First;
  x:=tx.create;
  x.ReadFromBlob(Table1TheBlob);
  Table1.Close;
  Label1.Caption:=IntToStr(x.a[1]);
  Label2.Caption:=IntToStr(x.a[2]);
  Label3.Caption:=IntToStr(x.a[3]);
  Label4.Caption:=IntToStr(x.a[4]);
  x.Free;
  end;

end.
