unit Blob1u1;
{written by Jay Baker, CIS 73530,3146}

(*
  This example illustrates the use of a blob to store a Delphi component.
  The component is written to a Paradox record, then read back with some
  properties modified.
*)

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, DBTables, DB;

type
  TForm1 = class(TForm)
    Table1: TTable;
    Table1Id: TStringField;
    Table1Theblob: TBlobField;
    Button1: TButton;
    Label1: TLabel;
    Button2: TButton;
    Label2: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure BlobWriteComponent(Blob:TBlobField;const Comp:TComponent);
var
  BlobStream: TBlobStream;
begin
  BlobStream := TBlobStream.Create(Blob, bmWrite);
  try
    BlobStream.WriteComponent(Comp);
  finally
    BlobStream.Free;
    end;
  end; {BlobWriteComponent}

function BlobReadComponent(Blob:TBlobField;Comp:TComponent):TComponent;
var
  BlobStream: TBlobStream;
begin
  Result:=nil;
  BlobStream := TBlobStream.Create(Blob, bmRead);
  try
    Result:=BlobStream.ReadComponent(Comp);
  finally
    BlobStream.Free;
    end;
  end; {BlobReadComponent}

procedure TForm1.Button1Click(Sender: TObject);
begin
  with Table1 do begin
    Close;
    if DatabaseName='' then
      DatabaseName:=ExtractFilePath(ParamStr(0));
    Open;
    First;
    Edit;
    end;
  BlobWriteComponent(Table1TheBlob,Label1);
  Table1.Post;
  Table1.Close;
  end;

procedure TForm1.Button2Click(Sender: TObject);
var
  a:TComponent;
begin
  Table1.Open;
  Table1.First;
  RegisterClass(TLabel);
  a:=BlobReadComponent(Table1TheBlob,nil);
  if a is TLabel then
    with TLabel(a) do begin
      Parent:=Self; 
      Top:=Top+30;
      Left:=Left+30;
      Caption:='I''m moved!';
      Font.Color:=clRed;
      end;
  end;

end.
