unit Addrunit;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  StdCtrls, Forms, DBCtrls, DB, DBTables, Mask, ExtCtrls, DBLookup,
  Menus, Types, Buttons, DdeMan;

type
  TFormAddress = class(TForm)
    ScrollBox: TScrollBox;
    EditPrefix: TDBEdit;
    EditLName: TDBEdit;
    EditMName: TDBEdit;
    EditFName: TDBEdit;
    EditSuffix: TDBEdit;
    Label7: TLabel;
    EditCompany: TDBEdit;
    Label8: TLabel;
    EditTitle: TDBEdit;
    EditAddress: TDBEdit;
    EditAddress2: TDBEdit;
    EditCity: TDBEdit;
    EditState: TDBEdit;
    EditZip: TDBEdit;
    EditZip2: TDBEdit;
    Label15: TLabel;
    EditForeignCountry: TDBEdit;
    Label16: TLabel;
    EditForeignPC: TDBEdit;
    Label18: TLabel;
    EditPhone: TDBEdit;
    Label19: TLabel;
    EditPhoneWork: TDBEdit;
    Label20: TLabel;
    EditPhoneFax: TDBEdit;
    Label21: TLabel;
    EditPhoneOther: TDBEdit;
    Label23: TLabel;
    Label24: TLabel;
    EditEmail: TDBEdit;
    DBNavigator: TDBNavigator;
    Panel1: TPanel;
    DataSource1: TDataSource;
    Panel2: TPanel;
    tblAddress: TTable;
    dbmNotes: TDBMemo;
    Label1: TLabel;
    dblcType: TDBLookupCombo;
    DataSource2: TDataSource;
    tblTypes: TTable;
    tblAddressNumber: TIntegerField;
    tblAddressPrefix: TStringField;
    tblAddressLName: TStringField;
    tblAddressMName: TStringField;
    tblAddressFName: TStringField;
    tblAddressSuffix: TStringField;
    tblAddressCompany: TStringField;
    tblAddressTitle: TStringField;
    tblAddressAddress1: TStringField;
    tblAddressAddress2: TStringField;
    tblAddressCity: TStringField;
    tblAddressState: TStringField;
    tblAddressZip: TStringField;
    tblAddressZip4: TStringField;
    tblAddressForeignCountry: TStringField;
    tblAddressForeignPC: TStringField;
    tblAddressGender: TStringField;
    tblAddressPhone: TStringField;
    tblAddressPhoneWork: TStringField;
    tblAddressPhoneFax: TStringField;
    tblAddressPhoneOther: TStringField;
    tblAddressType: TStringField;
    tblAddressNotes: TMemoField;
    tblAddressEmail: TStringField;
    edtSearch: TEdit;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Exit1: TMenuItem;
    Panel3: TPanel;
    ScrollBox1: TScrollBox;
    Timer1: TTimer;
    DateTime: TLabel;
    Preferences1: TMenuItem;
    Alwaysontop1: TMenuItem;
    Hints1: TMenuItem;
    Edit1: TMenuItem;
    N1: TMenuItem;
    Addresstypes1: TMenuItem;
    Cut1: TMenuItem;
    Copy1: TMenuItem;
    Paste1: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure DataSource1DataChange(Sender: TObject; Field: TField);
    procedure Exit1Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure edtSearchChange(Sender: TObject);
    procedure Hints1Click(Sender: TObject);
    procedure Alwaysontop1Click(Sender: TObject);
    procedure Addresstypes1Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure Copy1Click(Sender: TObject);
    procedure Paste1Click(Sender: TObject);
    procedure Cut1Click(Sender: TObject);
  private
    { private declarations }
  public
    { public declarations }
  end;

var
  FormAddress: TFormAddress;

implementation

{$R *.DFM}

procedure TFormAddress.FormCreate(Sender: TObject);
begin
  tblAddress.Open;
  tblTypes.Open;

end;

procedure TFormAddress.FormActivate(Sender: TObject);
begin
edtSearch.SetFocus;
Hints1.Checked := True;
end;

procedure TFormAddress.DataSource1DataChange(Sender: TObject;
  Field: TField);
begin
FormAddress.Caption :=
tblAddressPrefix.AsString + ' ' +
tblAddressFName.AsString + ' ' +
tblAddressMName.AsSTring +  ' ' +
tblAddressLname.AsString +  ' ' +
tblAddressSuffix.AsString + ' - ' +
tblAddressPhone.AsString + ' ' +
tblAddressPhoneWork.AsString + ' ' +
tblAddressPhoneOther.AsString+ ' ';
end;

procedure TFormAddress.Exit1Click(Sender: TObject);
begin
FormAddress.Close
end;

procedure TFormAddress.Timer1Timer(Sender: TObject);
begin
DateTime.Caption := DateTimeToStr(now);
end;

procedure TFormAddress.edtSearchChange(Sender: TObject);
begin
tblAddress.FindNearest([edtSearch.Text]);
end;

procedure TFormAddress.Hints1Click(Sender: TObject);
begin
Hints1.Checked := not Hints1.Checked;

if Hints1.Checked then
 Application.ShowHint := True
else
 Application.ShowHint := False;

end;

procedure TFormAddress.Alwaysontop1Click(Sender: TObject);
begin

AlwaysOnTop1.Checked := not AlwaysOnTop1.Checked;

if AlwaysOnTop1.Checked then
 FormStyle := fsStayOntop
else
 FormStyle := fsNormal;
end;

procedure TFormAddress.Addresstypes1Click(Sender: TObject);
begin
FormAddressTypes.Show;
end;

procedure TFormAddress.BitBtn1Click(Sender: TObject);
begin
ddeServerItem1.Lines[0] := EditLname.text;
ddeServerItem1.Lines[1] := EditFname.text;
EditLname.CopyToClipboard;
end;

procedure TFormAddress.Copy1Click(Sender: TObject);
begin

dbmNotes.CopyToClipboard
end;

procedure TFormAddress.Paste1Click(Sender: TObject);
begin
dbmNotes.PasteFromClipboard
end;

procedure TFormAddress.Cut1Click(Sender: TObject);
begin
dbmNotes.CutToClipboard
end;

end.
