unit ABC1Reg;
(*******************************************************************************

Advanced Business Components
ABC for Delphi
Version 1.0a

Copyright (c) 1995 Objective Software Technology Pty Ltd
Functionality derived from Delphi VCL Source Code
is Copyright (c) 1995 Borland International

Components Registered by this file:

TDBTableGrid:       Aggregate Table/Datasource/Grid/Navigator
TDBQueryGrid:       Aggregate Query/Datasource/Grid/Navigator
TDBSuperNav:        Super fast DBNavigator with speed control, moveby and bookmarks
TDBEditLabel:       Aggregate TDBEdit and TLabel component
TDBRecordCount:     Datasource connected label showing recordcount and Paradox logical record position
TDBState:           Datasource connected label showing current state information

TAppException:      Application global exception handling and logging component
TDBAppException:    Application global exception handling and logging component
                    with database message lookup and logging

TClockLabel:        Label showing date/time information
TSuperLabel:        Label with extended alignment and border options
TAutoLabel:         Label with border and auto separator character
TEditLabel:         Aggregate Label and Edit component
TPopupSelect:       Edit Box with popup menu selection
TBackground:        Shaded background bitmap
TMDIBackground:     Client aligned TBackground for MDI main forms
TTiledImage:        Image component supporting tiling and other alignment effects
TMDITiledImage:     Client aligned TiledImage component for MDI main forms
TPicBtn:            Custom BitBtn supports BMP, ICO or WMF format glyphs
TPicSpeedBtn:       Custom SpeedButton supports BMP, ICO or WMF format glyphs
TRepSpeedBtn:       Custom PicSpeedBtn supports AutoRepeat functionality
TMouseRegion:       Transparent button for registering mouse events over pictures

TStopWatch:         Performance tuning component to report and log execution times

TLauncher:          Launches at command line at a specified date and time.
TRSExit:            Component to close down ReportSmith when your App exits.
TSingleInstance:    Component to ensure single instance of your application
TWin3D:             Component for subclassing all Windows dialogs in CTL3D style.
TWinAbout:          Standard Windows About dialog box
TWinMsgBox:         Component wrapper for Windows MessageBox function

New in Version 1.0a:
TDBFixedGrid:     DBGrid with optional fixed columns and bug in FixedColor property corrected.
TSubQuery:        Component registered with no icon for query embedded within TDBQueryGrid.
TSubTable:        Component registered with no icon for table embedded within TDBTableGrid.
TSubDataSource:   Component registered with no icon for datasource embedded in TDBQueryGrid & TDBTableGrid.
TMDIScroll:       Disables or enables scroll bars on MDI Main forms.
*******************************************************************************)
interface

uses Classes, DsgnIntf, ABC1Prop;

procedure Register;

implementation

uses SysUtils, Forms, Dialogs, Qbinddlg , strEdit, dsDesign, QBE, DBConsts, DB, DBTables,
     ABCExcep, ABCDBCtl, ABCDBGrd, ABCExCtl, ABCUtil, StopWtch;

{Register}

procedure Register;
begin
  RegisterPropertyEditor(TypeInfo(TFileName), TExcepLog, 'FileName', TExcepLogFileNameProperty);
  RegisterPropertyEditor(TypeInfo(TFileName), TDBAppException, 'DatabaseName', TAppExcDatabaseNameProperty);
  RegisterPropertyEditor(TypeInfo(TFileName), TDBAppException, 'MsgTableName', TMsgTableNameProperty);
  RegisterPropertyEditor(TypeInfo(TFileName), TDBAppException, 'LogTableName', TLogTableNameProperty);
  RegisterComponentEditor(TDBAppException, TDBAppExceptionEditor);
  RegisterPropertyEditor(TypeInfo(string), TClockLabel, 'Format', TDateTimeFormatProperty);
  RegisterPropertyEditor(TypeInfo(TFileName), TDBQueryGrid, 'A1DatabaseName', TDatabaseNameProperty);
  RegisterPropertyEditor(TypeInfo(TStrings), TDBQueryGrid, 'A2SQL', TQuerySQLProperty);
  RegisterPropertyEditor(TypeInfo(Boolean), TDBQueryGrid, 'A3Active', TActiveProperty);
  RegisterPropertyEditor(TypeInfo(TParams), TDBQueryGrid, 'Params', TQueryParamsProperty);
  RegisterComponentEditor(TDBQueryGrid, TQueryEditor);
  RegisterPropertyEditor(TypeInfo(TFileName), TDBTableGrid, 'A1DatabaseName', TDatabaseNameProperty);
  RegisterPropertyEditor(TypeInfo(TFileName), TDBTableGrid, 'A2TableName', TTableNameProperty);
  RegisterPropertyEditor(TypeInfo(Boolean), TDBTableGrid, 'A3Active', TActiveProperty);
  RegisterPropertyEditor(TypeInfo(TDataSource), TDBTableGrid, 'MasterSource', TMasterSourceProperty);
  RegisterPropertyEditor(TypeInfo(string), TDBTableGrid, 'IndexName', TIndexNameProperty);
  RegisterPropertyEditor(TypeInfo(string), TDBTableGrid, 'IndexFieldNames', TIndexFieldNamesProperty);
  RegisterComponentEditor(TDBTableGrid, TABCDataSetEditor);
  RegisterPropertyEditor(TypeInfo(string), TDBEditLabel, 'DataField', TDataFieldProperty);
  RegisterPropertyEditor(TypeInfo(TDataSource), TDBEditLabel, 'DataSource', TDataSourceProperty);
  RegisterComponentEditor(TAutoLabel, TAutoLabelEditor);
  RegisterPropertyEditor(TypeInfo(TFileName), TStopWatch, 'LogFile', TExcepLogFileNameProperty);

(*** VCN001 *******************************************************************)
  RegisterClass(TSubQuery);
  RegisterClass(TSubTable);
  RegisterClass(TSubDataSource);
  RegisterNoIcon([TSubQuery, TSubTable, TSubDataSource]);
(*** VCN001 *******************************************************************)

  RegisterComponents('ABC', [TAppException]);
  RegisterComponents('ABC', [TDBAppException]);
  RegisterComponents('ABC', [TStopWatch]);
  RegisterComponents('ABC', [TDBTableGrid]);
  RegisterComponents('ABC', [TDBQueryGrid]);
(*** VCN002 *******************************************************************)
  RegisterComponents('ABC', [TDBFixedGrid]);
(*** VCN002 *******************************************************************)
  RegisterComponents('ABC', [TDBSuperNav]);
  RegisterComponents('ABC', [TDBEditLabel]);
  RegisterComponents('ABC', [TDBRecordCount]);
  RegisterComponents('ABC', [TDBState]);
  RegisterComponents('ABC', [TClockLabel]);
  RegisterComponents('ABC', [TSuperLabel]);
  RegisterComponents('ABC', [TAutoLabel]);
  RegisterComponents('ABC', [TEditLabel]);
  RegisterComponents('ABC', [TPopupSelect]);
  RegisterComponents('ABC', [TBackground]);
  RegisterComponents('ABC', [TMDIBackground]);
  RegisterComponents('ABC', [TTiledImage]);
  RegisterComponents('ABC', [TMDITiledImage]);
(*** VCN006 *******************************************************************)
  RegisterComponents('ABC', [TMDIScroll]);
(*** VCN006 *******************************************************************)
  RegisterComponents('ABC', [TPicBtn]);
  RegisterComponents('ABC', [TPicSpeedBtn]);
  RegisterComponents('ABC', [TRepSpeedBtn]);
  RegisterComponents('ABC', [TMouseRegion]);
  RegisterComponents('ABC', [TSingleInstance]);
  RegisterComponents('ABC', [TLauncher]);
  RegisterComponents('ABC', [TRSExit]);
  RegisterComponents('ABC', [TWin3D]);
  RegisterComponents('ABC', [TWinAbout]);
  RegisterComponents('ABC', [TWinMsgBox]);

end;

end.
