; VIEW.LSP   by John Rutkowski of BOLDER Designs
;
; This expression will create five views based on the limits of the drawing.
; The views will be a quarter of the original drawing with one overall view.
; The view names will be:
;
;		ll	Lower left
;		lr	Lower right
;		ur	Upper right
;		ul	Upper left
;		c	Center
;		a	All
;
; You need to only run this routine once by typing the follwing at the Command:
; in ACAD.
;
;		(load "view")

(setq ll (getvar "limmin"))
(setq ur (getvar "limmax"))
	(setq llx (car ll))	;get x of Limit lower left
	(setq lly (cadr ll)) 	;get y of Limit lower left
	(setq urx (car ur))	;get x of limit upper right
	(setq ury (cadr ur))	;get y of limit upper right

(setq p1 (list    (/  (- (car ur) llx) 2)   (/  (- (cadr ur) lly) 2))) ;Middle of the drawing
(command "view" "w" "ll" ll p1)
(setq p2 (list  (car ll) (cadr ur)))
(command "view" "w" "ul" p2 p1)
(setq p3 (list  (car ur) (cadr ll)))
(command "view" "w" "lr" p3 p1)
(command "view" "w" "ur" ur p1)
(command "view" "w" "a" ur ll)
(setq p4 (list  (+ (* (- (car p3) llx) 0.25) llx)  
		(+ (* (- (cadr p2) lly) 0.75) llx)
	 ))
(setq p5 (list  (+ (* (- (car p3) llx) 0.75) llx)  
		(+ (* (- (cadr ur) lly) 0.25) llx)
	 ))
(command "view" "w" "c" p4 p5)
   