;VECTOR.LSP  copyright 1988  Mehrdad Soltani

(defun C:VECT()
   (setvar "CMDECHO" 0)
   (setq ty (getvar "OSMODE"))
   (setq rlay (getstring "\nLayer (existing) for resultant plot: "))
   (command "layer" "set" rlay "")
   (setq d  (getpoint "\nLocate new vector origin: "))
   (setvar "OSMODE" 2)
   (setq c  (getpoint "\nSelect first vector: "))
   (setvar "OSMODE" 1)
   (setq h  (getpoint "\nSelect head end: "))
   (setvar "OSMODE" 2)
   (setq val (getdist "\nEnter magnitude of first vector: "))
   (setq mx (- (nth 0 h) (nth 0 c)))
   (setq my (- (nth 1 h) (nth 1 c)))
   (setq hp (distance h c))
   (setq fact (/ val (* hp 2)))
   (setq p1 (list (- (nth 0 c) mx)  (- (nth 1 c) my)))
   (setq dx (- (nth 0 d) (nth 0 p1)))
   (setq dy (- (nth 1 d) (nth 1 p1)))
   (setq p1 (list (+ (nth 0 p1) dx)  (+ (nth 1 p1) dy)))
   (setq xmin (nth 0 p1))
   (setq ymin (nth 1 p1))
   (setq begin p1)
   (setq p2 (list (+ (nth 0 p1) (* 2 mx))  (+ (nth 1 p1) (* 2 my))))
   (setvar "OSMODE" 0)
   (command "line" p1 p2 "")
   (setq reflen (distance p1 p2))
   (setq x1 (* (/ mx hp) (/ reflen 10)))
   (setq x2 (* (/ my hp) (/ reflen 40)))
   (setq y1 (* (/ my hp) (/ reflen 10)))
   (setq y2 (* (/ mx hp) (/ reflen 40)))
   (setq a1 (list (- (+ (nth 0 p2) x2) x1) (- (- (nth 1 p2) y2) y1)))
   (setq a2 (list (- (- (nth 0 p2) x2) x1) (- (+ (nth 1 p2) y2) y1)))   
   (command "solid" p2 a1 a2 "" "")
   (setvar "OSMODE" 2)
   (while (setq c  (getpoint "\nSelect next vector: " ))
      (setq p1 p2)
      (if (< (nth 0 p1) xmin) (setq xmin (nth 0 p1)))
      (if (< (nth 1 p1) ymin) (setq ymin (nth 1 p1)))
      (setvar "OSMODE" 1)
      (setq h  (getpoint "\nSelect head end: " ))
      (setq mx (- (nth 0 h) (nth 0 c)))
      (setq my (- (nth 1 h) (nth 1 c)))
      (setq hp (distance h c))
      (setq p2 (list (+ (nth 0 p1) (* 2 mx))  (+ (nth 1 p1) (* 2 my))))
      (setq all (cons all p2))
      (setq end p2)
      (setvar "OSMODE" 0)
      (command "line" p1 p2 "")      
      (setq x1 (* (/ mx hp) (/ reflen 10)))
      (setq x2 (* (/ my hp) (/ reflen 40)))
      (setq y1 (* (/ my hp) (/ reflen 10)))
      (setq y2 (* (/ mx hp) (/ reflen 40)))
      (setq a1 (list (- (+ (nth 0 p2) x2) x1) (- (- (nth 1 p2) y2) y1)))
      (setq a2 (list (- (- (nth 0 p2) x2) x1) (- (+ (nth 1 p2) y2) y1)))   
      (command "solid" p2 a1 a2 "" "")
      (setvar "OSMODE" 2)
   )
   (if (< (nth 0 end) xmin) (setq xmin (nth 0 end)))
   (if (< (nth 1 end) ymin) (setq ymin (nth 1 end)))
   (setvar "OSMODE" 0)
   (command "line" begin end "")
   (setq mx (- (nth 0 end) (nth 0 begin)))
   (setq my (- (nth 1 end) (nth 1 begin)))
   (setq hp (distance end begin))
   (setq mag (* fact hp))
   (setq ang (angtos (angle begin end) 1 1))
   (setq x1 (* (/ mx hp) (/ reflen 10)))
   (setq x2 (* (/ my hp) (/ reflen 40)))
   (setq y1 (* (/ my hp) (/ reflen 10)))
   (setq y2 (* (/ mx hp) (/ reflen 40)))
   (setq a1 (list (- (+ (nth 0 end) x2) x1) (- (- (nth 1 end) y2) y1)))
   (setq a2 (list (- (- (nth 0 end) x2) x1) (- (+ (nth 1 end) y2) y1)))   
   (command "solid" end a1 a2 "" "")
   (setq offset (/ reflen 10))
   (command "text" "c" (list xmin (- ymin (* offset 1.5))) offset "0" (strcat "Resultant is " (rtos mag 2) " < " ang))
   (command "redraw")
   (setvar "OSMODE" ty)
)

