;;; Toms Layer Manager API
;;;
;;; TLM_SETLAYERSTATUS
;;; TLM_SETVPLAYERSTATUS
;;;
;;; 06 Feb 1995
;;; (c) 1995 by Thomas Berger
;;;
;;; Contact: CIS: Thomas Berger, 100326,2312
;;;
;;;
;;; About:
;;; TLM stores "named layer statuses" in DWG files. TLM offers full access
;;; to named layer statuses via DCL dialogs. The user can store and restore,
;;; import and export, and much more with named layer statuses.
;;;
;;; Some users missed an API to restore a named layer status from their
;;; own application or from their own menus without having to hassle with
;;; TLMs DCL dialogs.
;;;
;;; (TLM_SETLAYERSTATUS "name") restores the layer status "NAME" globally.
;;; If successfull the function returns the layer status name "NAME", otherwise
;;; it returns NIL
;;;
;;; (TLM_SETVPLAYERSTATUS "name") restores the layer status "NAME" to a viewport.
;;;	All OFF and/or FROZEN layers will be VP-FROZEN, other layer status information
;;; like colors or linetypes is ignored.
;;; If successfull the function returns the layer status name "NAME", otherwise
;;; it returns NIL



(defun tlm_setlayerstatus (statusname)
	(if (assoc (strcase statusname) tlm:layerstatus)
		(progn
			(tlm_ulr (cdr (assoc (strcase statusname) tlm:layerstatus)) nil nil nil)
			(strcase statusname)
		)
		(progn
			(alert (strcat "Toms Layer Manager\nlayer status: " (strcase statusname) " not found!"))
			nil
		)
	)
)

(defun tlm_setvplayerstatus (statusname)
	(if (assoc (strcase statusname) tlm:layerstatus)
		(progn
			(tlm_ulvr (cdr (assoc (strcase statusname) tlm:layerstatus)) nil nil)
			(strcase statusname)
		)
		(progn
			(alert (strcat "Toms Layer Manager\nlayer status: \"" (strcase statusname) "\" not found!"))
			nil
		)
	)
)
