;* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;*   Author -->  T.J. DiTullio                  Date :  3-25-95      *
;*   Program  :                            File Name : SOUND.LSP     *
;*   Language :  AutoLISP                                            *
;*   Description ->  Examples of using external functions to         *
;*                   add sounds to autolisp programs                 *
;* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

;;; Falling Sound
(defun fall ()
  (command "SHELL" "FALL")
)

;;; Bouncing Sound
(defun bounce ()
  (command "SHELL" "BOUNCE")
)

;;; Siren Sound
(defun siren ()
  (command "SHELL" "SIREN")
)

;;; Oscillating Sound
(defun klaxon ()
  (command "SHELL" "KLAXON")
)


;;; Sample Error Function
(defun sound_error (msg)
  (textpage)
  (fall)
  (princ "\n\n\n\n\n\n\n\n\n\n\n\n")
  (princ "\t\t\t\t  B O O M !!!")
  (repeat 5000 (* 10 100))
  (textpage)
  (setvar "CMDECHO" saved_cmdecho)
  (prin1)
)

;;; Sample Program
(defun c:sound ( / done saved_cmdecho choice)
  (setq saved_cmdecho (getvar "CMDECHO"))
  (setvar "CMDECHO" 0)

  (setq done nil)
  (while (not done)
    (textpage)
    (princ "\n\n           A sample AutoLISP program using SOUND")
    (princ   "\n                    By  T.J. DiTullio")
    (princ "\n\n\n\n")
    (princ   "\n                      List of Sounds")
    (princ   "\n                    ==================")
    (princ   "\n                        1. Falling")
    (princ   "\n                        2. Bouncing")
    (princ   "\n                        3. Siren")
    (princ   "\n                        4. Klaxon")
    (princ   "\n                        0. Quit")
    (princ "\n\n                 Enter Selection Number: ")
    (setq choice (getint))

    (cond
      ((= choice 1) (fall))
      ((= choice 2) (bounce))
      ((= choice 3) (siren))
      ((= choice 4) (klaxon))
      ((= choice 0) (setq done T))
    )
  ) ;while

  (princ     "\n\n           FATAL ERROR ;)  Program about to CRASH.")
  (getstring "\n\n                 Press <ENTER> to continue.")
  (sound_error "Exiting")
)
