
;  (ROUND NUM FRAC)  returns NUM rounded to the nearest FRAC.
;  Examples:  (ROUND 15.2 0.25) returns 15.25
;             (ROUND 15.1 0.25) returns 15.00

;  By Duff Kurland - Autodesk, Inc.   August 22, 1986

(defun round (num frac / over half)
   (setq half (/ frac 2.0))
   (setq over (rem num frac))    ; Get remainder
   (if (>= over half)
       (+ num frac (- over))     ; Round up
       (- num over)              ; Round down
   )
)
