;
; This Function takes a Pline and uses it as the center line
; of a road, It puts in the shoulders and then erases the pline.
; It is provided as an example of offset processing, note the 
; use of "LTSCALE" to componsate for varying Line Type Scale Factors
;
(defun c:Road ( / Ang1 Temp Temp1 Temp2 Cline Base 
                  Upper Lower Fcircle Side1 Side2)

   (setq Base (* (getvar "LTSCALE") 0.05))  ; Road Base Width = 0.1
   (setvar "blipmode" 0) (setvar "cmdecho" 0)
   (setq FCircle (* 2 pi)
         Cline (entsel "Select Road To Build ? "))
   (print Cline)
   (while (Cline)
      (progn
         (setq Temp (entnext (car Cline))
               Temp1 (cdr (assoc 10 (entget Temp)))
               Temp (entnext Temp)
               Temp2 (cdr (assoc 10 (entget Temp)))
               Ang1 (angle Temp1 Temp2)
               Side1 (+ ang1 (/ pi 2))
               Side1 (if (> Side1 Fcircle) (- Side1 Fcircle) (abs Side1)))
         (command "offset" (* Base 5) Temp1 (polar temp1 Side1 Base) "")
         (setq Upper (entlast)
               Side2 (- ang1 (/ pi 2))
               Side2 (if (< Side2 0) (- Fcircle (abs Side2)) (abs Side2)))
         (command "offset" (* Base 5) Temp1 Side2 (polar temp1 Side2 Base) "")
         (setq Lower (entlast))
         (entdel (car Cline))
         (setvar "blipmode" 1)
         (setq Cline nil))))
