;PROGRAM NAME: C:RECT

;PURPOSE:	Draws a rectangle as either a Line or Polyline

; Copyright (C) 1991, CAD Consulting Services
;	Programmer: Steve McGuinness:
; Home Phone: (203) 757-7365

; Permission to use, copy, modify, and distribute this software and its
; documentation for any purpose and without fee is hereby granted.  

;HISTORY LOG:
;	7-3-87 	 Steve McGuinness - Initial Coding
;	11-10-91 Steve McGuinness - Code Reduction

(defun C:RECT (/ c1 c2 option)
	(graphscr)
	(setq
		cmde (getvar "cmdecho")
		blip (getvar "blipmode")
	)
	(setvar "blipmode" 0)
	(initget 1)
	(setq C1 (getpoint "\nIndicate First Corner of Rectangle: "))
	(initget (+ 1 32))
	(setq C2 (getcorner C1 "\nIndicate Opposite Corner of Rectangle: "))
	(grdraw C1 (list (car C1)(cadr C2)) -1)
	(grdraw (list (car C1)(cadr C2)) C2 -1)
	(grdraw C2 (list (car C2)(cadr C1)) -1)
	(grdraw  (list (car C2)(cadr C1)) C1 -1)
	(initget "Line Polyline Exit")
	(setq option (getkword "\nDraw as (<Polyline>/Line/Exit): "))
	(setvar "cmdecho" 0)
	(cond
		((eq option "Exit")
			(princ "\nExit option chosen.")
			(grdraw C1 (list (car C1)(cadr C2)) -1)
			(grdraw (list (car C1)(cadr C2)) C2 -1)
			(grdraw C2 (list (car C2)(cadr C1)) -1)
			(grdraw  (list (car C2)(cadr C1)) C1 -1)
		)
		((eq option "Line")
			(command "line"
				C1 (list (car C1)(cadr C2))
				C2 (list (car C2)(cadr C1)) "C"
			)
		)
		((or (eq option nil)(eq option "Polyline"))
			(command "pline"
				C1 (list (car C1)(cadr C2))
				C2 (list (car C2)(cadr C1)) "C"
			)
		)
	)
	(setvar "cmdecho" cmde)
	(setvar "blipmode" blip)
	(princ)
)
