/*
  ***************************************************************
  |                          PROTOBOX                           |       
  |                         ==========                          |        
  |                        Version 1.05                         |        
  |                                                             |
  |                   CADGINEERING Consulting                   |
  |                Written by: Richard Littleton                |
  |                     September 24, 1992                      |
  |                                                             |        
  ***************************************************************
*/
dcl_settings : default_dcl_settings { audit_level = 3; }
protobox : dialog {
   value = "PROTOBOX" ;
   key = "main" ;
   width = 35 ;
   : row {
      : button {
         label = "Preview..." ;
         key = "preview" ;
         mnemonic = "P" ;
         height = 3 ;
      }
      : column {
         : button {
            label = "Code view..." ;
            key = "code_view" ;
            mnemonic = "v" ;
         }
         : button {
            label = "DCE view..." ;
            key = "dce_view" ;
            mnemonic = "D" ;
         }
      }
      : column {
         : row {
            : button {
               key = "swf" ;
               label = "Work File..." ;
               mnemonic = "W" ;
            }
            : button {
               key = "save_dwf" ;
               label = "Save DWF" ;
               mnemonic = "S" ;
            }
            : text {
               key = "dwfmods" ;
               width = 1 ;
            }            
         }
         : button {
            key = "rwf" ;
            label = "Recall Work File..." ;
            width = 27 ;
            fixed_width = true ;
            mnemonic = "F" ;
         }
      }
   }
   : boxed_row {
      : button {
         key = "save" ;
         label = "DCL File Name..." ;
         mnemonic = "N" ;
      }
      : button {
         key = "savedcl" ;
         label = "Save DCL" ;
         mnemonic = "L" ;
      }
      : edit_box {
         label = "Dialog Name: " ;
         key = "dname" ;
      }
   }
   : boxed_radio_row {
      key = "sel" ;
      label = "Semantic Audit Level:" ;
      value = "3" ;
      : radio_button {
         key = "0" ;
         label = "No checking" ;
      }
      : radio_button {
         key = "1" ;
         label = "Errors" ;
      }
      : radio_button {
         key = "2" ;
         label = "Warnings" ;
      }
      : radio_button {
         key = "3" ;
         label = "Hints" ;
      }
   }
   : row {
      : list_box {
         label = "Tiles: " ;
         key = "layers" ;
         value = "0" ;
         height = 10 ;
         width = 25 ;
         fixed_width = true ;
      }
      spacer_1 ;
      : column {
         spacer ;
         spacer ;
         spacer ;
         children_alignment = centered ;
         : button {
            key = "add" ;
            label = "Add" ;
            mnemonic = "A" ;
         }
         : button {
            key = "remove" ;
            label = "Remove" ;
            mnemonic = "R" ;
         }
         : button {
            key = "edit" ;
            label = "Edit" ;
            mnemonic = "E" ;
         }
         : button {
            key = "move_tile" ;
            label = "Move" ;
            mnemonic = "M" ;
         }
         : button {
            key = "subst" ;
            label = "Substitute" ;
            mnemonic = "u" ;
         }
         : button {
            key = "clear" ;
            label = "Clear" ;
            mnemonic = "C" ;
         }
      }
      spacer_1 ;
      : list_box {
         label = "Selected tiles: " ;
         key = "selected" ;
         value = "0" ;
         height = 10 ;
         width = 25 ;
         fixed_width = true ;
      }
   }
   spacer ;
   : column {
      children_alignment = centered ;
      : row {
         fixed_width = true ;
         : ok_button {
            label = "Close" ;
            mnemonic = "o" ;
         }
         spacer_1 ;
         help_button ;
         spacer_1 ;
         info_button ;
      }
   }
   errtile ;
}
//
//
input_dialog : dialog {
   key = "idd" ;
   value = "DIALOG BOX" ;
   initial_focus = "key" ;
   : row {
      : column {
         : boxed_column {
            pb_key ;
            pb_text ;
            pb_key_list ;
         }
         pb_label ;
         pb_value ;
      } // end of column
   } // end of row
   : edit_box {
      label = "Initial_focus:" ;
      key = "initial_focus" ;
   }
   spacer ;
   ok_cancel ;
   errtile ;
}
//
//
//    Next dialog definition is the input box for BUTTON's
//
input_button : dialog {
   key = "ibd" ;
   value = "BUTTON" ;
   initial_focus = "key" ;
   : row {
      : column {
         : boxed_column {
            pb_key ;
            pb_text ;
            pb_key_list ;
         }
         pb_label ;
         mnemonic ;
      } // end of column
      : boxed_column {
         pb_is_enabled ;
         pb_is_tab_stop ;
         pb_is_default ;
         pb_is_cancel ;
         align ;
      } // end of column
   } // end of row
   size_only ;
   spacer ;
   ok_cancel ;
   errtile ;
}
//
//
input_edit_box : dialog {
   key = "iebd" ;
   value = "EDIT BOX" ;
   initial_focus = "key" ;
   : row {
      : column {
         : boxed_column {
            pb_key ;
            pb_text ;
            pb_key_list ;
         }
         pb_label ;
         mnemonic ;
      } // end of column
      : boxed_column {
         pb_is_enabled ;
         pb_is_tab_stop ;
         pb_allow_accept ;
         pb_edit_limit ;
         pb_edit_width ;
         pb_value ;
         align ;
      } // end of column
   } // end of row
   size_only ;
   spacer ;
   ok_cancel ;
   errtile ;
}
//
//
input_list_box : dialog {
   key = "ilbd" ;
   value = "LIST BOX" ;
   initial_focus = "key" ;
   : row {
      : column {
         : boxed_column {
            pb_key ;
            pb_text ;
            pb_key_list ;
         }
         pb_label ;
         mnemonic ;
      } // end of column
      : boxed_column {
         pb_is_enabled ;
         pb_is_tab_stop ;
         pb_allow_accept ;
         : toggle {
            label = "Multiple_select" ;
            key = "multiple_select" ;
            value = "0" ;
         }
         pb_value ;
         align ;
      } // end of column
   } // end of row
   size_only ;
   : row {
      : edit_box {
         label = "List:" ;
         key = "boxlist" ;
      }
      : edit_box {
         label = "Tabs:" ;
         key = "tabs" ;
      }
   }
   spacer ;
   ok_cancel ;
   errtile ;
}
//
//
input_popup_list : dialog {
   key = "ipld" ;
   value = "POPUP LIST BOX" ;
   initial_focus = "key" ;
   : row {
      : column {
         : boxed_column {
            pb_key ;
            pb_text ;
            pb_key_list ;
         }
         pb_label ;
         mnemonic ;
      } // end of column
      : boxed_column {
         pb_is_enabled ;
         pb_is_tab_stop ;
         pb_edit_width ;
         pb_value ;
         align ;
      } // end of column
   } // end of row
   size_only ;
   : row {
      : edit_box {
         label = "List:" ;
         key = "boxlist" ;
      }
      : edit_box {
         label = "Tabs:" ;
         key = "tabs" ;
      }
   }
   spacer ;
   ok_cancel ;
   errtile ;
}
//
//
input_toggle : dialog {
   key = "itd" ;
   value = "TOGGLE" ;
   initial_focus = "key" ;
   : row {
      : column {
         : boxed_column {
            pb_key ;
            pb_text ;
            pb_key_list ;
         }
         pb_label ;
         mnemonic ;
      } // end of column
      : boxed_column {
         pb_is_enabled ;
         pb_is_tab_stop ;
         pb_value ;
         align ;
      } // end of column
   } // end of row
   size_only ;
   spacer ;
   ok_cancel ;
   errtile ;
}
//
//
input_image : dialog {
   key = "iid" ;
   value = "IMAGE" ;
   initial_focus = "key" ;
   : row {
      : column {
         : boxed_column {
            fixed_height = true ;
            pb_key ;
            pb_text ;
            pb_key_list ;
         }
      } // end of column
      : boxed_column {
         : row {
            : button {
               key = "b_color" ;
               label = "Color..." ;
               mnemonic = "C" ;
               width = 8 ;
               fixed_width = true ;
            }
            : edit_box {
               key = "manual_color" ;
            }
            : swatch {
               key = "color_image" ;
            }
         }
         : popup_list {
            key = "color" ;
            value = "12" ;
         }
         : edit_box {
            label = "Aspect_ratio:" ;
            key = "aspect_ratio" ;
         }
         align ;
      } // end of column
   } // end of row
   size_only ;
   spacer ;
   ok_cancel ;
   errtile ;
}
//
//
input_image_button : dialog {
   key = "iibd" ;
   value = "IMAGE BUTTON" ;
   initial_focus = "key" ;
   : row {
      : column {
         : boxed_column {
            pb_key ;
            pb_text ;
            pb_key_list ;
         }
         : boxed_column {
            pb_is_enabled ;
            pb_is_tab_stop ;
            pb_allow_accept ;
         }
      } // end of column
      : boxed_column {
         : row {

            : button {
               key = "b_color" ;
               label = "Color..." ;
               mnemonic = "C" ;
               width = 8 ;
               fixed_width = true ;
            }
            : edit_box {
               key = "manual_color" ;
            }
            : swatch {
               key = "color_image" ;
            }
         }
         : popup_list {
            key = "color" ;
            value = "12" ;
         }
         : edit_box {
            label = "Aspect_ratio:" ;
            key = "aspect_ratio" ;
         }
         align ;
      } // end of column
   } // end of row
   size_only ;
   spacer ;
   ok_cancel ;
   errtile ;
}
//
//
input_slider : dialog {
   key = "isd" ;
   value = "SLIDER" ;
   initial_focus = "key" ;
   : row {
      : column {
         : boxed_column {
            fixed_height = true ;
            pb_key ;
            pb_text ;
            pb_key_list ;
         }
         : edit_box {
            label = "Big_increment:" ;
            key = "big_increment" ;
         }
         : edit_box {
            label = "Small_increment:" ;
            key = "small_increment" ;
         }
         : boxed_radio_column {
            label = "Layout:" ;
            key = "layout" ;
            value = "horizontal" ;
            : radio_button {
               label = "Horizontal" ;
               key = "horizontal" ;
            }
            : radio_button {
               label = "Vertical" ;
               key = "vertical" ;
            }
         }
      } // end of column
      : boxed_column {
         pb_is_enabled ;
         pb_is_tab_stop ;
         pb_value ;
         : edit_box {
            label = "Max_value:" ;
            key = "max_value" ;
         }
         : edit_box {
            label = "Min_value:" ;
            key = "min_value" ;
         }
         align ;
      } // end of column
   } // end of row
   size_only ;
   spacer ;
   ok_cancel ;
   errtile ;
}
//
//
input_text : dialog {
   key = "itxtd" ;
   value = "TEXT" ;
   initial_focus = "key" ;
   : row {
      : column {
         : boxed_column {
            pb_key ;
            pb_text ;
            pb_key_list ;
         }
      } // end of column
      : boxed_column {
         pb_is_enabled ;
         pb_is_tab_stop ;
         : toggle {
            label = "Is_bold" ;
            key = "ib" ;
            value = "0" ; 
         }
         align ;
      } // end of column
   } // end of row
   pb_label ;
   pb_value ;
   size_only ;
   spacer ;
   ok_cancel ;
   errtile ;
}
//
//
input_row : dialog {
   key = "ird" ;
   value = "ROW" ;
   : row {
      : column {
         : boxed_column {
            pb_key ;
            pb_text ;
            : row {
               pb_key_list ;
               pb_value ;
            }
         }
         size_only ;
         : row {
            : column {
               pb_cfw ;
               pb_cfh ;
            }
            : column {
               pb_is_enabled ;
               pb_is_tab_stop ;
            }
         }
         align ;
      }
      : spacer_1 { width = 2 ; }
      pb_end_of_row ;
   }
   : spacer { height = 1 ; }
   ok_cancel ;
   errtile ;
}
//
//
input_boxed_row : dialog {
   key = "ibrd" ;
   value = "BOXED ROW" ;
   initial_focus = "accept" ;
   : row {
      : column {
         : boxed_column {
            pb_key ;
            pb_text ;
            : row {
               pb_key_list ;
               pb_value ;
            }
         }
         pb_label ;
         size_only ;
         : row {
            : column {
               pb_cfw ;
               pb_cfh ;
            }
            : column {
               pb_is_enabled ;
               pb_is_tab_stop ;
            }
         }
         align ;
      } // end of column
      pb_end_of_row ;
   } 
   ok_cancel ;
   errtile ;
}
//
//
input_column : dialog {
   key = "icd" ;
   value = "COLUMN" ;
   : row {
      : column {
         : boxed_column {
            pb_key ;
            pb_text ;
            : row {
               pb_key_list ;
               pb_value ;
            }
         }
         size_only ;
         : row {
            : column {
               pb_cfw ;
               pb_cfh ;
            }
            : column {
               pb_is_enabled ;
               pb_is_tab_stop ;
            }
         }
         align ;
      }
      : spacer_1 {
         width = 2 ;
      }
      pb_end_of_row ;
   }
   : spacer {
      height = 1 ;
   }
   ok_cancel ;
   errtile ;
}
//
//
input_boxed_column : dialog {
   key = "ibcd" ;
   value = "BOXED COLUMN" ;
   initial_focus = "accept" ;
   : row {
      : column {
         : boxed_column {
            pb_key ;
            pb_text ;
            : row {
               pb_key_list ;
               pb_value ;
            }
         }
         pb_label ;
         size_only ;
         : row {
            : column {
               pb_cfw ;
               pb_cfh ;
            }
            : column {
               pb_is_enabled ;
               pb_is_tab_stop ;
            }
         }
         align ;
      } // end of column
      pb_end_of_row ;
   } 
   ok_cancel ;
   errtile ;
}
//
//
input_radio : dialog {
   label = "RADIO BUTTON" ;
   initial_focus = "key" ;
   : row {
      : column {
         : boxed_column {
            pb_key ;
            pb_text ;
            pb_key_list ;
         }
         pb_label ;
      } // end of column
      : boxed_column {
         pb_is_enabled ;
         pb_is_tab_stop ;
         align ;
      } // end of column
   } // end of row
   size_only ;
   spacer ;
   ok_cancel ;
   errtile ;
}
//
//
size : boxed_row {
   : column {
      : toggle {
         label = "Fixed_width:" ;
         key = "fw" ;
         value = "0" ;
         fixed_width = true ;
         width = 20 ;
      }
      : edit_box {
         label = "Width:" ;
         key = "width" ;
         fixed_width = true ;
         width = 20 ;
      }
      : slider {
         key = "width_slider" ;
         min_value = 1 ;
         max_value = 100 ;
         fixed_width = true ;
         width = 20 ;
      }
   }
   : column {
      : toggle {
         label = "Fixed_height:" ;
         key = "fh" ;
         value = "0" ;
         fixed_width = true ;
         width = 20 ;
      }
      : edit_box {
         label = "Height:" ;
         key = "height" ;
         fixed_width = true ;
         width = 20 ;
      }
      : slider {
         key = "height_slider" ;
         min_value = 1 ;
         max_value = 20 ;
         fixed_width = true ;
         width = 20 ;
      }
   }
   : boxed_radio_column {
      label = "Alignment:" ;
      key = "al" ;
      value = "alcentered" ;
      fixed_width = true ;
      width = 12 ;  
      : radio_button {  
         label = "Centered" ;
         key = "alcentered" ;
      }
      : radio_button {
         label = "Top" ;
         key = "altop" ;
      } 
      : radio_button {
         label = "Bottom" ;
         key = "albottom" ;
      } 
   }
}
size_only : boxed_row {
   : column {
      : toggle {
         label = "Fixed_width:" ;
         key = "fw" ;
         value = "0" ;
         fixed_width = true ;
         width = 20 ;
      }
      : edit_box {
         label = "Width:" ;
         key = "width" ;
         fixed_width = true ;
         width = 20 ;
      }
      : slider {
         key = "width_slider" ;
         min_value = 1 ;
         max_value = 100 ;
         fixed_width = true ;
         width = 20 ;
      }
   }
   : column {
      : toggle {
         label = "Fixed_height:" ;
         key = "fh" ;
         value = "0" ;
         fixed_width = true ;
         width = 20 ;
      }
      : edit_box {
         label = "Height:" ;
         key = "height" ;
         fixed_width = true ;
         width = 20 ;
      }
      : slider {
         key = "height_slider" ;
         min_value = 1 ;
         max_value = 20 ;
         fixed_width = true ;
         width = 20 ;
      }
   }

}
align : button {
   label = "Alignment..." ;
   key = "alignment" ;
   mnemonic = "A" ;
   width = 12 ;
   fixed_width = true ;
}
//
//
ralign : dialog {
   label = "ROW ALIGNMENT" ;
   ralign_only ;
   ok_cancel ;
}
ch_ralign_r : dialog {
   label = "ROW ALIGNMENT" ;
   : row {
      child_ralign ;
      ralign_only ;
   }
   ok_cancel ;
}
ch_ralign_c : dialog {
   label = "ROW ALIGNMENT" ;
   : row {
      child_ralign ;
      calign_only ;
   }
   ok_cancel ;
}
ralign_only : boxed_radio_column {
      label = "Alignment:" ;
      key = "al" ;
      value = "default" ;
      fixed_width = true ;
      width = 12 ; 
      : radio_button {  
         label = "Default" ;
         key = "default" ;
      } 
      : radio_button {  
         label = "Centered" ;
         key = "centered" ;
      }
      : radio_button {
         label = "Top" ;
         key = "top" ;
      } 
      : radio_button {
         label = "Bottom" ;
         key = "bottom" ;
      } 
}
calign : dialog {
   label = "COLUMN ALIGNMENT" ;
   calign_only ;
   ok_cancel ;
}
ch_calign_c : dialog {
   label = "COLUMN ALIGNMENT" ;
   : row {
      child_calign ;
      calign_only ;
   }
   ok_cancel ;
}
ch_calign_r : dialog {
   label = "COLUMN ALIGNMENT" ;
   : row {
      child_calign ;
      ralign_only ;
   }
   ok_cancel ;
}
calign_only : boxed_radio_column {
      label = "Alignment:" ;
      key = "al" ;
      value = "default" ;
      fixed_width = true ;
      width = 12 ;  
      : radio_button {  
         label = "Default" ;
         key = "default" ;
      } 
      : radio_button {  
         label = "Left" ;
         key = "left" ;
      }
      : radio_button {
         label = "Right" ;
         key = "right" ;
      } 
      : radio_button {
         label = "Centered" ;
         key = "centered" ;
      } 
}
child_ralign : boxed_radio_column {
      label = "Children_alignment:" ;
      key = "cal" ;
      value = "caldefault" ;
      fixed_width = true ;
      width = 12 ;  
      : radio_button {  
         label = "Default" ;
         key = "caldefault" ;
      }
      : radio_button {  
         label = "Centered" ;
         key = "calcentered" ;
      }
      : radio_button {
         label = "Top" ;
         key = "caltop" ;
      } 
      : radio_button {
         label = "Bottom" ;
         key = "calbottom" ;
      } 
}
child_calign : boxed_radio_column {
      label = "Children_alignment:" ;
      key = "cal" ;
      value = "caldefault" ;
      fixed_width = true ;
      width = 12 ;  
      : radio_button {  
         label = "Default" ;
         key = "caldefault" ;
      } 
      : radio_button {  
         label = "Left" ;
         key = "calleft" ;
      }
      : radio_button {
         label = "Right" ;
         key = "calright" ;
      } 
      : radio_button {
         label = "Centered" ;
         key = "calcentered" ;
      } 
}
//


//
mnemonic : row {
  key = "mnemkey" ;
  : boxed_row {
     fixed_width = true ;
     width = 20 ;
     : edit_box {
        label = "Mnemonic:" ;
        key = "mnemonic" ;
        edit_width = 2 ;
        fixed_width = true ;
        width = 10 ;
     }
     : slider {
        key = "mnem_slider" ;
        min_value = 1 ;
        max_value = 52 ;
        small_increment = 1;
        big_increment = 1;
        fixed_width = true ;
        width = 15 ;
     }
  }
}
//
//
code_view : dialog {
   label = "CODE VIEW" ;
   : row {
      : text {
         label = "DCL FILE NAME: " ;
      }
      : text {
         key = "dclname" ;
         width = 30 ;
      }
   }
   : row {
      : text {
         label = "DIALOG BOX NAME: " ;
      }
      : text {
         key = "dianame" ;
         width = 30 ;
      }
   }
   : list_box {
      key = "view_box" ;
      width = 65 ;
      height = 20 ;
   }
   ok_only ;
}
//
//
dce_view : dialog {
   label = "DIALOG ERROR VIEW" ;
   : list_box {
      key = "view_box" ;
      width = 75 ;
      height = 20 ;
   }
   ok_only ;
}
//
//
proto_warning : dialog {
   label = "WARNING";
   initial_focus = "cancel" ;
   : column {
       : text {
           value = "Are you sure you want to clear the DCL list?" ;
           width = 60 ;
           alignment = centered ;
       }
       : row {
          fixed_width = true ;
          alignment = centered ;
           : button {
               label = "Clear List" ;
               is_default = true ;
               mnemonic = "L" ;
               key = "affirmative" ;
               fixed_width = true ;
               width = 15 ;
           }
           : button {
               label = "Cancel" ;
               is_cancel = true ;
               mnemonic = "C" ;
               key = "cancel" ;
               fixed_width = true ;
               width = 15 ;
           }
       }
   }
}
//
//
file_close : dialog {
   label = "Exit PROTOBOX" ;
   : column {
      children_alignment = centered ;
      : text {
         label = "Modifications have occured." ;
      }
      : text {
         label = "Save the DCL and DWF files?" ;
      }
      : text {
         key = "dclname" ;
         width = 5 ;
      }
      : text {
         key = "dwfname" ;
         width = 5 ;
      }
   }
   spacer ;
   : row {
      : button {
         key = "s_both" ;
         label = "Save Both" ;
         mnemonic = "B" ;
      }
      : button {
         key = "s_dwf" ;
         label = "Save DWF" ;
         mnemonic = "D" ;
      }
      : button {
         key = "s_dcl" ;
         label = "Save DCL" ;
         mnemonic = "C" ;
      }
   }
   : row {
      : column { 
         : button {
            key = "disregard" ;
            label = "Exit Anyway" ;
            mnemonic = "E" ;
            width = 15 ;
            fixed_width = true ;
            alignment = right ;
         }
      }
      : column {
         : cancel_button {
            alignment = left ;
         }
      }
   }
}
//
//
move_tile : dialog {
   label = "MOVE" ;
   : row {
      : list_box {
         multiple_select = true ;
         key = "from" ;
         label = "From:" ;
         width = 20 ;
         height = 15 ;
      }
      : spacer_1 { width = 2 ;}
      : column {
         fixed_height = true ;
         : button {
            key = "move" ;
            label = "Move" ;
            mnemonic = "M" ;
            height = 3 ;
         }
      }
      : spacer_1 { width = 2 ;}
      : list_box {
         allow_accept = true ;
         key = "to" ;
         label = "To:" ;
         width = 20 ;
         height = 15 ;
      }
   }
   spacer_1 ;
   ok_cancel ;
   errtile ;
}
//
//
input_comment : dialog {
   label = "COMMENTS" ;
   : edit_box {
      allow_accept = true ;
      edit_limit = 65 ;
      key = "comment1" ;
      label = "Comment:" ;
      width = 75 ;
   }
   : edit_box {
      allow_accept = true ;
      edit_limit = 65 ;
      key = "comment2" ;
      label = "Comment:" ;
      width = 65 ;
   }
   : edit_box {
      allow_accept = true ;
      edit_limit = 65 ;
      key = "comment3" ;
      label = "Comment:" ;
      width = 65 ;
   }
   : edit_box {
      allow_accept = true ;
      edit_limit = 65 ;
      key = "comment4" ;
      label = "Comment:" ;
      width = 65 ;
   }
   : edit_box {
      allow_accept = true ;
      edit_limit = 65 ;
      key = "comment5" ;
      label = "Comment:" ;
      width = 65 ;
   }
   spacer_1 ;
   ok_cancel ;
   errtile ;
}
//
info_box : dialog {
   label = "ABOUT PROTOBOX..." ;
   : list_box {
      key = "info_box" ;
      width = 70 ;
      height = 20 ;
   }
   ok_only ;
}
//
//  Common elements to many of the dialog boxes
//
pb_key : edit_box {
   label = "Key:" ;
   key = "key" ;
}
pb_text : text {
   label = "Current values:" ;
}
pb_key_list : popup_list {
   key = "key_list" ;
   edit_width = 20 ;
   is_tab_stop = false ;
}
//
pb_label : edit_box {
   label = "Label:" ;
   key = "label" ;
}
pb_value : edit_box {
   label = "Value:" ;
   key = "value" ;
}
//
pb_is_enabled : toggle {
   label = "Is_enabled" ;
   key = "ie" ;
   value = "1" ;    
   fixed_width = true ;
   width = 12 ;  
}
pb_is_tab_stop : toggle {
   label = "Is_tab_stop" ;
   key = "ist" ;
   value = "1" ; 
   fixed_width = true ;
   width = 12 ;      
}
pb_is_default : toggle {
   label = "Is_default" ;
   key = "id" ;
   value = "0" ;
   fixed_width = true ;
   width = 12 ;  
}
pb_is_cancel : toggle {
   label = "Is_cancel" ;
   key = "ic" ;
   value = "0" ;
   fixed_width = true ;
   width = 12 ;  
}
//
pb_allow_accept : toggle {
   label = "Allow_accept" ;
   key = "allow_accept" ;
   value = "0" ;
}
pb_edit_limit : edit_box {
   label = "Edit_Limit:" ;
   key = "edit_limit" ;
}
pb_edit_width : edit_box {
   label = "Edit_Width:" ;
   key = "edit_width" ;
}
//
pb_cfw : toggle {
   label = "Children_fixed_width" ;
   key = "children_fixed_width" ;
   value = "0" ;    
   fixed_width = true ;
   width = 12 ;  
}
pb_cfh : toggle {
   label = "Children_fixed_height" ;
   key = "children_fixed_height" ;
   value = "0" ; 
   fixed_width = true ;
   width = 12 ;      
}
//
pb_end_of_row : list_box {
   label = "End of row position:" ;
   key = "selected" ;
   value = "0";
   fixed_width = true ;
   fixed_height = true ;
   height = 15;
   width = 20 ;
}
//
