;For Version 2.18 
(Defun C:Bplate () 
       (Setvar "Cmdecho" 0) 
;-------------------------------INPUT
SECTION---------------------------------- 
       (Setq TAP nil) 
       (Setq TAPSTRING nil) 
       (Setq SIDE1 (Getreal "\nWhat is length of side 1: ")) 
       (Setq SIDE2 (Getreal "\nWhat is length of side 2: ")) 
       (Setq BOLTHOLE (Getreal "\nBolt hole size: ")) 
       (Setq TAP (Getstring "\nAre the holes tapped <N>: ")) 
       (If (= TAP "y") 
           (Setq TAP "Y") 
       ) 
       (If (= TAP "Y") 
           (Setq TAPSTRING (Getstring "\nEnter tap
specification:")) 
       ) 
       (If (/= TAP "Y") 
           (Setq TAPSTRING (Rtos BOLTHOLE 2 2)) 
       ) 
       (Setq CRADIUS (Getreal "\nCorner radius: ")) 
       (If (> BOLTHOLE CRADIUS) 
           (Setq INSET (Getreal "\nEnter bolt hole inset: ")) 
           (Setq INSET CRADIUS) 
       ) 
       (Setq CHOLE (Getreal "\nCenter hole diameter: ")) 
       (Setq DS (Getreal "\nEnter the dimension scale: ")) 
;-------------SET SCREEN SIZE, LIMITS, GRID, LTSCALE, AND DIMSCALE------------- 
       (Setq LOWER (List (* DS -5) (* DS -5))) 
       (Setq UPPER (List (+ (* 5 DS) SIDE1) (+ (* 5 DS) SIDE2))) 
       (Command "Zoom" "W" LOWER UPPER) 
       (Command "Limits" LOWER UPPER) 
       (Command "Units" 2 2 2 4) 
       (Command "Grid" (* 2 DS)) 
       (Command "Dim" "Dimscale" DS) 
       (Setvar "Blipmode" 0) 
       (Setvar "Ltscale" DS) 
       (Command) 
;--------------------------------CORNER POINTS--------------------------------- 
       (Setq P1 (List 0 0)) 
       (Setq P2 (List SIDE1 0)) 
       (Setq P3 (List SIDE1 SIDE2)) 
       (Setq P4 (List 0 SIDE2))   
;--------------------------------DRAW OUTSIDE--------------------------------- 
       (command "Layer" "S" 1 "") 
       (Command "Pline" P1 P2 P3 P4 "Cl") 
       (Command "Fillet" "R" CRADIUS) 
       (Command "Fillet" "P" "Last") 
;----------------------------------HOLES---------------------------------------- 
       (Setq C1 (List INSET INSET)) 
       (Setq C2 (List (- Side1 INSET) INSET)) 
       (Setq C3 (List (- SIDE1 INSET) (- SIDE2 INSET))) 
       (Setq C4 (List INSET (- SIDE2 INSET))) 
;-------------------------------CENTER HOLE------------------------------------ 
       (Setq MPT (List (/ SIDE1 2) (/ SIDE2 2))) 
;----------------------------DRAW BOLT HOLES----------------------------------- 
       (Command "Circle" (List INSET INSET) "D" BOLTHOLE) 
       (Setq S1 (- SIDE1 (* 2 INSET))) 
       (Setq S2 (- SIDE2 (* 2 INSET))) 
       (Command "Array" "L" "" "R" 2 2 S2 S1) 
;----------------------------DRAW TAPPED HOLES--------------------------------- 
       (If (= TAP "Y")  
           (Progn 
                 (Command "Layer" "S" 2 "") 
                 (Command "Circle" (List INSET INSET) 
                          "D" (+ BOLTHOLE (/ DS 16)) 
                 ) 
                 (Setq S1 (- SIDE1 (* 2 INSET))) 
                 (Setq S2 (- SIDE2 (* 2 INSET))) 
                 (Command "Array" "L" "" "R" 2 2 S2 S1) 
           ) 
       ) 
;-----------------------------DRAW CENTER HOLE--------------------------------- 
       (Command "Layer" "S" 1 "") 
       (Command "Circle" MPT "D" CHOLE) 
;-----------------------------DIMENSION POINTS--------------------------------- 
       (Setq P5 (List 0 (- SIDE2 CRADIUS))) 
       (Setq P6 (List SIDE1 (- SIDE2 CRADIUS))) 
       (Setq P7 (List (- SIDE1 CRADIUS) SIDE2)) 
       (Setq P8 (List (- SIDE1 CRADIUS) 0)) 
       (Setq P9 (Polar MPT (/ Pi 4) (/ CHOLE 2))) 
       (Setq P10 (Polar C4 (/ Pi 4) (/ BOLTHOLE 2))) 
       (Setq P11 (List (+ (Car C4) INSET (/ DS 2)) 
             (+ (Cadr C4) INSET (/ DS 2))) 
       ) 
       (Setq P12 (Polar C1 (* Pi -0.75) CRADIUS)) 
       (Setq P13 (List (- 0.0 INSET (/ DS 2)) (- 0.0 INSET (/ DS 2)))) 
       (Setq P14 (List 0 CRADIUS)) 
       (Setq P15 (List Side1 CRADIUS)) 
       (Setq P16 (List CRADIUS 0)) 
       (Setq P17 (List CRADIUS SIDE2)) 
       (Setq P18 (List (* DS -2) 0)) 
;----------------------------------DIMENSIONS----------------------------------- 
       (Command "Layer" "S" 4 "") 
       (Setq DS (* 2 DS)) 
       (Command "Dim" "Hor" P5 C4 (List (Car P4) (+ (Cadr P4) DS)) "") 
       (Command "Cont" C3 "") 
       (Command "Cont" P6 "") 
       (Command "Ver" P7 C3 (List (+ (Car P3) DS) (Cadr P3)) "") 
       (Command "Cont" C2 "") 
       (Command "Cont" P8 "") 
       (Command "Dia" P9 "") 
       (Command "Lea" P10 P11 "" TAPSTRING) 
       (Setq CRADIUS (Rtos CRADIUS 2 2)) 
       (Command "Lea" P12 P13 "" CRADIUS) 
       (Command "Hor" P14 P15 P13 "") 
       (Command "Ver" P16 P17 P18 "") 
       (Command) 
) 
                                                                                