;baseline dimensioning by Jim Brittian 
;see BASELINE.DOC for more information 
;Version 2.5 only
 
(Vmon) 
 
(Setq BASE (Getpoint "\nPick point to base dimensions from: ")) 
(Setq TH (Getreal "Enter text height <RETURN IF FIXED>: ")) 
(If (= TH nil) 
    (Setq Z (* (Getvar "Textsize") 8)) 
    (Setq Z (* TH 8)) 
) 
 
(Defun Basehorz () 
       (Setq P2 (List (Car P2) (Cadr P1))) 
       (Setq A (Rtos (Abs (- (Cadr P1) (Cadr BASE))) (Getvar
"Lunits") 
                                                   (Getvar
"Luprec"))) 
       (If (<= (Car P2) (Car P1)) 
           (Progn 
                (Setq P1 (List (- (Car P1) (* 0.0625 Z)) (Cadr
P1))) 
                (Setq P3 (List (- (Car P2) (* 0.0625 Z)) 
                               (- (Cadr P2) (* 0.0625 Z)))) 
                (If (= TH nil) 
                    (Command "Text" "R" P3 "0" A) 
                    (Command "Text" "R" P3 (* 0.125 Z) "0" A) 
                ) 
           ) 
           (Progn 
                (Setq P1 (List (+ (Car P1) (* 0.0625 Z)) (Cadr
P1))) 
                (Setq P3 (List (+ (Car P2) (* 0.0625 Z)) 
                               (- (Cadr P2) (* 0.0625 Z)))) 
                (If (= TH nil) 
                    (Command "Text" P3 "0" A) 
                    (Command "Text" P3 (* 0.125 Z) "0" A) 
                ) 
           ) 
       ) 
       (Command "Line" P1 P2 "") 
) 
 
(Defun Basevert () 
       (Setq P2 (List (Car P1) (Cadr P2))) 
       (Setq A (Rtos (Abs (- (Car P1) (Car BASE))) (Getvar
"Lunits") 
                                                 (Getvar
"Luprec"))) 
       (If (<= (Cadr P2) (Cadr P1)) 
           (Progn 
                (Setq P1 (List (Car P1) (- (Cadr P1) (* 0.0625
Z)))) 
                (Setq P3 (List (+ (Car P2) (* 0.0625 Z)) 
                               (- (Cadr P2) (* 0.0625 Z)))) 
                (If (= TH nil) 
                    (Command "Text" "R" P3 "90" A) 
                    (Command "Text" "R" P3 (* 0.125 Z) "90" A) 
                ) 
           ) 
           (Progn 
                (Setq P1 (List (Car P1) (+ (Cadr P1) (* 0.0625
Z)))) 
                (Setq P3 (List (+ (Car P2) (* 0.0625 Z)) 
                               (+ (Cadr P2) (* 0.0625 Z)))) 
                (If (= TH nil) 
                    (Command "Text" P3 "90" A) 
                    (Command "Text" P3 (* 0.125 Z) "90" A) 
                ) 
           ) 
       ) 
       (Command "Line" P1 P2 "") 
) 
 
(Defun C:Baseorg () 
       (Setq BASE (Getpoint "\nPick point to base dimensions
from: ")) 
) 
 
(Defun C:Baseline () 
       (Setvar "Cmdecho" 0) 
       (Command "Osnap" "End,Int,Cen") 
       (Setq P1 (Getpoint "\nEnter first point: ")) 
       (Command "Osnap" "Off") 
       (Setq P2 (Getpoint "\nEnter second point: ")) 
       (If (> (Abs (- (Car P1) (Car P2))) (Abs (- (Cadr P1) (Cadr
P2)))) 
           (Basehorz) 
           (Basevert) 
       ) 
) 
                                                                               