(Defun C:Flange ()
       (Setvar "Cmdecho" 0)
       (Setq OR 0)
       (Setq IR 0)
       (Setq BC 0)
       (Setq P1 (Getpoint "\nEnter center of flange: "))
       (Setq OR (Getdist P1 "\nOutside radius: "))
       (Command "Circle" P1 OR)
       (Setq IR (Getdist P1 "\nInside radius: "))
       (While (> IR OR)
              (Prompt "\nInside radius larger than outside: ")
              (Setq IR (Getdist P1 "\nInside radius: "))
       )
       (Command "Circle" P1 IR)
       (Setq BAD 1)
       (While BAD
              (Setq A nil)
              (Setq B nil)
              (Setq BC (Getdist P1 "Bolt circle radius: "))
              (If (> BC OR) 
                  (Prompt "\nBolt circle larger than O.D.: ")
                  (Setq A T)
              )
              (If (< BC IR) 
                  (Prompt "\nBolt circle smaller than I.D.: ")
                  (Setq B T)
              )
              (If (and A B)
                  (Setq BAD nil)
              )
       )
       (Command "Circle" P1 BC)
       (Setq SH (Getreal "Bolt hole diameter: "))
       (Setq NHI (Getint "Number of bolt holes: "))
       (Setq NH (Float NHI))
       (Setq SA (Getangle P1 "Starting angle of first hole: "))
       (Command "Circle" (Polar P1 SA BC) "D" SH)
       (Command "Array" "L" "" "C" P1 (/ 360.0 NH) NHI "")
)
