;These are the functions in ACAD2.LSP:
;   1.  Rectangle at any angle (raa) 
;   2.  Spiral (spiral) 
;   3.  Clean Atomlist/Garbage Collection (kln) 
;   4.  Erase Last (EL) 
;   5.  Erase Window (EW) 
;   6.  Zoom Window (ZW) 
;   7.  Zoom Previous (ZP) 
;   8.  Draw Line (L) 
;   9.  Square at any angle (sq) 
;  10.  Convert Civil Units (conv) 
;  11.  Absolute scale of blocks (ascale) 
;  12.  Angled sequential numbers (an) 
;  13.  Slot (slot) 
;  14.  Change text style global (cs) 
;  15.  Extend (exd) 
;  16.  Step and Repeat (sr) 
;  17.  Flange (flange) 
;  18.  Parrallelogram  (paa) 
 
;1.  Draws a rectangle at any angle. 
(Defun C:Raa (/ P1 P2 P3 P4 A B) 
       (Setvar "Cmdecho" 0) 
       (Setq A (Getvar "Snapang")) 
       (Setq B (Getvar "Orthomode")) 
       (Setq P1 (Getpoint "\nFrom point: ")) 
       (Setq P2 (Getpoint P1 "\nTo point: ")) 
       (Command "Line" P1 P2 "") 
       (Setvar "Snapang" (Angle P1 P2)) 
       (Setvar "Orthomode" 1) 
       (Setq P3 (Getpoint P2 "\nTo point: ")) 
       (Setq P4 (Polar P3 (Angle P2 P1) (Distance P2 P1))) 
       (Command "Line" P2 P3 P4 P1 "") 
       (Setvar "Snapang" A) 
       (Setvar "Orthomode" B) 
) 
 
;2.  Function for spiral. 
(Defun Cspiral (NTIMES BPOINT CFAC LPPASS / ANG DIST TP AINC DINC
CIRCLE BS CS) 
       (Setq CS (Getvar "Cmdecho")) 
       (Setq BS (Getvar "Blipmode")) 
       (Setvar "Blipmode" 0) 
       (Setvar "Cmdecho" 0) 
       (Setq CIRCLE (* 3.141596235 2)) 
       (Setq AINC (/ CIRCLE LPPASS)) 
       (Setq DINC (/ CFAC LPPASS)) 
       (Setq ANG 0.0) 
       (Setq DIST 0.0) 
       (Command "Pline" BPOINT) 
       (Repeat NTIMES 
               (Repeat LPPASS 
                       (Setq TP (Polar BPOINT (Setq ANG (+ ANG
AINC)) 
                                (Setq DIST (+ DIST DINC)))) 
                       (Command TP) 
               ) 
       ) 
       (Command) 
       (Setvar "Blipmode" BS) 
       (Setvar "Cmdecho" CS) 
        nil 
) 
 
;   Interactive spiral generation. 
(Defun C:Spiral (/ NT BP CF LP) 
       (Prompt "\nCenter point: ") 
       (Setq BP (Getpoint)) 
       (Prompt "\nNumber of rotations: ") 
       (Setq NT (Getint)) 
       (Prompt "\nGrowth per rotation: ") 
       (Setq CF (Getdist BP)) 
       (Prompt "\nPoints per rotation: ") 
       (Setq LP (Getint)) 
       (Cond ((null LP) (Setq LP 30))) 
       (Cspiral NT BP CF LP) 
) 
 
;3.  Cleans the atomlist, freeing node space 
;    and does a garbage collection. 
(Defun C:Kln () 
       (Setq ATOMLIST (Member 'INTERS ATOMLIST)) 
       (GC) 
) 
 
;4.  Types "EL" to erase the last object. 
(Defun C:EL () 
       (Command "Erase" "L" "") 
) 
 
;5.  Types "EW" to erase a window. 
(Defun C:EW () 
       (Command "Erase" "W") 
) 
 
;6.  Types "ZW" to zoom a window. 
(Defun C:ZW () 
       (Command "Zoom" "W") 
) 
 
;7.  Types "ZP" to zoom previous. 
(Defun C:ZP () 
       (Command "Zoom" "P") 
) 
 
;8.  Types "L" to draw a line. 
(Defun C:L () 
       (Command "Line") 
) 
 
:9.  Draws a a square at any angle. 
(Defun C:Sq (/ P1 P2 P3 P4) 
       (Setq P1 (Getpoint "\nLower left corner: ")) 
       (Setq A (Getdist P1 "\nLength of one side: ")) 
       (Setq P2 (Polar P1 0.0 A)) 
       (Setq P3 (Polar P2 (/ Pi 2.0) A)) 
       (Setq P4 (Polar P3 Pi A)) 
       (Command "Line" P1 P2 P3 P4 "C") 
) 
 
;10.  Converts civil units (decimal feet)  
;     to architectural units (feet & inches). 
(Defun C:Conv (/ A B C D E F G H) 
       (Setq A (Getreal "Enter number to convert to feet and
inches: ")) 
       (Setq B (Fix A)) 
       (Setq C (- A B)) 
       (Setq C (* C 12)) 
       (Setq D (Fix C)) 
       (Setq C (- C D)) 
       (If (>= C 0.9688) (Setq E (Chr 34))) 
       (If (>= C 0.9688) (Setq D (+ D 1))) 
       (If (>= D 12) (Setq B (+ B 1))) 
       (If (>= D 12) (Setq D 0)) 
       (If (< C 0.9688) (Setq E (Strcat "15/16" (Chr 34)))) 
       (If (< C 0.9063) (Setq E (Strcat "7/8" (Chr 34)))) 
       (If (< C 0.8438) (Setq E (Strcat "13/16" (Chr 34)))) 
       (If (< C 0.7813) (Setq E (Strcat "3/4" (Chr 34)))) 
       (If (< C 0.7188) (Setq E (Strcat "11/16" (Chr 34)))) 
       (If (< C 0.6563) (Setq E (Strcat "5/8" (Chr 34)))) 
       (If (< C 0.5938) (Setq E (Strcat "9/16" (Chr 34)))) 
       (If (< C 0.5313) (Setq E (Strcat "1/2" (Chr 34)))) 
       (If (< C 0.4688) (Setq E (Strcat "7/16" (Chr 34)))) 
       (If (< C 0.4063) (Setq E (Strcat "3/8" (Chr 34)))) 
       (If (< C 0.3438) (Setq E (Strcat "5/16" (Chr 34)))) 
       (If (< C 0.2813) (Setq E (Strcat "1/4" (Chr 34)))) 
       (If (< C 0.2188) (Setq E (Strcat "3/16" (Chr 34)))) 
       (If (< C 0.1563) (Setq E (Strcat "1/8" (Chr 34)))) 
       (If (< C 0.0938) (Setq E (Strcat "1/16" (Chr 34)))) 
       (If (< C 0.0313) (Setq E (Chr 34))) 
       (Setq F (itoa B)) 
       (Setq G (itoa D)) 
       (Setq H "Conversion from decimal to feet and inches is: ")

       (Strcat H F (chr 39) (chr 45) G (chr 32) E (chr 32) (chr
32)) 
) 
 
;11.  Absolute scale - allows easy rescaling of blocks 
(Defun C:Ascale (/ A B C D E F G H) 
       (Setq A (Ssget)) 
       (Setq B (Sslength A)) 
       (Setq C (Getreal "\nEnter new scale: ")) 
       (While (> B 0) 
              (Setq B (1- B)) 
              (Setq D (Ssname A B)) 
              (Setq D (Entget D)) 
              (Setq E (Assoc 41 D)) 
              (Setq F (Assoc 42 D)) 
              (Setq G (Cons 41 C)) 
              (Setq H (Cons 42 C)) 
              (Setq D (Subst G E D)) 
              (Entmod (Setq D (Subst H F D))) 
       ) 
) 
 
;12.  Angled numbers. 
(Defun C:An (/ P1 A1 A B C D E F G) 
       (Setvar "Cmdecho" 0) 
       (Setq G (Getvar "Blipmode")) 
       (Setvar "Blipmode" 0) 
       (Setq A (Getint "\nNumber to start with: ")) 
       (Setq B (Getint "\nNumber to end with: ")) 
       (Setq P1 (Getpoint "\nStarting point: ")) 
       (Setq C (Getdist P1 "\nDistance between numbers: ")) 
       (Setq A1 (Getangle P1 "\nAngle to run numbers: ")) 
       (Setq D (Getdist P1 "\nText height: ")) 
       (If (> A B) 
           (Setq E -1) 
           (Setq E 1) 
       ) 
       (Repeat (+ 1 (Abs (- A B))) 
               (Setq F (Itoa A)) 
               (Command "Text" "C" P1 D 0 F) 
               (Setq A (+ A E)) 
               (Setq P1 (Polar P1 A1 C)) 
       ) 
       (Setvar "Blipmode" G) 
) 
 
;13.  Draws a slot. 
(Defun C:Slot (/ P1 A B C) 
       (Setvar "Cmdecho" 0) 
       (Setq P1 (Getpoint "\nInsertion point of slot: ")) 
       (Setq A (Getdist P1 "\nRadius: ")) 
       (Setq B (Getdist P1 "\nLength: ")) 
       (Setq C (Getangle P1 "\nAngle: ")) 
       (Command "Arc" "C" P1 (Polar P1 (+ (/ Pi 2) C) A) "A"
"180") 
       (Command "Line" "" (Polar (Getvar "Lastpoint") A B) "") 
       (Command "Arc" "" (Polar (Getvar "Lastpoint") (+ (/ Pi 2)
C) (* 2 A))) 
       (Command "Line" "" (Polar (Getvar "Lastpoint") (+ Pi C) B)
"") 
) 
 
;14.  Changes text styles 
(Defun C:Cs (/ A B C D E) 
       (Setvar "Cmdecho" 0) 
       (Setq A (Getstring "\nOld Style Name: ")) 
       (Setq B (Getstring "\nNew Style Name: ")) 
       (Setq C (Entnext)) 
       (While (Boundp 'C) 
              (Setq D (Entget C)) 
              (If (= (Cdr (Assoc 0 D)) "TEXT") 
                  (Progn 
                       (If (= (Cdr (Assoc 7 D)) A) 
                           (Progn 
                                (Setq E (Assoc 7 D)) 
                                (Setq D (Subst (Cons 7 B) E D)) 
                                (Entmod D) 
                           ) 
                       ) 
                  ) 
              ) 
              (Setq C (Entnext C)) 
       ) 
) 
 
;15. Extends a line to a given distance
(Defun C:exd (/ P1 P2 A B C D E) 
       (Setvar "Cmdecho" 0) 
       (Setq A (Getvar "Gridmode")) 
       (Setq B (Getvar "Snapmode")) 
       (Setq C (Getvar "Snapang")) 
       (Setq E (Getvar "Orthomode")) 
       (Setvar "Orthomode" 1) 
       (Setq P2 (Osnap (Setq P1 (Osnap (Getpoint 
                 "Touch line to change: ")"End"))"Mid")) 
       (Setvar "Gridmode" 0) 
       (Setvar "Snapmode" 0) 
       (Setvar "Snapang" (Angle P2 P1)) 
       (Setq D (Getdist P1 "How far: ")) 
       (Command "Change" P1 "" (Polar P1 (Angle P2 P1) D)) 
       (Setvar "Gridmode" A) (Setvar "Snapmode" B) 
       (Setvar "Snapang" C)) 
 
;16.  Step and Repeat 
(Defun C:SR (/ P1 P2 A1 A B C D E BT CT) 
       (Setvar "Cmdecho" 0) 
       (Setq B (If (null B) "" B)) 
       (Setq C (If (null C) 1.0 C)) 
       (Setq P1 (Getpoint "\nFirst point: ")) 
       (Setq P2 (Getpoint "\nSecond point: ")) 
       (Setq A1 (Angle P1 P2)) 
       (Setq A (Getint "\nNumber of items: ")) 
       (Prompt "\nBlock name <") (Prompt B) 
       (Setq BT (Getstring ">: ")) 
       (Setq B (If (null BT) B BT)) 
       (Prompt "\nScale factor <") 
       (Prompt (Rtos C (Getvar "Lunits") (Getvar "Luprec"))) 
       (Setq CT (Getreal ">: ")) 
       (Setq C (If (null CT) C CT)) 
       (Setq D (Getstring "\nRotate item <N>: ")) 
       (Setq D (If (= D "y") "Y" "N")) 
       (If (= D "Y") 
           (Setq D (* (/ 180 Pi) A1)) 
           (Setq D 0) 
       ) 
       (Setq E (Distance P1 P2)) 
       (Setq E (/ E (- A 1))) 
       (Repeat A 
               (Command "Insert" B P1 C "" D) 
               (Setq P1 (Polar P1 A1 E)) 
       ) 
) 
 
;17.  Draws a flange 
(Defun C:Flange () 
       (Setvar "Cmdecho" 0) 
       (Setq OR 0) (Setq IR 0) (Setq BC 0) 
       (Setq P1 (Getpoint "\nEnter center of flange: ")) 
       (Setq OR (Getdist P1 "\nOutside radius: ")) 
       (Command "Circle" P1 OR) 
       (Setq IR (Getdist P1 "\nInside radius: ")) 
       (While (> IR OR) 
       (Prompt "\nInside radius larger than outside: ") 
       (Setq IR (Getdist P1 "\nInside radius: "))) 
       (Command "Circle" P1 IR) 
       (Setq bad 1) 
       (While bad 
       (Setq A nil) (Setq B nil) 
       (Setq BC (Getdist P1 "Bolt circle radius: ")) 
       (IF (> BC OR)  
       (Prompt "\nBolt circle larger than O.D.: ") 
       (setq a t)) 
       (If (< BC IR)  
       (Prompt "\nBolt circle smaller than I.D.: ") 
       (Setq b t)) 
       (if (and a b) (setq bad nil))) 
       (Command "Circle" P1 BC) 
       (Setq SH (Getreal "Bolt hole diameter: ")) 
       (Setq NHI (Getint "Number of bolt holes: ")) 
       (Setq NH (Float NHI)) 
       (Setq SA (Getangle P1 
       "Starting angle of first hole: ")) 
       (Command "Circle" (Polar P1 SA BC) "D" SH) 
       (Command "Array" "L" "" "C" P1 (/ 360 NH) NHI "")) 
 
;18. Parrallelogram 
(Defun C:PAA () 
  (Setvar "Cmdecho" 0) 
  (Setq P1 (Getpoint "\nFrom point: ")) 
  (Setq P2 (Getpoint P1 "\nTo point: ")) 
  (Command "Line" P1 P2 "") 
  (Setq P3(Getpoint P2 "To point: ")) 
  (Setq P4 (Polar P3 (Angle P2 P1) (Distance P2 P1))) 
  (Command "Line" P2 P3 P4 P1 "") 
) 
                               