(Vmon)  ;Virtual Memory On 
 
;These are the functions in ACAD.LSP:
;    1.  Find  (find) 
;    2.  Import  (import) 
;    3.  Export  (export) 
;    4.  Text Fit  (tfit) 
;    5.  Change Text Size Global (tszg) 
;    6.  Change Text Size Select (tsz) 
;    7.  Fillet 2 circles  (filetcir) 
;    8.  Increment Number Individual (number) 
;    9.  Change Text (ct) 
;   10.  Delete Layer (dl) 
;   11.  Delete All (da) 
;   12.  Drawing Setup (setup) 
;   13.  Parts List (plist) 
;   14.  Weld arrow up (wldf) 
;   15.  Weld arrow down (wldn) 
;   16.  Part identifier (balloonc) 
;   17.  Ortho Rectangle (r) 
;   18.  Reset Drawing Scale (orsc) 
;   19.  Error: 
;   20.  Breakout 
 
;1.  Counts the number of objects in a drawing.
;    They could be entities or blocks. 
(Defun C:Find (/ A B C) 
       (Setvar "Cmdecho" 0) 
       (Setq A (Getstring "\nObject name to be found: ")) 
       (Setq B 0) 
       (Setq C (Entnext)) 
       (While C 
              (Cond ((= (Strcase A) (Cdr (Assoc 0 (Entget C)))) 
                     (Setq B (1+ B))) 
                    ((= (Strcase A) (Cdr (Assoc 2 (Entget C)))) 
                     (Setq B (1+ B))) 
              ) 
              (Setq C (Entnext C)) 
       ) 
       (Prompt "\nThere are ")  
       (Prompt (Itoa B)) 
       (Prompt " occurances of ") 
       (Prompt (Strcase A)) (Prompt "\n") 
) 
 
;2.  Imports an ASCII text file into the current drawing. 
(Defun C:Import (/ P1 A B C D E F) 
       (Setvar "Cmdecho" 0) 
       (Prompt "Developed by: Applied Technical Support -
Tulsa\n") 
       (Setq A (Getstring "Enter the ASCII text file name: ")) 
       (Setq B (Getreal "Enter the text height: ")) 
       (Setq C (Getreal "Enter the line spacing: ")) 
       (Setq D (Getstring "Enter the justification, LCR <L>: ")) 
       (Setq P1 (Getpoint "Enter the insertion point of first
text line: ")) 
       (Setq E (Open A "r")) 
       (Setq F (Read-line E)) 
       (If (= D "") (Setq D nil)) 
       (While (Or nil F) 
              (If (null D) 
                  (Command "Text" P1 B 0 F) 
                  (Command "Text" D P1 B 0 F) 
              ) 
              (Setq P1 (List (Car P1) (- (Cadr P1) C))) 
              (Setq F (Read-line E)) 
       ) 
) 
 
;3.  Export - takes notes off a drawing and places them into 
;    an ASCII file. 
(Defun C:Export (/ A B C D E F G H I) 
       (Setvar "Cmdecho" 0) 
       (Setq A (Getstring "Enter the file name: ")) 
       (Setq B (Open A "r")) 
       (If (/= B nil) 
           (Progn 
                 (Prompt "File already exists.\n") 
                 (Close B) 
           ) 
           (Progn 
                 (Setq C (Open A "w")) 
                 (Prompt "\nFile now open") 
                 (Prompt "\nPick items in order to write to
file") 
                 (Setq D 0) 
                 (Setq E (Ssget)) 
                 (Setq F (Sslength E)) 
                 (Repeat F 
                          (Setq G (Ssname E D)) 
                          (Setq H (Entget G)) 
                          (Setq I (Cdr (Assoc 1 H))) 
                          (Write-line I C) 
                          (Setq D (+ 1 D)) 
                 ) 
                 (Close C) 
           ) 
       ) 
) 
 
;4.  Text Fit - Squeezes and moves existing text. 
(Defun C:Tfit (/ P1 P2 P3 A B C D) 
       (Setvar "Cmdecho" 0) 
       (Setq A (Entsel "\nSelect insertion point of text to fit:
")) 
       (Setq A (Car A)) 
       (Setq B (Entget A)) 
       (Setvar "Orthomode" 1) 
       (Setq P1 (Cdr (Assoc 10 B))) 
       (Setq P2 (Getdist P1 "\nTouch end of text: ")) 
       (Setq P1 (Getpoint "\nEnter new 1st point: ")) 
       (Setq P3 (Getpoint P1 "\nEnter 2nd point: ")) 
       (Setq C (Assoc 41 B)) 
       (Setq D (* (/ (Distance P1 P3) P2) (Cdr C))) 
       (Setq D (Cons 41 D)) 
       (Setq B (Subst D C B)) 
       (Setq P1 (Cons 10 P1)) 
       (Setq P3 (Cons 11 P3)) 
       (Setq C (Assoc 10 B)) 
       (Setq B (Subst P1 C B)) 
       (Setq C (Assoc 11 B)) 
       (Entmod (Subst P3 C B)) 
       (Setq A nil) 
) 
 
;5.  Globally changes text from one height to another. 
(Defun C:Tszg (/ A B C D E F G) 
       (Setvar "Cmdecho" 0) 
       (Setq A (Getreal "\nEnter text size to change: ")) 
       (Setq B (Fix (* 100 A))) 
       (Setq C (Getreal "\nEnter new text height: ")) 
       (Setq D (Entnext)) 
       (Setq E (Cons 40 C)) 
       (Setq F (Assoc 40 (Entget D))) 
       (While D 
               (Setq F (Assoc 40 (Entget D))) 
               (If (/= nil F) 
                   (Setq G (Fix (* 100 (Cdr F)))) 
               ) 
               (If (= B G) 
                   (Entmod (Subst E F (Entget D))) 
               ) 
               (Setq D (Entnext D)) 
       ) 
) 
 
;6.  Changes selected text from one height to another. 
(Defun C:Tsz (/ A B C D E F) 
       (Setvar "Cmdecho" 0) 
       (Setq A (Ssget)) 
       (Setq B (Sslength A)) 
       (Setq C (Getreal "\nEnter new text size: ")) 
       (While (> B 0) 
              (Setq B (1- B)) 
              (Setq D (Ssname A B)) 
              (Setq D (Entget D)) 
              (Setq E (Assoc 40 D)) 
              (Setq F (Cons 40 C)) 
              (Entmod (Setq D (Subst F E D))) 
       ) 
       (Setq A nil) 
) 
 
;7.  Fillets the outside radius between two circles. 
(Defun C:Filetcir (/ A B C D E F G H I) 
       (Setvar "Cmdecho" 0) 
       (Setvar "Blipmode" 0) 
       (Setq A (Osnap (Getpoint "\nMark first arc: ")"Nea")) 
       (Setq B (Osnap (Getpoint "\nMark second arc: ")"Nea")) 
       (Setq C (Getdist "\nFillet radius: ")) 
       (Setq D (Osnap A "Cen")) 
       (Setq E (Distance A D)) 
       (Setq F (Osnap B "Cen")) 
       (Setq G (Distance B F)) 
       (Setq H (Distance D F)) 
       (Setq I (+ (* H H) 
               (- (* (- C E) (- C E))(* (- C G) (- C G)))) 
       ) 
       (Setq A (* 2 (- C E) H)) 
       (Setq B (* (- C E) (/ I A))) 
       (Setq A (Sqrt (- (* (- C E) (- C E)) (* B B)))) 
       (Setq B (Polar F (Angle F D) (- H B))) 
       (Setq A (Polar B (- (Angle F D) (/ Pi 2)) A)) 
       (Setq B (+ (Angle F A) Pi)) 
       (Setq C (+ (Angle D A) Pi)) 
       (Setvar "Blipmode" 1) 
       (Command "Arc" (Polar D C E) "C" A (Polar F B G)) 
) 
 
;8.  Increments numbers while the user 
;    randomly places them around the screen. 
(Defun C:Numbers (/ A B C D E) 
       (Setvar "Cmdecho" 0) 
       (Setq A (Getint "\nEnter first number of series: ")) 
       (Setq B (Getint "\nEnter last number of series: ")) 
       (Setq C (Getreal "\nEnter text height: ")) 
       (Setq D (Getreal "\nText rotation <0>: " )) 
       (If (= D nil) 
           (Setq D 0) 
       ) 
       (While (<= A B) 
              (Setq E (Getpoint "\nLocation of number: ")) 
              (Command "Text" E C D A) 
              (Setq A (+ A 1)) 
       ) 
) 
 
;9. Changes text.  Corrects spelling errors 
(defun c:ct (/ p l n e os as ns st s nsl osl sl si chf chm) 
        (Setvar "Cmdecho" 0) 
        (setq p (ssget)) 
        (if p (progn 
           (setq osl (strlen (setq os 
                         (getstring "\nOld string: " t)))) 
           (setq nsl (strlen (setq ns 
                         (getstring "\nNew string: " t)))) 
           (setq l 0) 
           (setq chm 0) 
           (setq n (sslength p)) 
           (while (< l n) 
              (if (= "TEXT" 
                     (cdr (assoc 0 
                       (setq e (entget (ssname p l)))))) 
                 (progn 
                    (setq chf nil) 
                    (setq s (cdr (setq as (assoc 1 e)))) 
                    (setq si 1) 
                    (while (= osl (setq sl (strlen 
                                  (setq st (substr s si osl))))) 
                       (if (= st os) (progn 
                          (setq s (strcat (substr s 1 (1- si)) ns

                                          (substr s (+ si osl))))

                          (setq chf t) 
                       )) 
                       (setq si (1+ si)) 
                    ) 
                    (if chf (progn 
                       (setq e (subst (cons 1 s) as e)) 
                       (entmod e) 
                       (setq chm (1+ chm)) 
                    )) 
                 ) 
              ) 
              (setq l (1+ l)) 
           ) 
        )) 
        (princ "Changed ") 
        (princ chm) 
        (princ " text lines.") 
        (terpri) 
) 
 
;10.  deletes layers. 
(Defun C:Dl (/ A B) 
       (Setvar "Cmdecho" 0) 
       (Setq A (Strcase (Getstring "\nEnter layer to delete: ")))

       (Setq B (Entnext)) 
       (While B 
              (If (= A (Cdr (Assoc 8 (Entget B)))) 
                  (Entdel B) 
              ) 
              (Setq B (Entnext B)) 
       ) 
) 
 
;11.  Deletes all. 
(Defun C:Da (/ A) 
       (Setvar "Cmdecho" 0) 
       (Setq A (Entnext)) 
       (While A 
              (Entdel A) 
              (Setq A (Entnext A)) 
       ) 
) 
 
:12.  Drawing scale setup. 
(Defun C:Setup (/ A B C D E F) 
       (Setvar "Cmdecho" 0) 
       (Setq A nil) 
       (Setq B "Wrong paper size") 
       (Command "Dscale") 
       (Setq DS (Getreal "\nEnter drawing scale (1, 2, 4, 12, 48, etc.): ")) 
       (Prompt "\nAvailable paper sizes are AH AV B C D E") 
       (Setq A (Strcase (Getstring "\nEnter letter of paper size:"))) 
       (Setvar "Userr1" DS) 
       (Setvar "Cmdecho" 0) 
       (If (= A "AH") (Setq C (List 12 9))) 
       (If (= A "AV") (Setq C (List 9 12))) 
       (If (= A "B") (Setq C (List 18 12))) 
       (If (= A "C") (Setq C (List 24 18))) 
       (If (= A "D") (Setq C (List 36 24))) 
       (If (= A "E") (Setq C (List 48 36))) 
       (If (= A nil) (*error* B)) 
       (Setq D (Car C)) 
       (Setq E (Cadr C)) 
       (Setvar "Regenmode" 0) 
       (Command "Dim" "Dimscale" DS "Exit") 
       (Command "Limits" (List (* DS -1) (* DS -1)) (List (* DS
D) (* DS E))) 
       (Command "Grid" DS) 
       (Command "Snap" (/ DS 4)) 
       (Command "Ltscale" DS) 
       (If (= A "AH")(Command "Insert" "Tshtah" (List 0 0) DS ""
"0")) 
       (If (= A "AV")(Command "Insert" "Tshtav" (List 0 0) DS ""
"0")) 
       (If (= A "B")(Command "Insert" "Tshtb" (List 0 0) DS ""
"0")) 
       (If (= A "C")(Command "Insert" "Tshtc" (List 0 0) DS ""
"0")) 
       (If (= A "D")(Command "Insert" "Tshtd" (List 0 0) DS ""
"0")) 
       (If (= A "E")(Command "Insert" "Tshte" (List 0 0) DS ""
"0")) 
       (Setvar "Regenmode" 1) 
       (Command "Zoom" "A") 
       (Setq F (* 0.125 DS)) 
       (Setvar "Textsize" F) 
) 
 
;13.  Draws a parts list and prompts for the  
;     parts. 
(Defun C:Plist (/ P1 P2 P3 P4 P5 A1 A B C D E F) 
       (Setvar "Cmdecho" 0) 
       (Setq F (Getvar "Blipmode")) 
       (Setvar "Blipmode" 0) 
       (prompt "\n ********* BE SURE YOU HAVE RUN SETUP!! ******")
       (prompt "\n ********* Just Type SETUP ******")
       (Setq A (Getvar "userr1")) 
       (Setq B (Getint "\nEnter number of items in list: ")) 
       (Setq P1 (Osnap (Getpoint "\nTouch upper right corner of
drawing: ") 
                 "End") 
       ) 
       (Command "Insert" "Plist" P1 (/ A 1) "" "0") 
       (Setq P1 (List (- (Car P1) (* 0.34375 A)) (- (Cadr P1) (*
0.31250 A)))) 
       (Setq P2 (List (- (Car P1) (* 5.09375 A)) (Cadr P1))) 
       (Setq P3 (List (- (Car P2) (* 1.00 A)) (Cadr P2))) 
       (Setq P4 (List (- (Car P3) (* 0.4375 A)) (Cadr P3))) 
       (Setq P5 (List (- (Car P4) (* 0.625 A)) (+ (Cadr P4) (*
0.3125 A)))) 
       (Setq A1 (* 1.5 Pi)) (Setq D (* 0.25 A)) 
       (Setq E (+ (* 0.3125 A) (* D B))) 
       (Command "Line" P1 (Polar P1 A1 E) "") 
       (Command "Line" P2 (Polar P2 A1 E) "") 
       (Command "Line" P3 (Polar P3 A1 E) "") 
       (Command "Line" P4 (Polar P4 A1 E) "") 
       (Command "Line" P5 (Polar P5 A1 (+ (* 0.6250 A) (* D B)))
"") 
       (Setq P1 (Polar P5 A1 (* 0.875 A))) 
       (Command "Line" P1 (Polar P1 0 (* 7.5 A)) "") 
       (Command "Array" "L" "" "R" B "" (* -1 D)) 
       (Setq P1 (List (+ (Car P1) (* 0.3125 A)) (+ (Cadr P1) (*
0.0625 A)))) 
       (Setq P2 (Polar P1 0 (* 0.53125 A))) 
       (Setq P3 (Polar P2 0 (* 0.71875 A))) 
       (Setq P4 (Polar P3 0 (* 0.5625 A))) 
       (Setq P5 (Polar P4 0 (* 5.203125 A))) 
       (Setq C 1) 
       (Repeat B 
               (Command "Text" "C" P1 (* 0.125 A) "0" (Itoa C)) 
               (Prompt "\nQuantity for item ") 
               (Princ C) 
               (Prompt ": ") 
               (Setq G (Read-line)) 
               (Command "Text" "C" P2 (* 0.125 A) "0" G) 
               (Prompt "\nPart number for item ") 
               (Princ C) (Prompt ": ") (Setq G (Read-line)) 
               (Command "Text" "C" P3 (* 0.125 A) "0" G) 
               (Prompt "\nDescription for item ") 
               (Princ C) (Prompt ": ") (Setq G (Read-line)) 
               (Command "Text" P4 (* 0.125 A) "0" G) 
               (Prompt "\nDrawing size for item ") 
               (Princ C) (Prompt ": ") (Setq G (Read-line)) 
               (Command "Text" P5 (* 0.125 A) "0" G) 
               (Setq P1 (List (Car P1) (- (Cadr P1) D))) 
               (Setq P2 (List (Car P2) (- (Cadr P2) D))) 
               (Setq P3 (List (Car P3) (- (Cadr P3) D))) 
               (Setq P4 (List (Car P4) (- (Cadr P4) D))) 
               (Setq P5 (List (Car P5) (- (Cadr P5) D))) 
               (Setq C (+ 1 C)) 
       ) 
       (Setvar "Blipmode" F) 
) 
 
 
;14.  Draws a weld arrow. 
(Defun C:Wldf (/ P1 P2 A) 
       (Setvar "Cmdecho" 0) 
       (Setq DS (Getreal "\nEnter the Dimscale: ")) 
       (Setq P1 (Getpoint "\nFrom point: ")) 
       (Setq P2 (Getpoint "\nTo point: ")) 
       (If (<= (Car P2) (Car P1)) 
           (Setq A "Weldupr") (Setq A "Weldupl") 
       ) 
      (Command "Layer" "S" "4" "") 
      (Command "Dim1" "Leader" P1 P2 "" "") 
      (Command "Insert" A P2 DS "" "0") 
) 
 
;15.  Draws a weld arrow. 
(Defun C:Wldn (/ P1 P2 A) 
       (Setvar "Cmdecho" 0) 
       (Setq DS (Getreal "\nEnter the Dimscale: ")) 
       (Setq P1 (Getpoint "\nFrom point: ")) 
       (Setq P2 (Getpoint "\nTo point: ")) 
       (If (<= (CAR P2) (CAR P1)) 
           (Setq A "Welddnr") (Setq A "Welddnl") 
       ) 
       (Command "Layer" "S" "4" "") 
       (Command "Dim1" "Leader" P1 P2 "" "") 
       (Command "Insert" A P2 DS "" "0") 
) 
 
;16.  Draws part identifier - a balloon containing a  
;     number, then a leader to the object. 
(Defun C:Balloonc (/ P1 P2 P3 P4 A) 
       (Setq DS (Getreal "\nEnter the Dimscale: ")) 
       (Setvar "Cmdecho" 0) 
       (Setq P1 (Getpoint "\nFrom point: ")) 
       (Setq P2 (Getpoint "\nTo point: ")) 
       (If (<= (Car P2) (Car P1)) 
           (Setq A (* -0.25 DS)) (Setq A (* 0.25 DS)) 
       ) 
       (Setq P3 (List (+ (Car P2) A) (Cadr P2))) 
       (Setq P4 (List (+ (Car P3)(/ A 2)) (Cadr P3))) 
       (Command "Layer" "S" "4" "") 
       (Command "Dim1" "Leader" P1 P2 P3 "" "") 
       (Setq A "Cballoon") 
       (Command "Insert" A P4 DS "" "0") 
) 
 
;17.  Draws an orthangonal retangle with PLINE. 
(Defun C:R (/ P1 P2) 
       (Setvar "Cmdecho" 0) 
       (Setq P1 (Getpoint "\nEnter first corner: ")) 
       (Setvar "Lastpoint" P1) 
       (Setq P2 (Getpoint "\nEnter second corner: ")) 
       (Command "Pline" P1 (List (Car P1) (Cadr P2)) 
                           P2 (List (Car P2) (Cadr P1)) "C" 
       ) 
) 
 
;18.  Resets dimscale and user variable 1. 
(Defun C:Orsc  ( / A B) 
       (Setvar "Cmdecho" 0) 
       (Setq B (Getvar "Userr1")) 
       (Prompt "\nPresent drawing scale is <") 
       (Prompt (Rtos B)) 
       (Prompt ">") 
       (Setq A (Getreal "\nEnter new drawing scale: ")) 
       (Setvar "Userr1" A) 
       (Command "Dim" "Dimscale" (Getvar "Userr1") "Exit") 
) 
 
;19. Error. 
(Defun *error* (st) 
  (Princ "Error: ") 
  (Princ st) 
  (Terpri)) 
 
;20.  Breakout. 
(Defun C:Breakout (/ P1 P2 P3 A B) 
       (Setvar "Cmdecho" 0) 
       (Setq P1 (Osnap (Getpoint "\nPick first intersection:
")"Int,End")) 
       (Setq P2 (Osnap (Getpoint "\nPick second intersection:
")"Int,End")) 
       (Setq A (/ (+ (Car P1) (Car P2)) 2)) 
       (Setq B (/ (+ (Cadr P1) (Cadr P2)) 2)) 
       (Setq P3 (Osnap (List A B) "Near")) 
       (Command "Break" P3 "F" P1 P2) 
) 
