(defun c:postit (/ scmde sblip layer dscol dlcol symflag attflag #thresh #t
                   tlist slist clist sflag pflag symnam blrot blnam prec)
   (defun sblip ()                                    ;turn off command echo & blipmode
      (setq scmde (getvar "cmdecho")
            sblip (getvar "blipmode"))
      (setvar "cmdecho" 0)
      (setvar "blipmode" 0)
   )
   (defun getinf1 (/ iflag)                           ;get data file & global posting parameters
      (getfr)
      (setq xscol (getint "\nEnter the X or Easting starting column number: ")
            xlcol (getint "\nEnter the X or Easting field length: ")
            yscol (getint "\nEnter the Y or Northing starting column number: ")
            ylcol (getint "\nEnter the Y or Northing field length: ")
            symscl (getreal "\nEnter the scaling value for the posting symbol<1.00>: ")
            symscl (cond ((boundp 'symscl) symscl)
                         (T 1.0)))
      (prompt "\nEnter the scaling value for the posting value<")
      (prompt (rtos symscl))
      (setq attscl (getreal ">: ")
            attscl (cond ((boundp 'attscl) attscl)
                         (T symscl)))
      (setq iflag (getstring "\nUse default symbol names? (Y/N)<Y>: "))
      (if (or (equal "" iflag) (equal "Y" (strcase iflag))) (setq symlist '("sym5" "sym4" "sym3" "sym2" "sym1")        ;if true
                                                                  attlist '("attblk4" "attblk3" "attblk2" "attblk1"))
          (prompt "Make sure you have previouly set symlist & attlist"))                                               ;otherwise
   )
   (defun getfr ()                                    ;get a file to read
      (setq fnamer (getstring "\nEnter the filename: "))
      (setq fpr (open fnamer "r"))
      (while (equal fpr nil)
          (setq fnamer (getstring "\nFile not found!  Try another file name: "))
          (setq fpr (open fnamer "r"))
      )
   )
   (defun getinf2 (/ tc)                              ;get data field & posting parameters
      (setq layer (getstring "\nEnter the data label: ")
            dscol (getint "\nEnter the data's startng column number: ")
            dlcol (getint "\nEnter the data's field length: ")
            symflag (getstring "\nPlot the location symbols (Y/N)<N>: ")
            symflag (cond ((equal "Y" (strcase symflag)) (getinf2a) 1)
                         (T nil))
            attflag (getstring "\nPlot the data value (Y/N)<N>: ")
            attflag (cond ((equal "Y" (strcase attflag)) (getinf2b) 1)
                           (T nil))
            slen (itoa (- (length symlist) 1)))
      (prompt "\nEnter the number of threshold values (")
      (prompt slen)
      (setq #thresh (getint " max)<0>: ")
            #thresh (cond ((> #thresh 0) #thresh)
                          (T nil))
            #t #thresh)
      (while (> #t 0)
         (if (> #t 1)
            (setq tlist (cons (getreal "\nEnter the lowest remaining threshold value: ") tlist))   ;if true
            (setq tlist (cons (getreal "\nEnter the final threshold value: ") tlist)))             ;otherwise
         (prompt "\nEnter the # of the Autocad color for data values below this threshold")
         (setq tc (getint "\nand above the previous (if any) threshold(1-8)<7>: ")
               tc (cond ((or (< tc 1) (> tc 8)) 7)
                        (T tc))
               clist (cons tc clist))
         (if sflag (setq slist (cons (getreal "\nEnter the symbol scale factor for data below this thresh: ") slist)))
         (setq #t (1- #t))
      )
      (if (= #t 0) (progn
         (setq tc (getint "\nEnter the # of the Acad color for values above this threshold(1-8)<7>: ")
               tc (cond ((or (< tc 1) (> tc 8)) 7)
                        (T tc))
               clist (cons tc clist))
         (if sflag (setq slist (cons (getreal "\nEnter the symbol scale factor for values above this thresh: ") slist)))))
   )
   (defun getinf2a ()                                 ;get symbol posting parameters
      (setq sflag (getstring "\nUse Different symbols or Variable symbol sizes(D,V)<D>: ")
            sflag (cond ((equal "V" (strcase sflag)) 1)
                        (T nil)))
      (if sflag (setq symnam (getstring "\nEnter the name of the symbol you want to use: ")))
   )
   (defun getinf2b (/ blnum bflag)                    ;get value posting parameters
            (prompt "\nDo you want the data value centered Above, centered Below, or extending")
            (setq pflag (getstring "\nRadially from the posting location(A,B,R)<R>: "))
            (cond ((equal "A" (strcase pflag)) (setq blrot 0
                                                     blnam (cadr attlist)))
                  ((equal "B" (strcase pflag)) (setq blrot 0
                                                     blnam (car attlist)))
                  (T (setq blnum (getint "\nEnter the clock position for the value posting (1-12)<12>: ")
                           blnum (cond ((and (> blnum 0) (< blnum 13)) blnum)
                                       (T 12))
                           blrot (cond ((and (< blnum 12) (> blnum 6)) (setq bflag 1) (- (* 30 (- blnum 6))))
                                       (T (setq bflag nil) (- (* 30 blnum))))
                           blnam (cond (bflag (caddr attlist))
                                       (T (last attlist)))))
            )
            (prompt "\nEnter the number of digits to be posted")
            (setq prec (getint "\nto the right of the decimal point<0>: ")
                  prec (cond ((> prec -1) prec)
                             (T 0)))
   )
   (defun mlayer (/ color lname lname1 lname2)        ;make all potential layers
      (if (null #thresh) (progn (setq #t 0                         ;if true
                                      clist (list 7)))
         (setq #t #thresh))                                        ;otherwise
      (while (>= #t 0)
         (setq color (nth #t clist))
         (if symflag (progn
           (setq lname1 (strcat layer (itoa #t) "s")
                 lname lname1)))
         (if attflag (progn
            (setq lname2 (strcat layer (itoa #t) "d")
                  lname lname2)))
         (if (and symflag attflag) (setq lname (strcat lname1 "," lname2)))
         (command "layer" "n" lname "c" color lname "")
         (setq #t (1- #t))
      )
   )
   (defun slayer (/ colorold xval yval dval loc linein) ;read data, sort, set layer base-name, call post
      (setq colorold (getvar "cecolor"))
      (command "color" "bylayer")
      (setq linein (read-line fpr))
      (while (boundp 'linein)
         (setq xval (atof (substr linein xscol xlcol))
               yval (atof (substr linein yscol ylcol))
               dval (substr linein dscol dlcol)
               dval (cond ((numberp (read dval)) (atof dval))
                          (T (setq #thresh nil) (prompt "Data is alpha") dval))
               loc (list xval yval))
         (if (null #thresh) (postdat)                              ;if null
            (progn                                                 ;otherwise
               (setq #t (- #thresh 1))
               (if (< dval (nth #t tlist)) (progn
                  (postdat) (setq #t -2)))
               (setq #t (1- #t))
               (while (>= #t 0)
                  (if (and (< dval (nth #t tlist)) (> dval (nth (+ #t 1) tlist))) (progn
                     (postdat) (setq #t -2))                       ;if true
                     (setq #t (1- #t)))                            ;otherwise
               )
               (if (= #t -1) (postdat))
            ))
      )
      (command "color" colorold)
   )
   (defun postdat (/ symscl2 lname attscl2)           ;set layer, post symbol & data
      (if (null #thresh) (setq #t -1
                               slist (list 1)))
      (setq lname (strcat layer (itoa (+ 1 #t))))
      (if symflag (progn
         (setq l (strcat lname "s"))
         (command "layer" "s" l "")
         (if sflag (setq symscl2 (* symscl (nth (+ 1 #t) slist)))  ;if true
            (progn                                                 ;otherwise
            (setq symscl2 symscl)
            (setq symnam (nth (+ 1 #t) symlist))))
         (command "insert" symnam loc symscl2 "" "")))
      (if attflag (progn
         (setq l (strcat lname "d"))
         (command "layer" "s" l "")
         (if (numberp dval) (setq dval (rtos dval 2 prec)))
         (if sflag (setq attscl2 (* attscl (nth (+ 1 #t) slist)))  ;if true
            (setq attscl2 attscl))                                 ;otherwise
         (command "insert" blnam loc attscl2 "" blrot dval)))
      (setq linein (read-line fpr))
   )
   (defun clfr ()
      (close fpr)
      (setq fpr nil)
   )
   (defun rblip ()      ;restore command & blip modes
      (setvar "cmdecho" scmde)
      (setvar "blipmode" sblip)
   )
;START OF PROGRAM  2/2/87 Russ Cowart
   (sblip)
   (if (boundp 'iflag) (progn                                      ;IF TRUE
      (prompt "\nReset coordinate columns, scaling,")
      (setq iflag (getstring "\nfile and symbol names? (Y/N)<N>: "))
      (if (equal "Y" (strcase iflag)) (getinf1)                    ;if true
      (setq fpr (open fnamer "r"))))                               ;otherwise
      (progn                                                       ;OTHERWISE
         (setq iflag 1)
         (getinf1)))
   (getinf2)
   (mlayer)
   (slayer)
   (clfr)
   (rblip)
)
