; POLYC.LSP 
; By Larry Leuallen 1990											 72070,300

; Polyc.lsp converts lines, arcs, circles, and polylines to
; polylines of a user specified thickness. There are two options
; in selecting the entities to be changed: (1) by normal selection
; methods, (2) by all the entities that reside on the specified
; layer. The second method is the one that I use the most and the
; reason this program was developed. I needed an easy way to
; convert a normal drawing to a drawing which contained the lines
; in a thick polyline form so that a laser print of the drawing
; would show line thickness. My drawings follow the convention
; that each layer contains entities which are to be a particular
; line thickness. I use the program to globally change all of the
; entities (except text) on a layer to polylines with a specified
; line thickness. For example, my obj03 layer is thick lines, my
; hid23 layer is medium, and may cen31 layer is thin. I change
; obj03 to pen 2 (.0236), hid23 to pen 0 (.0138), and leave the
; thin layers as they are so that they will default to the laser
; printer's line thickness.

; I have included menu picks for the line thickness in terms
; of technical pen numbers. You may change this anyway that you
; like or omit it. My menus for the pen thickness and layer
; selection are included as samples for you if you would like
; to alter your menu and add this feature. Of course you will have
; to change the layers menu to reflect your layer names. Note that
; the layers menu is only useful if you consistently use a set
; group of layer names and definitions. The appropriate code lines
; for the menus are included but have been deactivated with a
; leading semi-colon.

; Some warnings: This was a stop gap function until I obtained
; the plotter cartridge which allowed setting pen thickness for
; the laser printer. I now use it mainly to give drawings line
; thickness for importation into Corel Draw (use dfx not plt).
; This way I don't have to laboriously pick each line in Corel
; Draw and assign it a Corel pen thickness.

; Since the function converts entities into polylines but not
; JOINED polylines, the connecting points will not be smooth. This
; is not a major problem if the line thicknesses are not too
; great, but gives ragged corners, etc., past a certain limit.
; The only cure is to manually join the polylines or to add some
; lisp routine to join the polylines.

; Any existing polylines will also be converted. If you use the
; group option and do not want this to occur you must first move
; the desired polylines to a non-converted layer.
;
; **SETPENS 5
; [ Select		]
; [  Pen			]
; [-------- 	]
; [ 	0000		]0.0071
; [ 	000 		]0.0098
; [ 	00			]0.0118
; [ 	0 			]0.0138
; [ 	1 			]0.0197
; [ 	2 			]0.0236
; [ 	2 1/2 	]0.0276
; [ 	3 			]0.0315
; [ 	3 1/2 	]0.0395
; [ 	4 			]0.0472
;
; **LAYERS
; [AutoCAD	 ]^C^C$S=S $P4=P4A
; [-Layers- 		 ]
; [ 	0 						 ]$S= 0 $S=
; [OBJ01				]$S= OBJ01 $S=
; [OBJ02				]$S= OBJ02 $S=
; [OBJ03				]$S= OBJ03 $S=
; [TXT01				]$S= TXT01 $S=
; [TXT02				]$S= TXT02 $S=
; [TXT03				]$S= TXT03 $S=
; [DIM01				]$S= DIM01 $S=
; [CEN31				]$S= CEN31 $S=
; [HID23				]$S= HID23 $S=
; [REF00				]$S= REF00 $S=
; [REF03				]$S= REF03 $S=
; [ANN01				]$S= ANN01 $S=
; [ANN02				]$S= ANN02 $S=
; [ANN03				]$S= ANN03 $S=
; [HATCH				]$S= HATCH $S=
; []
; [ROOT 				]$S=ROOT
; []
; []
; []
;
; The variables used are:
; 	a 	selection set of entities to polyize (change to polylines)
; 	b 	selection set
; 	c 	entity name from selection set
; 	d 	layer name
; 	e 	line thickness
; 	f 	selection set of circles on layer d
; 	n 	counter
; 	m 	counter
; 	p 	center of circle from selection set f
; 	q 	radius of from selection set f
; 	r
; 	x 	length of selection set
;

; --------------------------------------------------------

(defun convcir (f / x m n c p q r)	; converts circles to polylines given
	(if f									; selection set f.
		(progn
			(setq x (sslength f)
					n
			)
			(repeat x
				(setq c (ssname f n)
						n (1+ n)
						p (cdr (assoc 10 (entget c)))
						q (cdr (assoc 40 (entget c)))
						r (polar p (/ pi 2) q)
						q (polar p (/ (* pi 3) 2) q)
				)
				(entdel c)
				(setq m (getvar "clayer"))
				(command "layer" "s" d "" "pline" r "a" "ce" p q
					"close" "layer" "s" m "")
			)
		)
	)
)

(defun selg (entl / n b m x)	;combines selection set of lines, 
	(setq a (ssadd))						;arcs, and pline.
	(foreach n entl
		(progn
			(setq b (ssget "X" (list (cons 8 d) (cons 0 n)))
					m 0
			)
			(if b (setq x (sslength b)) (setq x nil))
			(if x
				(progn
					(while (< m x)
						(ssadd (ssname b m) a)
						(setq m (1+ m))
					)
				)
			)
		)
	)
)

(defun C:polyc ( / a b c d e f n m p q r x y)
	(initget 1 "Select Group  ")	;space necessary for default mechanism.
	(setq b (getkword
			"\nPolyize lines. Select entity or by layer Group. S/G <G>: ")
	)
;	(menucmd "s=x")				;so that the root menu shows at bottom
;	(menucmd "s=setpens")		; menu for pen thickness. Omit these two lines
	(initget 7)							;if you don't want menu.
	(setq e (getreal "\nEnter desired line thickness: ")
			e (* e (getvar "dimscale"))
	)
;		(menucmd "s=")			;restore to original menu after pick is made. 
;		(menucmd "s=")			;Omit these two lines if you don't want menu.
	(if (= b "Select")
		(progn
			(prompt "\nSelect entities to change to wide polylines: ")
			(setq f (ssget))
			(setq x (sslength f)
					n 0
			)
			(repeat x
				(setq c (ssname f n)
						n (1+ n)
				)
				(if (= (cdr (assoc 0 (entget c))) "CIRCLE")	; Convert circles to
					(progn													; polylines
						(setq p (cdr (assoc 10 (entget c)))
								q (cdr (assoc 40 (entget c)))
								r (polar p (/ pi 2) q)
								q (polar p (/ (* pi 3) 2) q)
						)
						(setq m (cdr (assoc 8 (entget c)))
								 (getvar "clayer")
						)
						(command "layer" "s" m "" "pline" r "a" "ce" p q
								"close" "layer" "s" y "")
						(ssadd (entlast) f)
						(ssdel c f)
						(entdel c)
					)
				)
				(setq a f)
			)
		)
		(progn
			(if (or (= b "Group") (= b ""))
				(progn
;					(menucmd "s=layers")		; menu for my std. layers.Your own or omit.
					(setq d (getstring
						"\nEnter layer name to change to wide polylines: ")
					)
;					(menucmd "s=")    ;delete if no menu.
					(setq f (ssget "X" (list (cons 8 d) (cons 0 "CIRCLE"))))
					(convcir f)
					(selg '("LINE" "ARC" "POLYLINE"))
				)
			)
		)
	)
	(if a
		(progn
			(setq x (sslength a)
					n 0
			)
			(while (< n x)
				(setq c (ssname a n))
				(setq n (1+ n))
				(if (/= "POLYLINE" (cdr (assoc 0 (entget c))))
						(command "pedit" c "" "width" e "")
					(command "pedit" c "width" e "")
				)
			)
		)
	)
	(princ)
)
(c:polyc)