;================================================================
;PUBLISHED IN CADENCE, SEPT. 1987
;WRITTEN BY: TERRY MAJEWSKI
;KEYED AND TESTED BY: DAVE SCHOENHERR 9-23-87
;
;LISP ROUTINE TO ALLOW USER TO PICK OBJECTS WHOSE LAYERS WILL
;BE TURNED OFF.  ALLOWS FOR MULTIPLE OBJEXTS AND LAYERS LIKE
;ANY REGULAR SELECTION SET.  THE BEST PART IS THAT AFTER YOU HAVE
;DONE WHATEVER YOU WERE DOING, YOU CAN TURN THOSE LAYERS BACK ON.
;USES SIMPLE "OFF" AND "ON" COMMANDS FROM THE COMMAND PROMPT.
;I SUGGEST ADDING THIS TO YOUR ACAD.LSP, AS IT IS VERY USEFUL.
;
===================================================================
(setq onck 0)
(defun C:OFF ()
(princ "\nSelect objects/layer to turn off: ")
(setq p (ssget))
(setq l 0)
(if (= onck 0)
(setq on "")
)
(setq n (sslength p))
(setq off "")
(setq c (getvar "clayer"))
(setq ck 0)
(if p (progn
(while (< l n)
(setq va (cdr (assoc 8 (setq e (entget (ssname p l))))))
(if (= c
(cdr (assoc 8 e)))
(setq ck 1)
)
(setq off (strcat off va ","))
(setq l (1+ l))
)
))
(setq sl (strlen off))
(setq sl (1- sl))
(setq off (substr off 1 sl))
(setvar "cmdecho" 0)
(command "layer" "off" off )
(setq onck 1)
(if (= ck 1)
(command "y")
)
(command "")
(setq on (strcat on off ","))
(setvar "cmdecho" 1)
(defun C:ON()
(setq ol (strlen on))
(setq ol (1- ol))
(setq on (substr on 1 ol))
(setvar "cmdecho" 0)
(command "layer" "on" on "")
(setvar "cmdecho" 1)
(setq onck 0)
)
)
;==============================================================
