/*
 AdsCmd.h

 Description: ADS command class header

 Revisions:
      Jun 96  DG  Initial issue
*/

#ifndef _ADSCMD_H
#define _ADSCMD_H



typedef int (*PFNADSCOMMAND)();



class CAdsCommand : public CObject
{
public:
   virtual ~CAdsCommand();

protected:
   CAdsCommand(const char *pszCommand,
               PFNADSCOMMAND pfnCommand,
               BOOL bToBeRegistered = FALSE,
               const char *pszHelpTopic = NULL);

   BOOL Define();
   BOOL Undefine();
   short DefunCode() const;
   int Run() const;
   BOOL IsDefined() const;

private:
   static short  m_nLastDefunCode;

   CString       m_csCommand;
   PFNADSCOMMAND m_pfnCommand;
   BOOL          m_bToBeRegistered;
   CString       m_csHelpTopic;
   short         m_nDefunCode;

   friend class CAdsLink;
};

#endif   // _ADSCMD_H
