/*
 AdsApp.cpp

 Description: Main application class

 Notes:
      This is the main application class, derived from the MFC CWinApp
      class.  It controls both the initialisation of the project and
      the 'declaration' of command functions.

 Revisions:
      Jun 96  DG  Initial issue

 To do:
      The main things you will need to change to suit your application
      are shown in the comments throughout the code - look for 'To do:'.
      They are:
         - Declare command function prototypes
         - Define your application regapp, if required
         - Add any further initialisation code to InitInstance() that
           your application requires
         - Define your command names and their corresponding functions
           in InitInstance()
         - Add any code for processing notification of saves, etc,
           within OnRequest()
*/



#include "stdafx.h"
#include "AdsApp.h"
#include "AboutDlg.h"


//// Command function prototypes
//To do: Declare command function prototypes here...
int AppAbout();


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

extern "C" HWND adsw_hwndAcad;
CAdsApp theApp;                // The one and only CAdsApp object
const char kAppRegapp[] = "";  // To do: Add your Regapp here, if applicable



BEGIN_MESSAGE_MAP(CAdsApp, CWinApp)
	//{{AFX_MSG_MAP(CAdsApp)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG
	ON_COMMAND(ID_HELP, CWinApp::OnHelp)
END_MESSAGE_MAP()


CAdsApp::CAdsApp()
   : m_cAdsLink(kAppRegapp)
{
	// Place all significant initialization in InitInstance
}


BOOL CAdsApp::InitApplication() 
{
   return (   CWinApp::InitApplication() == TRUE
           && m_cAdsLink.InitLink(this) == TRUE);
}


BOOL CAdsApp::InitInstance()
{
   SetUpMainWnd();
	LoadStdProfileSettings(0);

   //To do: Add further application initialisation

   //To do: Define all commands here.  The last two parameters are optional:
   //       i) the 'ToBeRegistered' flag (which specifies whether the
   //          command is registered via ads_regfunc() after being defined)
   //      ii) the help topic
   m_cAdsLink.DefineCmd("C:AppAbout", (PFNADSCOMMAND)AppAbout /*, TRUE, "AppAbout"*/);

   return TRUE;
}


int CAdsApp::ExitInstance() 
{
   delete m_pMainWnd;
   m_pMainWnd = NULL;
	
	return CWinApp::ExitInstance();
}


BOOL CAdsApp::OnIdle(LONG lCount) 
{
   BOOL bNeedMoreIdleTime = TRUE;
   int nAdsStatus;

	CWinApp::OnIdle(lCount);

   if (!m_cAdsLink.GetAdsRequest(nAdsStatus)) {
      /* Need to force our way out! */
      ::PostQuitMessage(0);
      bNeedMoreIdleTime = FALSE;
   }

   return bNeedMoreIdleTime;
}


void CAdsApp::OnRequest(int nRequestCode)
{
   switch (nRequestCode) {
      case RQSAVE:
      case RQQUIT:
      case RQEND:
      case RQCFG:
      default:
         //To do: Add code for any required notification of save, quit, etc.
         break;
   }
}


void CAdsApp::SetUpMainWnd()
{
   ASSERT(m_pMainWnd == NULL);

   m_pMainWnd = new CWnd;
   ASSERT(m_pMainWnd != NULL);

   if (m_pMainWnd != NULL) {
      /* Create an invisible window (which we won't use anyway) and centre
         it so any windows we create afterwards are centred as well.
      */
      m_pMainWnd->CreateEx(0,
                           AfxRegisterWndClass(0,
                                       AfxGetApp()->LoadStandardCursor(IDC_ARROW),
                                       NULL,
                                       AfxGetApp()->LoadIcon(IDR_MAINFRAME)),
                           m_pszAppName, WS_POPUP | WS_DISABLED,
                           0, 0, 100, 100, NULL, NULL);
      m_pMainWnd->CenterWindow();
   }
}
