/*
 AdsLink.h

 Description: ADS application link class header

 Revisions:
      Jun 96  DG  Initial issue
*/

#ifndef _ADSLINK_H
#define _ADSLINK_H



#include "AdsCmd.h"
class CAdsApp;



class CAdsLink
{
public:
   CAdsLink(const char *pszRegapp = NULL);
   virtual ~CAdsLink();

   BOOL InitLink(CAdsApp *pApp);
   BOOL DefineCmd(const char *pszCommand,
                  PFNADSCOMMAND pfnCommand,
                  BOOL bToBeRegistered = FALSE,
                  const char *pszHelpTopic = NULL);
   BOOL GetAdsRequest(int& nAdsStatus);
   void Break();

private:
   enum {kLoad, kUnload};

   BOOL RegisterApp();
   BOOL ParseFunctions(int eAction);
   int ExecuteCommand();

   BOOL     m_bIsInitialized;
   CAdsApp *m_pApp;
   CString  m_csRegapp;
   CObList  m_cCommandList;
};

#endif   // _ADSLINK_H
