dcl_settings : default_dcl_settings { audit_level = 1 ; }
//LISP Scope - An AutoLISP Coding and Debugging Tool
//(c) 1995 TetraLogic - All Rights Reserved
//by Christopher Barry
lspscope : dialog {
   label = "LispScope r1.2a - Loaded Symbol Viewer/Editor" ;
   key = "lspscope" ;
   initial_focus = "sc_pattern" ;
   : row {
      : column {
         : list_box {
            width = 82 ;
            label = "Evaluation" ;
            key = "eval_lst" ;
            height = 18 ;
            fixed_width = true ;
            fixed_height = true ;
         }
         spacer ;
         : row {
            : row {
               fixed_width = true ;
               children_fixed_width = true ;
               spacer_1 ;
               : image_button {
                  width = 7 ;
                  key = "logo" ;
                  is_tab_stop = false ;
                  fixed_height = true ;
                  color = graphics_background ;
                  aspect_ratio = 0.79 ;
               }
               : column {
                  spacer ;
                  : text_part {
                     alignment = centered ;
                     label = "TetraLogic" ;
                  }
                  spacer ;
               }
            }
            spacer ;
            : column {
               : row {
                  children_fixed_width = true ;
                  fixed_width = true ;
                  spacer ;
                  : text_part {
                     label = "Current Symbol: " ;
                  }
                  : text_part {
                     key = "current_sym" ;
                     width = 17 ;
                  }
                  spacer ;
               }
               : edit_box {
                  label = "Search Pattern:" ;
                  key = "sc_pattern" ;
               }
               : edit_box {
                  label = "     New Value:" ;
                  key = "new_val" ;
               }
               : row {
                  : spacer {
                     width = 1 ;
                  }
                  : text_part {
                     key = "match_msg" ;
                     width = 1 ;
                  }
               }
            }
            : row {
               fixed_width = true ;
               : column {
                  fixed_width = true ;
                  : text_part {
                     width = 6 ;
                     key = "var_type" ;
                     alignment = centered ;
                  }
                  : button {
                     label = "Dfun" ;
                     key = "set_fnc" ;
                     is_tab_stop = false ;
                  }
                  : button {
                     label = "Setq" ;
                     key = "set_val" ;
                     is_tab_stop = false ;
                     fixed_width = true ;
                     alignment = centered ;
                  }
                  spacer_1 ;
               }
            }
         }
         spacer_0 ;
      }
      : column {
         : list_box {
            fixed_height = true ;
            fixed_width = true ;
            height = 15 ;
            key = "lsp_lst" ;
            label = "Symbols" ;
            width = 19 ;
         }
         : radio_column {
            fixed_height = true ;
            : radio_button {
               mnemonic = "A" ;
               label = "Show All Symbols" ;
               key = "show_all" ;
            }
            : radio_button {
               mnemonic = "N" ;
               label = "No Subroutines" ;
               key = "show_no_subs" ;
            }
            : radio_button {
               mnemonic = "V" ;
               label = "Non-list Vars" ;
               key = "show_vars" ;
            }
         }
         : row {
            fixed_width = true ;
            children_fixed_width = true ;
            alignment = centered ;
            : text_part {
               label = "Page Width:" ;
               fixed_width = true ;
            }
            : edit_box {
               value = "80" ;
               key = "pg_width" ;
               fixed_width = true ;
               edit_width = 2 ;
               edit_limit = 2 ;
            }
         }
         : row {
            : button {
               width = 14 ;
               label = "Close" ;
               key = "lspscope_ok" ;
               is_default = true ;
               is_cancel = true ;
               height = 2 ;
            }
            : button {
               label = "?" ;
               key = "lsp_help" ;
               height = 2 ;
               fixed_width = true ;
            }
         }
         spacer_1 ;
      }
   }
}

sc_about : dialog {
   key = "sc_about" ;
   label = "LispScope r1.2a - Information HyperMenu" ;
   : image_button {
      allow_accept = true ;
      aspect_ratio = 0.79 ;
      color = black ;
      fixed_height = true ;
      fixed_width = true ;
      is_default = true ;
      key = "about_img" ;
      width = 60 ;
   }
}

sc_msg_panel : dialog {
   key = "sc_msg_panel" ;
   label = "LispScope r1.2a by TetraLogic" ;
   : list_box {
      height = 12 ;
      key = "msg_panel_list" ;
      width = 50 ;
   }
   ok_cancel ;
}
