;; LSET.lsp
;; by Bruce Flemington
;; Barrie, Ontario, Canada
;; Last updated:  Feb. 28, 1995

;; Compuserve address:  75677,3222
;; Internet address:    75677.3222@compuserve.com

;; Layer setting utility  --  to set layer current (in place of LAYER SET command)

;; Thaws layer if it is frozen, then sets it current, ending the annoying
;; practice of having to cancel the LAYER SET command and issue a LAYER THAW
;; command, followed by another LAYER SET command.

;; Makes layer if it does not exist

;; If new layer name is CONST, automatically sets color to YELLOW
;; and linetype to CONTINUOUS

;; To have LSET.lsp load automatically, edit your ACADR12.lsp
;; Search for the string ===== AutoLoad LISP Applications =====
;; add a line similar to the ones appearing below this header
;; except using "LSET" in place of any other lisp file name

; --------------------------------------------------------------------------- 

(defun C:LSET (/ def lay laycol laylt regen cmde)
  (setq cmde (getvar "cmdecho"))
  (setvar "cmdecho" 0)
  (setq lay (strcase (ustr 1 "New current layer" (getvar "clayer") nil)))
  (if (not (tblsearch "layer" lay))
    (progn
      (if (or (= "CONST" lay) (= "const" lay))
        (command ".layer" "make" "const" "c" "YELLOW" "const" "")
        (progn
          (menucmd "s=chcolor")
          (setq laycol (ustr 0 (strcat "Colour for layer " lay) "WHITE" nil))
          (menucmd "s=chlt")
          (setq laylt (ustr 0 (strcat "Linetype for layer " lay)
             "CONTINUOUS" nil))
          (command ".layer" "make" lay "c" laycol lay "lt" laylt lay "")
        )
      )
    ); progn
    (progn
      (if (= 65 (dxf 70 (tblsearch "layer" lay)))
        (progn
        (setq regen (getvar "regenmode"))
        (setvar "regenmode" 0)
        (command ".layer" "thaw" lay "set" lay "")
        (setvar "regenmode" regen)
        ); progn
      (command ".layer" "set" lay "")
      ); if
    ); progn
  ); if
  (setvar "cmdecho" cmde)
  (setq lay nil laycol nil laylt nil regen nil cmde nil def nil)
  (princ)
); defun

