;LDTOPS.LSP
;10/20/92  - Patrick Murphy, Applied Computing Services.
;12/08/94  - Corrected the date endings, finally.
;            Filename added to status line.
;Added C:RDA command as a bonus program, at bottom of file.

;Program to set MODEMACRO to show:
;the current Layer, DrawingName, Date, Time, Tablet, Ortho, Pspace and Snap.
;
;E.G.:  TEXT     C:\ACAD\DWGNAME Tue Oct 20th 7:35p   T Ortho P Snap
;
;I modified the MODE1.LSP file found in on page 120 and code on page 126
;of the AutoCAD R12 Customization Manual to arrive at this.
;
;Have this code loaded by the ACAD.LSP file and run with S::STARTUP.
;Once run, you can have it set to NIL later in S::STARTUP and free up
;a little memory.
;i.e. in your ACAD.LSP file:
;  (load "ldtops")     ;When ACAD.LSP loads, so would LDTOPS.LSP
;  ;if there isn't an S:STARTUP function already, you could use this:
;  (defun S::STARTUP ()
;   (ldtops)          ;this would run LDTOPS
;   (setq ldtops nil) ;this would free up a little memory -
;  )                  ;because MODEMACRO would already be set.
;

;----------------------------------------------------------------(ldtops)
(defun ldtops (/ daysfx dtst)
 (setvar "CMDECHO" 0)
 (setq daysfx (substr (rtos (getvar "CDATE") 2 4) 7 2)
  dtst daysfx
  daysfx       
 (cond
  ((= "11" daysfx) "th");determine the day suffix
  ((= "12" daysfx) "th")
  ((= "13" daysfx) "th")
  ((= "21" daysfx) "st")
  ((= "22" daysfx) "nd")
  ((= "23" daysfx) "rd")
  ((= "31" daysfx) "st")
  ((= "01" daysfx) "st")
  ((= "02" daysfx) "nd")
  ((= "03" daysfx) "rd")
  (T "th")))
  (setvar "modemacro"
   (strcat
   "$(substr,$(getvar,clayer),1,8)"
   "$(substr,        ,1,$(-,8,$(strlen,$(getvar,clayer)))) "
   "$(getvar,dwgname)"
   "$(edtime,$(getvar,date), "
   " "                         ;Had to call EDTIME twice because
   "DDD MON D)"                ;I wanted the suffix for the day
   daysfx                      ;(i.e. 'st') and if EDTIME was only
   "$(edtime,$(getvar,date), " ;called once the suffix became one
   "H:MMam/pm)"                ;of the EDTIME parameters, rather
   "  "                        ;than text on the status line.
   "$(if,$(getvar,tabmode), T, )"
   "$(if,$(getvar,orthomode), Ortho, )"
   "$(if,$(and,$(=,$(getvar,tilemode),0),$(=,$(getvar,cvport),1)), P, )"
   "$(if,$(getvar,snapmode), Snap)"
   " "))
 (setvar "CMDECHO" 1)
 (princ)
);defun LDTOPS

;! RDA - Repeating Distance and Angle report - a companion
;to the DIST command. Although this command leaves out
;the delta distances, it does provide, redundantly,
;the following information, as accurately as possible:
; 1) the distance in feet and inches 
; 2) the distance in decimal 
; 3) the distance in meters
; 4) the angle

;USAGE: Use this command when checking your work. Point to an
;entity, and this program will, if you are close to the entity,
;snap to it with the 'near' object snap. Move the cursor to
;a second entity and point to it, and the program will snap to
;the entity with the 'perpendicular' object snap. A white graphics
;line will temporarily display on the screen, and the distance
;and angle will be displayed on the command line and status line.
;The graphics line is placed there to indicate exactly where the
;command made the measurement. The program will repeat automatically
;until you quit the command. Any previous measurement, assuming you
;have three command lines displayed, should still be visible.

;You may type in or otherwise specify another object snap, such
;as CEN, or ENDP, as desired, for either or both measurement
;points. I chose the NEA/PER combination because it so conveniently
;measures parallel lines. You may override the default object
;snaps because the are temporarily set as running object snaps with
OSMODE, rather than as immediate object snaps.

;When you quit the command, either by pressing Enter, the spacebar,
;or by pressing control-C, the graphics line will disappear.
;Otherwise, the program will repeat and prompt you for the next point
;to measure from.

;Note: If the white graphics line somehow doesn't disappear, just
;issue a redraw command - the line is not a part of your drawing -
;this program does not modify your drawing.

;You may leave this command in this file, or copy and paste RDA
;into a seperate file.
;----------------------------------------------------------------c:rda
(defun c:rda (/ oldosm olddzn pt1 pt2 pt1g pt2g msg)
;The following is simply a error-handler for RDA.
 (defun newerr (S)
  (if (not (member S '("Function cancelled" "console break")))(princ S))
  (setvar "CMDECHO" 1)
  (if oldosm (setvar "OSMODE" oldosm))
  (if olddzn (setvar "OSMODE" olddzn))
  (setq *error* olderr olderr nil oldosm olderr olddzn oldosm)
  (redraw)(princ))
 (setq olderr *error* *error* newerr oldosm (getvar "OSMODE") olddzn (getvar "DIMZIN"))
 (graphscr)(setvar "DIMZIN" 10)(setvar "OSMODE" 512);NEA
 (while (setq pt1 (getpoint "\nNEA point: "))
  (setvar "OSMODE" 128);PER
   (if (and pt1g pt2g)(grdraw pt1g pt2g -7))
   (cond ((setq pt2 (getpoint pt1 " PER point: "))
    (grdraw pt1 pt2 7)
    (setq pt1g pt1 pt2g pt2)
    (repeat 23 (princ "\10 \10"))
    (setq msg
     (strcat "  Ft: " (rtos (distance pt1 pt2) 4 8)
      "  Dec: " (rtos (distance pt1 pt2) 2 8)
      "  Meter: " (rtos (cvunit (distance pt1 pt2) "inch" "meter") 2 8)
      "  Ang: " (angtos (angle pt1 pt2) 0 8)))
    (princ msg)(grtext -1 msg)
    (setvar "OSMODE" 512))));while
 (if (and pt1g pt2g)(grdraw pt1g pt2g -7))
 (setvar "OSMODE" oldosm)
 (setvar "DIMZIN" olddzn)
 (grtext)(setq *error* olderr olderr nil)
(princ))
(princ)
