;ͻ
;   LCs.Lsp                                            Jan 17, 1996   
;   Change Letter Case Or Export All Text On A Specified Layer        
;ͼ
;================== Start Program ======================================
(princ "\nFabricated Designs, Inc.\nLoading LCs v1.3 ")
(setq LCs nil)                                 ;Reset Program Name
;%%%%%%%%%%%%%%%%%% Macros %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
(defun PDot ()(princ "."))                     ;Print Dots
(defun BkSp () (write-char '8))                ;Back Space
(defun GetVal (n e) (cdr (assoc n e)))         ;Get Entity Value
(defun Beep (/ f)                              ;DOS Only
 (if (not (getenv "windir"))                   ;Beep
     (progn (setq f (open "con" "w"))          ;Open CON To Write
            (write-char '7 f)                  ;Print Hex 7
            (close f))))                       ;Close CON
(defun Err (e) (beep)                          ;Augmented
               (princ (strcat "\nError: " e))  ;Error
               (quit))                         ;Routine

;%%%%%%%%%%%%%%%%%% Sub Routines %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
(PDot);++++++++++++ Set Modes & Error ++++++++++++++++++++++++++++++++++
;Mode Variables  m_l SetList  m_s NewSetting  m_n OldName  m_v OldValue
 (defun lc_smd ()                              ;Define lc_smd
  (command "UNDO" "MARK")                      ;Set An Undo Mark
  (setq m_v nil m_n nil                        ;Reset Name & Value
        m_l (list "CMDECHO" "BLIPMODE" "HIGHLIGHT")
        m_s (list 0 0 1)                       ;Setup Modes
     olderr *error*                            ;Get Old Error
    *error* (lambda (s)                        ;Set Error So That
     (if (or (= s "Function cancelled")        ;If Cancel Or
             (= s "quit / exit abort"))        ;Abort Appears
         (princ)                               ;Exit Clean
         (princ (strcat "\nError: " s)))       ;Else Print Error
     (lc_rmd)))                                ;Return Modes
  (foreach x m_l (setq m_v (cons (getvar x) m_v);Get Value
                       m_n (cons x m_n)))      ;And Variable
  (mapcar 'setvar m_l m_s)                     ;Set New Modes
  (princ "\nLetter Case And Export ..."))      ;Display Program
(PDot);++++++++++++ Return Modes & Error +++++++++++++++++++++++++++++++
 (defun lc_rmd ()                              ;Define lc_rmd
  (setq *error* olderr)                        ;Reset Error
  (mapcar 'setvar m_n m_v)                     ;Reset Modes
  (prin1))                                     ;Exit Clean

(PDot);++++++++++++ Get Selection Set ++++++++++++++++++++++++++++++++++
(defun lc_gets ()                              ;Define lc_gets
  (setq lay (strcase (getstring "\nLayer To Update <*> :... ")))
  (if (or (= lay "")                           ;If Layer Input
          (= lay "*"))                         ;Null Or *
      (setq ts1 T)                             ;Set Test1 True
      (progn                                   ;Else
       (if (not (tblsearch "LAYER" lay))       ;If Layer Not Found Abort
           (err (strcat "Layer " lay " Does Not Exist")))
       (command "LAYER" "T" lay "ON" lay "S" lay "")));Set Layer
  (if ts1                                      ;Make Selection Set
     (setq ss1 (ssget "X" (list (cons 0 "TEXT"))))
     (setq ss1 (ssget "X" (list (cons 0 "TEXT") (cons 8 lay)))))
  (if (not ss1)                                ;If Selection Set Empty
      (err "No Text Was Found On Layer")))     ;Error Out

(PDot);************ Main Program ***************************************
 (defun LCs (/ m_n m_v m_s m_l olderr ss1 ost nst nt lay
             ctype ts1 s i wf wfile st sdef)   ;Define Locals
  (lc_smd)                                     ;Set Modes
; (setq *error* nil)                           ;Debugging Aid
; (setvar "CMDECHO" 1)                         ;Debugging Aid
  (lc_gets)                                    ;Get Text
  (initget "Uppercase Lowercase Export")       ;Ask For Type
  (setq ctype (getkword "\nUppercase Lowercase Export <U>:... "))
  (setq i (1- (sslength ss1))
        s (ssname ss1 i))
  (if (= ctype "Export")
      (progn
        (princ "\nFile Extension Of .TXT Will Be Used For Export")
        (setq wf (getstring "\nEnter File Name:    "))
        (if (> (strlen wf) 8)
            (err "Invalid Name:   "))
        (if (findfile (strcat (getvar "DWGPREFIX") wf ".txt"))
            (princ "\nOverwriting Existing Text File"))
        (setq wfile (open (strcat wf ".TXT") "w"))
        (princ "\nExporting Text  "))
      (princ "\nUpdating Text   "))
  (while s
    (PDot)
    (setq sdef (entget s)
             i (1- i)
             s (ssname ss1 i)
            st (GetVal 1 sdef))
    (if (= ctype "Export")
        (write-line st wfile)
        (progn
          (cond ((= ctype "Lowercase")  (setq nt (strcase st T)))
                ((= ctype "Uppercase")  (setq nt (strcase st)))
                (T                      (setq nt (strcase st))))
          (setq ost (assoc 1 sdef)             ;Set Old String
                nst (cons 1 nt)                ;Set New String
               sdef (subst nst ost sdef))      ;Substitute Values
          (entmod sdef))))                     ;Modify Entities
  (if wfile (close wfile))                     ;Close Export File
  (lc_rmd))                                    ;Return Modes

(PDot);@@@@@@@@@@@@ Load Program @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
 (defun C:LCs () (LCs))                        ;Make Command Resident
 (if LCs (princ "\nLCs Defined\n"))            ;Comfirm Loading
 (prin1)                                       ;Else Display Errors
; End Program 
;"AS IS" Public Domain Software Donated By
;
;      
;                                    ͻ
;               ۳                                            
;                             Fabricated Designs, Inc.  
;            >    <                                         
;                              ͼ
;      
;
;
;
;        Fabricated Designs, Inc.
;        32 Maury Avenue
;        Newport News, Virginia  23601-2132
;         Ph: (804) 595-5949
;        FAX: (804) 595-5787
;        CIS: 73544,2655
;   Internet: http://ourworld.compuserve.com/homepages/D_Bethel/
;
