(defun C:PLCD ; Process Layer Configuration Data
  ;by Donald Pirl CIS: 71174,1113; Internet: 'dpirl@crl.com'
  (/
    c file clyr ldat mrk1 mrk2 mrk3 lnam lafn clnm flgs colr ltyp f_now
    f_lcd of_now of_lcd ldat nell fnm
  )
  (setq 
    file (open (setq fnm (getfiled 
          "Layer Configuration Data" 
          (getvar "dwgprefix")
          "lcd" 0
    )) "r")
    clyr (read-line file)
    ldat (read-line file)
    c 0
    nell ""
  )
  (command "._undo" "group" "._layer" "t" clyr "s" clyr)
  (princ "\nWorking... ")
  (while ldat
    (setq
      mrk1 1
      mrk1
      (while (not (wcmatch (substr ldat mrk1 1) " "))
        (setq mrk1 (1+ mrk1))
      )
      mrk2 (1+ mrk1)
      mrk2
      (while (not (wcmatch (substr ldat mrk2 1) " "))
        (setq mrk2 (1+ mrk2))
      )
      mrk3 (1+ mrk2)
      mrk3
      (while (not (wcmatch (substr ldat mrk3 1) " "))
        (setq mrk3 (1+ mrk3))
      )
      lnam (substr ldat 1 (1- mrk1))
      flgs (atoi (substr ldat (1+ mrk1) (- mrk2 (1+ mrk1))))
      colr (atoi (substr ldat (1+ mrk2) (- mrk3 (1+ mrk2))))
      ltyp (substr ldat (1+ mrk3))
      clnm (tblsearch "layer" lnam)
      nell (if (not clnm) (strcat nell ", " lnam) nell)
      f_now (if clnm (= 1 (logand 1 (cdr (assoc '70 clnm)))))
      f_lcd (= 1 (logand 1 flgs))
      of_now (if clnm (<= (cdr (assoc '62 clnm)) 0))
      of_lcd (<= colr 0)
      ldat (read-line file)
    )
    (spin)
    (cond
      ( clnm
        (cond 
          ( (and (not f_now) f_lcd)
            ; (princ "F ")
            (command "F" lnam)
          )
          ( (and f_now (not f_lcd))
            ;(princ "T ")
            (command "T" lnam)
          )
        )
        (cond 
          ( (and (not of_now) of_lcd)
            ;(princ "OF ")
            (command "OF" lnam)
          )
          ( (and of_now (not of_lcd) (not f_lcd))
            ;(princ "ON ")
            (command "ON" lnam)
          )
        )
      )
    )
  )
  (write-char 08)
  (princ " done!")
  (command "" "._undo" "end")
  (close file)
  (setq nell (substr nell 3))
  (if (/= "" nell) (princ (strcat "\nLayers: " nell " no longer exist.\nRecommend recreating " fnm ".")))
  (princ)
)
