//
//    Modifications of ACAD.DCL  
//    By  :  David G. Rogillio  
//      
//    Copyright (C) 1991-1992 by Autodesk, Inc.
//         
//    Permission to use, copy, modify, and distribute this software 
//    for any purpose and without fee is hereby granted, provided 
//    that the above copyright notice appears in all copies and that 
//    both that copyright notice and this permission notice appear in 
//    all supporting documentation.
//
//    THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED
//    WARRANTY.  ALL IMPLIED WARRANTIES OF FITNESS FOR ANY PARTICULAR
//    PURPOSE AND OF MERCHANTABILITY ARE HEREBY DISCLAIMED.

// Portions of this dialog were taken from ACAD.DCL 'dlfmulti' section.

dcl_settings : default_dcl_settings { audit_level = 3; }


///                     Getfilem.dcl
///======================================================================     
///     This program is the dialog box controls for a multiple 'getfile' 
///     command to work similar to AutoCADs 'getfiled' command, but use
///     a multi-select for file selection. This dialog accompanies a
///     'getfilem.lsp' that will return a list of the files selected.
///     The lisp program will also use the same bit values as AutoCADs
///     'getfiled' command, with the excption of the (bit 0) value '1'
///     code which is used for new drawings, which this program should
///     not be used for. Also, the typeit button was removed from the
///     dialog description. For bit values see documentation accompaning 
///     the 'getfilem' lisp routine.
///
///


//  *******  modifications of section found in acad.dcl  ********
//  acad_dlfmulti is used by the FILES command's Delete and Unlock
//  options.  It is similar to acad_dlfname (above), except that:
//
//    - its file listbox has the "multiple_select" attribute,
//    - its file listbox does not have the "allow_accept" attribute,
//    - it has additional "Select all" and "Clear all" buttons, and
//    - its title bar label is slightly different.
//
//  Modifications to dialog should be examined for their relevance
//  to the other.

multi_files : dialog {                       // Multiple-file dialog
    initial_focus = "fedit";
//    label = /*MSG212*/"Select File(s)";    // Overridden by caller
    key = "multi_fl";
    files_topdf;
    : row {
        : column {
            spacer_1;
            : list_box {
                label = /*MSG213*/"Directories:";
                mnemonic = /*MSG214*/"D";
                key = "dirbox";
                height = 8;
                width = 12;
                }
            : popup_list {
                label = /*MSG213*/"Drives: ";
                mnemonic = /*MSG214*/"r";
                key = "drvbox";
                list = " C: ";
                is_enabled = false;
                width = 4;
                }
            spacer_1;
            }
        : list_box {
            label = /*MSG215*/"Files:";
            mnemonic = /*MSG216*/"i";
            key = "filebox";
            width = 15;
            multiple_select = true;
        }
        : column {
            : image {          // Drawing icon image will go here
                key = "icon";
                color = dialog_background;    // Invisible
                alignment = centered;
                height = 4;
                aspect_ratio = 1.4;
                fixed_height = true;
                fixed_width = true;
            }
            spacer_1;
            : button {
                label = /*MSG217*/"Select all";
                key = "all";
                mnemonic = /*MSG218*/"S";
            }
            : button {
                label = /*MSG219*/"Clear all";
                key = "clear";
                mnemonic = /*MSG220*/"C";
                is_enabled = false;
            }
            spacer_1;
            : button {
                label = /*MSG223*/"Default";
                key = "default";
                mnemonic = /*MSG224*/"e";
            }
        }
    }
    ok_cancel_help;
    errtile;
}
