;;;
;;;     Several of the routines found in this program are modifications
;;;     of ideas gathered in Autodesk's APPLOAD.LSP supplied with ACAD.
;;;     This is why the following disclaimer notice accompanies this program.
;;;   
;;;----------------------------------------------------------------------------
;;;   Copyright (C) 1991-1992 by Autodesk, Inc.
;;;      
;;;   Permission to use, copy, modify, and distribute this software 
;;;   for any purpose and without fee is hereby granted, provided 
;;;   that the above copyright notice appears in all copies and that 
;;;   both that copyright notice and this permission notice appear in 
;;;   all supporting documentation.
;;;      
;;;   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED
;;;   WARRANTY.  ALL IMPLIED WARRANTIES OF FITNESS FOR ANY PARTICULAR
;;;   PURPOSE AND OF MERCHANTABILITY ARE HEREBY DISCLAIMED.
;;;----------------------------------------------------------------------------
;;;
;;;   GETFILEM.LSP   Version 1.0
;;;
;;;     Written By: David Rogillio
;;;     For Use By: Entergy Systems Inc.
;;;     Date:       August 10, 1994
;;;
;;;----------------------------------------------------------------------------
;;;   DESCRIPTION
;;;
;;;     An AutoLISP routine with a dialogue interface allowing users select
;;;     multiple files. The Lisp routine must be able to find DOSLIB, which
;;;     contains many ADS commands used by the lisp to do DOS commands.
;;;     This program works similar to AutoCADs 'getfiled' command, but used
;;;     for multi-select file selection. The file getfilem.dcl that accompanies 
;;;     this lisp is the dialog interface for this lisp.
;;;
;;;     The lisp program will also use about the same bit values as AutoCADs
;;;     'getfiled' command, with some excptions.  The (bit 0) value '1'
;;;     code which is used for new drawings, which this program should
;;;     not be used for. Also, the typeit button was removed from the
;;;     dialog description. 
;;;     
;;;     GETFILEM COMMAND USAGE & BIT VALUES
;;;     ------------------------------------------------------------
;;;     (getfilem "Title of Dialog Box:" "drv:" "\\startup\\directory" "def,ext,lsp" bit)
;;;
;;;         Title of Dialog Box - The heading that appears in the top border of the dialog box.
;;;
;;;         drv: - The drive letter (followed by a ":" colon) for the dialog box to start on.
;;;                 If the drive letter is invalid or "" null string the lisp defaults to the
;;;                 drive that is presently set in the DOS shell.
;;;
;;;         \\startup\\directory - The directory path for the dialog box to start in.
;;;                 If the directory is invalid or "" null string the lisp defaults to the
;;;                 directory that is presently set as the working directory.
;;;
;;;         def,ext,lsp - The patterns of the extensions (seperated by a "," comma) you
;;;                 wish to search as inital match pattern. If pattern is "" null the lisp
;;;                 defaults to "*" and retrieves all files.
;;;
;;;         bit (code/value) - Each bit code has a value associated with it and the final
;;;                 bit value is the addition of all bit values added together. See
;;;                 bit codes descriptions and values below.
;;;
;;;         (bit 0) value = 1 - Bit 0 controls the availiable drives to the user.        
;;;                             If on (set to 1) the drive popup list is disabled & only
;;;                             the inital drive set when the command was called is valid.
;;;                             If off (set to 0) the drive popup list is enabled & the user
;;;                             may select from any availiable drive.
;;;
;;;         (bit 1) value = 2 - Bit 1 controls the type it button in 'getfiled' and is not used
;;;                             in this lisp so this bit doesn't change any settings if on (set to 2)
;;;                             or off (set to 0).
;;;
;;;         (bit 2) value = 4 - Bit 2 controls the availiable extension patterns to the user.        
;;;                             If on (set to 4) the pattern edit box is disabled & only
;;;                             the inital pattern or patterns set when the command was called  
;;;                             are valid. If off (set to 0) the pattern edit box is enabled & 
;;;                             the user may change the extension pattern search path.
;;;
;;;         (bit 3) value = 8 - Bit 3 controls the list of files returned by the 'getfilem' command.
;;;                             If on (set to 8) the full path name of each file is returned.
;;;                             If off (set to 0) only the file names with extension of the files 
;;;                             selected are returned.
;;;
;;; ===================== load-time error checking start ======================
;;;

	(defun ai_abort (app msg)
		(defun *error* (s)
			(if old_error (setq *error* old_error))
			(princ)
		)
		(if msg
			(alert (strcat " Application error: "
					app
					" \n\n  "
					msg
					"  \n"
				)
			)
		)
		(exit)
	)

;;; Check to see if AI_UTILS is loaded, If not, try to find it,
;;; and then try to load it.
;;;
;;; If it can't be found or it can't be loaded, then abort the
;;; loading of this file immediately, preserving the (autoload)
;;; stub function.

	(cond
	 (  (and ai_dcl (listp ai_dcl))             ; it's already loaded.
	 )
	 (  (not (findfile "ai_utils.lsp"))         ; find it
			(ai_abort "getfilem"
			(strcat "Can't locate file AI_UTILS.LSP."
				"\n Check support directory."))
	 )
	 (  (eq "failed" (load "ai_utils" "failed")) ; load it
			(ai_abort "getfilem" "Can't load file AI_UTILS.LSP")
	 )
	)

	(if (not (ai_acadapp))                  ; defined in AI_UTILS.LSP
		(ai_abort "GETFILEM" nil)           ; a Nil <msg> supresses
	)                                       ; ai_abort's alert box dialog.



;;; ==================== end load-time operations ===========================
;;;----------------------------------------------------------------------------
;;; The main fuinction.
;;;----------------------------------------------------------------------------
(defun GETFILEM (title def_drv def_dir def_pat def_bit /
				title       def_drv       def_dir       def_pat     def_bit
				aval_drv    drv_flg       pat_flg       typit_flg
				pat         drv           pth           fp_list2
				pat_list    set_pat_list  pickd         set_drv_list    
				start_over  upd_fl_box    temp          pickh
				fp_list1    pickf         from          pickh_list
				pickf1      pickf_list    what_pos      chk_for_files
				grey        pickf_no      pickh_no      pickd_no
				pos         upd_dir       pickd_list    fullpth
				dcl_id      item          what_next     dirbox
				make_list   rs_err        filetype      fullpth_fl
				listout     nam_and_ext   home_dir      home_drv
				filebox     count
				)
	
	(setq pth_flg 0 pat_flg 0 typit_flg 0 drv_flg 0)
	
	;;
	;; Check to see which version of DOSLIB to load.
	;; 
	(cond 
		((= (getvar "platform") "386 DOS Extender")
			(setq filetype "doslib.exp")
		)
		((= (getvar "platform") "Windows")
			(setq filetype "doslib.exe")
		)
		(t (setq filetype "doslib.exp"))
	)
	
	;; Check to see if DOSLIB is loaded, If not, try to find it,
	;; and then try to load it.
	;;
	;; If it can't be found or it can't be loaded, then abort command.
	;;
	(if (not dos_ver)
		(cond
			((not (findfile filetype))   ; find doslib
				(ai_abort "DOSLIB"
					(strcat "Can't locate file " filetype
					"\n Check support directories.")
				)
			)
			((eq "failed" (xload "doslib" "failed")) ; load it
				(ai_abort "DOSLIB" "Can't load file DOSLIB.exp")
			)
		)
	)

	(while (< 0 def_bit)
		(cond
			((<= 8 def_bit)
				(setq pth_flg 1 def_bit (- def_bit 8))
			)
			((<= 4 def_bit)
				(setq pat_flg 1 def_bit (- def_bit 4))
			)
			((<= 2 def_bit)
				(setq typit_flg 1 def_bit (- def_bit 2))
			)
			((<= 1 def_bit)
				(setq drv_flg 1 def_bit (- def_bit 1))
			)
			(T (setq def_bit 0))
		)
	)

	;;
	;; Check for valid drive and set dos directory & drive.
	;; 
	;;
	(defun set_drv_list (drv pth)
		(setq aval_drv (dos_drives))
		(if (= drv "")
			(setq drv (dos_drive) def_drv (dos_drive))
		)
		(if (member drv aval_drv)
			(setq drv1 (dos_drive drv))
			(princ (strcat " Drive Specification " drv " Invalid . "))
		)
		(if (dos_chdir pth)
			(setq pth1 (dos_pwdir))
			(setq def_dir (dos_pwdir))
		)
	)
	;;
	;; Build list of patterns to search.
	;; 
	(defun set_pat_list (pat)
		(if pat_list
			(setq old_list pat_list pat_list nil)
		)
		(if (or (= pat "")(= pat " "))
			(setq pat "*" pat_list (list "*"))
			(while (< 0 (strlen pat))
				(setq patlen (strlen pat))
				(if (or (wcmatch pat "*,*")(wcmatch pat "*;*"))
					(while (> patlen 0)
						(if (or (= (substr pat patlen 1) ",")(= (substr pat patlen 1) ";"))
							(progn
								(if (and (/= patlen 1) (/= patlen (strlen pat)))
									(setq pat_list (cons (substr pat (+ patlen 1)) pat_list))
								)
								(setq pat (substr pat 1 (- patlen 1)))
								(setq patlen (strlen pat))
							)
							(setq patlen (1- patlen))
						)
					)
				)
				(if (and (< 0 (strlen pat))(/= patlen (strlen pat)))
					(progn
						(setq pat_list (cons pat pat_list))
						(setq pat "")
					)
				)
			)
		)
		(if (or (null pat_list) (= (listp pat_list) nil))
			(if (get_tile "pedit")
				(progn
					(set_tile "error" (strcat "\nExtension Pattern " pat " Invalid." ))
					(setq pat_list old_pat_list pat "*")
				)
				(progn
					(princ (strcat "\nExtension Pattern " pat " Invalid." ))
					(setq pat "*" pat_list (list "*"))
				)
			)
		)
	)
						
	;;    
	;;=========================================================================
	;;
	;; Make a list of all highlighted files for loading or unloading.  Similar
	;; code to remfile below.  Returns the list.
	;;
	(defun make_list () ;;;;(/ pickf_no pickf_list fp_list1 n)
;        (setq pickf (get_tile "filebox"))
		(setq pickf1 pickf)
		(while (setq pickf_no (read pickf1))
			(setq pickf_list (cons pickf_no pickf_list))
			(setq pickf1 (substr pickf1 (+ 2 (strlen (itoa pickf_no)))))
		)
		(setq n 0)
		(while (< n (length filebox))
			(if (member n pickf_list)
				(setq fp_list1 (cons (nth n filebox) fp_list1))
			)
			(setq n (1+ n))
		)
		(setq n 0)
		(if (= pth_flg 1)
			(progn
				(setq fullpth (dos_pwdir))
				(while (< n (length fp_list1))
					(setq fullpth_fl (strcat fullpth "\\" (nth n fp_list1)))
					(setq fp_list2 (cons fullpth_fl fp_list2))
					(setq n (1+ n))
				)
				(setq fp_list1 (reverse fp_list2))
			)
		)
		fp_list1
	)
	(defun chk_for_files()
		(if pickf
			(done_dialog 1)
			(set_tile "error" "Invalid or empty file specification.")
		)
	)
	;;
	;; Get the highlighted directory.
	;; 
	;;
	(defun get_dir_nam (/ pickd1 pickd_no pickd_list n) 
		(setq pickd1 (get_tile "dirbox"))
		(while (setq pickd_no (read pickd1))
			(setq pickd_list (cons pickd_no pickd_list))
			(setq pickd1 (substr pickd1 (+ 2 (strlen (itoa pickd_no)))))
		)
		(setq n 0)
		(while (< n (length dirbox))
			(if (member n pickd_list)
				(progn 
					(setq pickdir (nth n dirbox))
				)
			)
			(setq n (1+ n))
		)
		(upd_dir)
	)
	;;
	;; Get the highlighted drive.
	;; 
	;;
	(defun get_drv_nam (/ pickd1 pickd_no pickd_list n) 
		(setq pickd1 (get_tile "drvbox"))
		(while (setq pickd_no (read pickd1))
			(setq pickd_list (cons pickd_no pickd_list))
			(setq pickd1 (substr pickd1 (+ 2 (strlen (itoa pickd_no)))))
		)
		(setq n 0)
		(while (< n (length aval_drv))
			(if (member n pickd_list)
				(setq pickdrv (nth n aval_drv))
			)
			(setq n (1+ n))
		)
		(dos_drive pickdrv)
	)
	;;
	;; Reset default directory and paths 
	;;
	(defun start_over ()
		(set_drv_list (strcase def_drv) def_dir)
		(set_pat_list def_pat)
		(upd_dir)
	)

	;;
	;; Reset the error tile.
	;;
	(defun rs_err()
		(set_tile "error" "")
	)
	;;
	;; Pass an item and a list and recieve a number showing it's position in  
	;; the list, nil otherwise.  Item must be in the list, and the list must 
	;; contain unique names. 0 if first item.                               
	;;
	(defun what_pos (item the_list / pos)
		(setq pos (- (length the_list)
			(length (member item the_list)))
		)          
	)
	;;
	;;   Add or remove the highlight to selections
	;;   from the current filebox
	;;
	(defun hi_lite_file ( typ )
		(if (= typ 1)
			(progn
				(mode_tile "all" 1)
				(mode_tile "clear" 0)
				(setq n 0)
				(while (< n (length filebox))
					(set_tile "filebox" (itoa n))
					(setq pickf (get_tile "filebox"))
					(setq n (1+ n))
				)
			)
			(progn
				(mode_tile "all" 0)
				(mode_tile "clear" 1)
				(upd_fl_box)
				(setq pickf nil)
			)
		)
;        (setq pickf (get_tile "filebox"))
	)
	;;
	;;  Check to see if Select all or clear buttons should be enabled
	;;
	(defun grey (/ pickh pickh_list pickh_no)
		(setq pickh (get_tile "filebox"))
		(while (setq pickh_no (read pickh))
			(setq pickh_list (cons pickh_no pickh_list))
			(setq pickh (substr pickh (+ 2 (strlen (itoa pickh_no)))))
		)
		(if (< (length pickh_list) (length filebox))
			(mode_tile "all" 0)
			(mode_tile "all" 1)
		)
		(if (> 1 (length pickh_list))
			(mode_tile "clear" 1)
			(mode_tile "clear" 0)
		)
	)
	;;
	;;  Remove an item from the list. 
	;;
	(defun remove (what from)
		(append (reverse (cdr (member what (reverse from))))
			(cdr (member what from))
		)
	)
	;;
	;; Build and display a list in the dir_box
	;;
	(defun upd_dir ()
		(setq dirbox nil)
		(if pickdir
			(dos_chdir pickdir)
		)

		(setq dirbox (dos_subdir))
		
		(if (and dirbox (< (length dirbox) (getvar "maxsort")))
			(setq dirbox (acad_strlsort dirbox))
		)
		
		(if (not (member ".." dirbox))
			(progn
				(setq dirbox (cons ".." dirbox))
				(setq dirbox (cons "\\" dirbox))
			)
			(progn
				(setq dirbox (cons "\\" dirbox))
			)
		)
		
		(start_list "dirbox" 3)
		(mapcar 'add_list dirbox)
		(end_list)
		(set_tile "dirtext" (dos_pwdir))
		(setq pickdir nil)
		(upd_fl_box)
	)
	;;
	;; Build and display a list in the file_box
	;;
	(defun upd_fl_box ()
		(setq count 0 filebox nil)
		(if (and pat_list (listp pat_list)) 
			(while (< count (length pat_list))
				(setq find_fl (strcat "*." (nth count pat_list)))
				(if (setq fls_found (dos_dir find_fl))
					(foreach temp fls_found (setq filebox (cons temp filebox)))                 
				)
				(setq count (1+ count))
			)
			(setq filebox (dos_dir "*.*"))
		)
		(if (and filebox (< (length filebox) (getvar "maxsort")))
			(setq filebox (acad_strlsort filebox))
		) 
		(start_list "filebox" 3)
		(mapcar 'add_list filebox)
		(end_list)
;;    (set (read (eval which_box)) which_list)
	)
	;;
	;; Put up the multi-file selection dialogue.
	;;
	(defun getfilem_main()
		
		(if (not (new_dialog "multi_files" dcl_id)) (exit))
		
		(mode_tile "drvbox" drv_flg)
		(if (= drv_flg 0)
			(progn
				(start_list "drvbox" 3)
				(mapcar 'add_list aval_drv)
				(end_list)
				(set_tile "drvbox" (itoa (what_pos (dos_drive) aval_drv)))
			)
			(set_tile "drvbox" (itoa (what_pos (dos_drive) aval_drv)))
		)
		(upd_dir)
	
	;; 
	;; Set modes & action expressions for the dialog box
	;; 
		(if (and title (/= title ""))
			(set_tile "multi_fl" title)
		)
		
		(set_tile "pedit" def_pat)
					
;        (mode_tile "typeit" typit_flg)
		(mode_tile "pedit" pat_flg)
		(mode_tile "all" 0)
		(mode_tile "clear" 1)
		
		(action_tile "pedit"       "(rs_err)(set_pat_list $value)(upd_fl_box)" ) 
		(action_tile "drvbox"      "(rs_err)(setq pickdrv (get_drv_nam))(upd_dir)" ) 
		(action_tile "dirbox"      "(rs_err)(if (= $reason 4)(get_dir_nam))" ) 
		(action_tile "filebox"     "(rs_err)(setq pickf $value)(grey)" )
		(action_tile "all"         "(rs_err)(hi_lite_file 1)" )
		(action_tile "clear"       "(rs_err)(hi_lite_file 0)" )
		(action_tile "default"     "(rs_err)(start_over)" )
		(action_tile "accept"      "(chk_for_files)" )
		(action_tile "cancle"      "(done_dialog 0)" )
		(action_tile "help"        "(acad_helpdlg \"acad.hlp\" \"getfilem\")")
		(setq what_next (start_dialog))
		(if (= what_next 1)
			(setq listout (make_list))
			(setq listout nil)
		)
		(dos_drive home_drv)
		(dos_dir home_dir)
		(xunload "doslib")
		(princ)
	)
		
	
	;; Set up error function.
	(setq old_cmd (getvar "cmdecho")    ; save current setting of cmdecho
		old_error  *error*              ; save current error function
		*error* ai_error                ; new error function
		home_drv (substr (getvar "dwgprefix") 1 2)
		home_dir (substr (getvar "dwgprefix") 3)
	)
	(setvar "cmdecho" 0)

	(set_drv_list (strcase def_drv) def_dir)
	(set_pat_list def_pat)


	(cond
		(  (not (ai_transd)))                       ; transparent OK
		(  (not (ai_acadapp)))                      ; ACADAPP.EXP xloaded?
		(  (not (setq dcl_id (ai_dcl "getfilem")))) ; is .DCL file loaded?
		(t (getfilem_main))                          ; proceed!
	)

	(setq *error* old_error) 
	(setvar "cmdecho" old_cmd)

	(princ)
	listout
)

