;  By:  Eric W. Janson       Date: 10/24/94              Acad Version12c3
;  -------------------------------------------------------------------------
;  Description: This routine is an aid in documenting the multiple font
;               types available in AutoCad.
;  -------------------------------------------------------------------------
;  This routine is offered as shareware.  If you use it and
;  find that it saves time and effort in managing fonts please
;  register it. Registration entitles you to use it on as
;  many machines as you wish in one location only.
;  The registration fee is $15.00.  Please send name,
;  address, Email address, and $15.00 to:
;                       Eric W. Janson
;                       8 Wellfeet Lane
;                       Wayne, PA 19087
;  All upgrades will be free to registered users. If you
;  make a suggestion on ways to improve this program and it
;  is used you will receive credit in the routine, and free
;  registration. Send comments and suggestions to the above
;  address or on compuserve to 70672,2233.  Thanks for your
;  support.
;  -------------------------------------------------------------------------
(defun c:fontdoc ( / xp yp dr1 dr2 dr3 var)
(setvar "cmdecho" 0)
(setvar "tilemode" 0)
(setq $CLR$ (getvar "cecolor"))
(setq RMODE (getvar "regenmode"))
(setvar "regenmode" 0)
        (setq XP 0               ;x point
              YP 0               ;y point
              BP (LIST XP YP)    ;base point of page
             BPC 0               ;base point counter
             CNT 1               ;font counter
        )

(getfile)
    (setq DR1 (strcat "dir " Path "*.shx /b /o > c:\\shx.lst" ) )
    (setq DR2 (strcat "dir " Path "*.pfb /b /o > c:\\fpb.lst" )  )
    (setq DR3 (strcat "copy c:\\shx.lst + c:\\fpb.lst c:\\font.lst") )
(textpage)
    (prompt "\n\n\n\tCreating necessary files.........")
    (print)(print)(print)
    (command "shell" DR1)
    (command "shell" DR2)
    (command "shell" DR3)
    (setq DR1 (strcat "del c:\\shx.lst"))
    (setq DR2 (strcat "del c:\\fpb.lst"))
    (setq DR3 (strcat "del c:\\font.lst"))
(graphscr)

(GETTTL)
          (setq FNT (open "c:\\font.lst" "r"))
          (setq STYL (read-line fnt))
(setq CNTR 0)
(while (/= TTL CNTR)
(PLIN) (PGNM) (TLIN) (POS)
(setq CNTR (+ 1 CNTR))
);end while
(command "zoom" "e")
(setvar "regenmode" RMODE)
(close FNT)
(textpage)
(prompt "\n\n\n\tCleaning up...........")
    (print)(print)(print)
    (command "shell" DR1)
    (command "shell" DR2)
    (command "shell" DR3)

(foreach var (list '$clr$ 'bp 'bpc 'cnt 'cntr 'cttl 'fnt 'lstpt
'nxtpt 'ostyl 'path 'styl 'styln 'styln 'ttl 'vtxt ) (set VAR nil))

(graphscr)
(prompt "FONTDOC.LSP (C) Eric W. Janson 1994. CIS 70672,2233")
(princ)
);end defun
;*************************************************************************
;Find where the .shx files are, thanks to George J. Mercadante
;for suggesting and writing this subroutine
(defun GETFILE ( / Found Place)
 (setq Path (findfile "TXT.shx"))                    ; let default Path be where
 (if Path (setq Path (substr Path 1 (- (strlen Path) 7))) ) ;   TXT.shx is found
 (while (not Found)    (print)(print)
   (initget "Yes No")
   (if Path (setq Found (getkword (strcat "FONTDOC - Use directory " Path " ? <Y/n>: ")))
            (setq Found "No")
   )
   (cond
      ( (not Found)         (setq found t))  ; User hit Enter - accepts default
      ( (= Found "Yes")                   )  ; User accepts default
      ( t                                    ; User doesn't accept default
          (setq Path (getfiled "FONTDOC : Select any SHX file" "" "SHX" 2)
                Path (substr Path 1 (- (strlen Path) 4))  ; get any SHX file
               Place (strlen Path)   )       ; determine where file name starts
          (while (/= "\\" (substr Path Place 1) ) (setq Place (1- Place)) )
          (setq Path (substr Path 1 Place))  ;subtract file name from Path
      );t
   );cond
 ):while
); defun
;**************************************************************************
;get the total number of fonts and calculate number of pages
(defun getttl ()
         (setq TTL 0)
         (setq FNT (open "c:\\font.lst" "r"))
  (while (/= nil (read-line fnt))
         (setq TTL (+ 1 ttl))
  );end while
(close FNT)
      (if (/= (rem TTL 12) 0)
          (setq TTL (+ (/ ttl 12) 1))
          (setq TTL (/ ttl 12))
       );end if
);end defun
;**************************************************************************
;Draw the p-line page border
(defun plin ( / pt1 pt2 pt3 pt4)
        (setq PT1 BP
              PT2 (strcat "@11<<90")
              PT3 (strcat "@8.5<<0")
              PT4 (strcat "@11<<270")
          )
    (setvar "cecolor" "green")
    (command "pline" pt1 pt2 pt3 pt4 "c")
    (setvar "cecolor" $CLR$)
);end defun
;**************************************************************************
;Write each line of text
(defun tlin (/ ht spt smpl)
        (setq HT 0.25)
        (setq CNT 0)
(while (< CNT 12)
     (if (= STYL NIL)
        (progn
          (prompt "\nThat's all there is....")
          (setq CNT 12)
         )
        (progn
        (setq SMPL "ABCDefgh 12345678")
        (setq SPT (strcat "@.75,10"))
        (setq STYLN (substr STYL 1 (- (strlen STYL) 4)))
    (command "style" STYLN STYL "" "" "" "" ""
    (if (= 1 (getvar "cmdactive"))(prompt "") ))
        (setq spc (textbox (list (cons 1 SMPL)))  )
          (while (> (distance (car spc) (cadr spc)) 6.5) ;2.5)
            (setq SMPL (substr SMPL 1 (- (strlen SMPL) 1)))
            (setq spc (textbox (list (cons 1 SMPL)))  )
          )
 (if (= cnt 0)
    (progn
        (command "id" BP)
        (command "text" SPT HT "" SMPL)
        (ntxt)
     );end progn
     (progn
        (setq SPT (strcat "@0,-.80"))
        (command "id" (getvar "lastpoint"))
        (command "text" SPT HT "" SMPL)
        (ntxt)
     );end progn
   );end if
        (setq STYL (read-line fnt))
        (setq CNT  (+ CNT 1))
        (princ ". ")
       );end progn
      );end if
);end repeat
);end defun
;**************************************************************************
;Number the pages
(defun pgnm (/ ht ppt ptxt)
        (setq HT 0.125)
     (if (= CTTL nil)
        (setq CTTL 1)
        (setq CTTL (+ CTTL 1))
     )
    (command "ID" BP)
    (command "style" "romans" "romans.shx" "" "" "" "" "" "")
        (setq PPT (strcat "@8,.375"))
        (setq PTXT (strcat "Page " (rtos cttl 2 0) " of " (rtos ttl 2 0)))
    (command "text" "r" PPT HT "" PTXT)
(princ " ")
(princ (strcat "\nCreating " PTXT ))
);end defun
;**************************************************************************
;Determine the basepoint of the page
(defun pos (/ )
        (setq BPC (+ 1 bpc))
        (if (/= BPC 3)
            (progn
               (setq YP (+ YP 11)
                     BP (list XP YP)
              )
            )
            (progn
               (setq YP 0
                     XP (+ XP 8.5)
                     BP (list XP YP)
                     BPC 0
                )
            )
        )
);end defun
;**************************************************************************
(defun ntxt ()
;note the text style etc.
        (setq LSTPT (getvar "lastpoint"))
        (setq NXTPT (strcat "@0,-.203125"))
        (setvar "cecolor" "red")
    (setq OSTYL STYL)
    (command "style" STYLN STYL "" "" "" "" ""
       (if (= 1 (getvar "cmdactive")) "Y" ))

       (setq VTXT (tblsearch "style" STYLN))
(if (/= 4 (logand (cdr (assoc 70 VTXT)) 4))
    (setq STYL (strcat STYL ",  NO vertical"))
)

        (command "style" "romans" "romans.shx" "" "" "" "" "" "N")

        (command "text" NXTPT "0.09375" "" STYL)

    (command "style" STYLN OSTYL "" "" "" "" ""
       (if (= 1 (getvar "cmdactive")) "N" ))

        (command "id" LSTPT)
        (setvar "cecolor" $CLR$)
);end defun
