;FLASH.LSP            COPYRIGHT (C) 1988,1989,1990             BOB GALBRAITH
;                         ALL RIGHTS RESERVED
(setvar "cmdecho" 0)
(command ".vslide" "/fl/flash")

(defun C:CLEAN (/ i item)
(setq i 0)
(while (not (equal (setq item (nth i atomlist)) 'C:CLEAN))
(if (= (type (eval item)) 'FILE)  ; ensure files closed
(close (eval item)))
(setq i (1+ i))
)
(setq atomlist (member 'C:CLEAN atomlist))  
'DONE 
)
(DEFUN C:AC()
(COMMAND "ARC")
)
(DEFUN C:A()
(COMMAND "AREA")
)
(DEFUN C:AR()
(COMMAND "ARRAY")
)
(DEFUN C:B()
(COMMAND "BREAK")
)
(DEFUN C:BK()
(COMMAND "BLOCK")
)
(DEFUN C:CF()
(COMMAND "CHAMFER")
)
(DEFUN C:CO()
(COMMAND "COPY")
)
(DEFUN C:C()
(COMMAND "CIRCLE")
)
(DEFUN C:CG()
(COMMAND "CHANGE")
)
(DEFUN C:DN()
(COMMAND "DONUT")
)
(DEFUN C:D()
(COMMAND "DIST")
)
(DEFUN C:DT()
(COMMAND "DTEXT")
)
(DEFUN C:DC()
(COMMAND "DIM1" "CENTER")
)
(DEFUN C:DE()
(COMMAND "DIVIDE")
)
(DEFUN C:DA()
(COMMAND "DIM1" "ANG")
)
(DEFUN C:DD()
(COMMAND "DIM1" "DIA")
)
(DEFUN C:DH()
(COMMAND "DIM1" "HOR")
)
(DEFUN C:DQ()
(COMMAND "DIM1" "ALIGNED")
)
(DEFUN C:DR()
(COMMAND "DIM1" "RADIUS")
)
(DEFUN C:DV()
(COMMAND "DIM1" "VERT")
)
(DEFUN C:DL() 
(COMMAND "DIM1" "LEADER")
)
(DEFUN C:DS()
(COMMAND "DIM1" "DIMSCALE")
)
(DEFUN C:ET()
(COMMAND "EXTEND")
)
(DEFUN C:E()
(COMMAND "ERASE")
)
(DEFUN C:EV()
(COMMAND "ELEV")
)
(DEFUN C:EX()
(COMMAND "EXPLODE")
)
(DEFUN C:EL()
(COMMAND "ELLIPSE" "C")
)
(DEFUN C:F()
(COMMAND "FILES")
)
(DEFUN C:FL()
(COMMAND "FILLET")
)
(DEFUN C:G()
(COMMAND "GRID")
)
(DEFUN C:H()
(COMMAND "HATCH")
)
(DEFUN C:HD()
(COMMAND "HIDE")
)
(DEFUN C:I()
(COMMAND "INSERT")
)
(DEFUN C:L()
(COMMAND "LINE")
)
(DEFUN C:LA()
(COMMAND "LAYER")
)
(DEFUN C:LS()
(COMMAND "LAYER" "SET")
)            
(DEFUN C:LI()
(COMMAND "LAYER" "?")
(COMMAND "*")
)
(DEFUN C:LM()
(COMMAND "LIMITS")
)
(DEFUN C:M()
(COMMAND "MOVE")
)
(DEFUN C:MR()
(COMMAND "MIRROR")
)
(DEFUN C:MS()
(COMMAND "MSLIDE")
)
(DEFUN C:O()
(COMMAND "OFFSET")
)
(DEFUN C:P()
(COMMAND "PLINE")
)
(DEFUN C:PE()
(COMMAND "PEDIT")
)
(DEFUN C:PY()
(COMMAND "POLYGON")
)
(DEFUN C:R()
(COMMAND "REDRAW")
)
(DEFUN C:RO()
(COMMAND "ROTATE")
)
(DEFUN C:S()
(COMMAND "SNAP")
)
(DEFUN C:SA()
(COMMAND "STATUS")
)
(DEFUN C:SO()
(COMMAND "SOLID")
)
(DEFUN C:ST()
(COMMAND "STRETCH" "CROSSING")
)
(DEFUN C:SC()
(COMMAND "SCALE")
)
(DEFUN C:SV()
(COMMAND "SETVAR")
)
(DEFUN C:T()
(COMMAND "TRIM")
)
(DEFUN C:TC()
(COMMAND "TRACE")
)
(DEFUN C:TX()
(COMMAND "TEXT")
)
(DEFUN C:UN()
(COMMAND "UCSICON" "OFF")
)
(DEFUN C:UP()
(COMMAND "UCS" "P")
)
(DEFUN C:UO()
(COMMAND "UCSICON" "ON")
)
(DEFUN C:UF()
(COMMAND "UCSICON" "OFF")
)
(DEFUN C:UA()
(COMMAND "SETVAR" "UCSFOLLOW" "1")
)
(DEFUN C:UB()
(COMMAND "SETVAR" "UCSFOLLOW" "0")
)
(DEFUN C:U3()
(COMMAND "UCS" "3")
)
(DEFUN C:UX()
(COMMAND "UCS" "X" "90")
)
(DEFUN C:UY()
(COMMAND "UCS" "Y" "90")
)
(DEFUN C:UZ()
(COMMAND "UCS" "Z" "90")
)
(DEFUN C:V()
(COMMAND "VIEWRES" "Y")
)
(DEFUN C:VS()
(COMMAND "VSLIDE")
)
(DEFUN C:3V()
(COMMAND "VPOINT" "")
)
(DEFUN C:3L()
(COMMAND "3DLINE")
)
(DEFUN C:3F()
(COMMAND "3DFACE")
)
(DEFUN C:DU()
(COMMAND "DVIEW")
)
(DEFUN C:WB()
(COMMAND "WBLOCK")
)
(DEFUN C:Z()
(COMMAND "ZOOM")
)
(DEFUN C:ZA()
(COMMAND "ZOOM" "ALL")
)
(defun C:ZE ()
(command "ZOOM" "W" (getvar "VSMIN") (getvar "VSMAX"))
)
(defun drawbox ()
(grdraw ll ul -1)  (grdraw ul ur -1)
(grdraw ur lr -1)  (grdraw lr ll -1)
(if (= mode 0) (cenx) (arrow))
)
(defun cenx ()
   (grdraw x1 x2 -1)  (grdraw x3 x4 -1)
)
(defun arrow ()
   (grdraw a1 a4 -1)  (grdraw a2 a4 -1)  (grdraw a3 a4 -1)
)
(defun defbox ()
(setq deltay (* deltax aspect))
(setq xcen (car center) ycen (cadr center))
(setq lx (- xcen deltax) ux (+ xcen deltax))
(setq ly (- ycen deltay) uy (+ ycen deltay))
(setq ll (list lx ly) ul (list lx uy))
(setq ur (list ux uy) lr (list ux ly))
(setq yp (+ ycen arm) ym (- ycen arm))
(setq a1 (list (- ux arm) yp) a2 (list (- ux arm) ym))
(setq a3 (list (- ux arm arm) ycen))
(setq a4 (list ux ycen))
(setq x1 (list (- xcen arm) ym) x2 (list (+ xcen arm) yp))
(setq x3 (list (- xcen arm) yp) x4 (list (+ xcen arm) ym))
(drawbox)
)
(defun C:ZX (/ arm aspect center deltax inp loop mode prev pt source)
(setq center (getvar "VIEWCTR"))
(setvar "LASTPOINT" (setq prev center))
(setq aspect (/ (cadr (setq aspect (getvar "SCREENSIZE"))) (car aspect)))
(setq deltax (* 0.25 (getvar "VIEWSIZE")))
(setq arm (* 0.1 deltax) mode 0 loop T)
(defbox)
(while loop
(setq inp (grread T))
(setq source (car inp) pt (cadr inp))
(cond ((= source 3) ; "pick" button?
(cenx) (arrow)
(setq mode (- 1 mode))
(setvar "LASTPOINT" center))
((= source 5)
(if (or (/= (car  prev) (car  pt))
(/= (cadr prev) (cadr pt)))
(progn
(if (= mode 0)
(setq center pt)
(setq deltax (+ deltax (- (car pt) (car prev)))))
(setq prev pt)
(drawbox)
(defbox)
)))
((or (and (= source 6) (= pt 0)); button 1, or
(and (= source 2)
(or (= pt 13) (= pt 32))))
(drawbox)
(command "ZOOM" "W" ll ur)
(setq loop nil))
(T
(drawbox)
(setq loop nil a " ^cancel "))
)
)
)(DEFUN C:ZW()
(COMMAND "ZOOM" "WINDOW")
)
(DEFUN C:ZP()
(COMMAND "ZOOM" "PREVIOUS")
)
(DEFUN C:ES()
(COMMAND "EDGESURF")
)
(DEFUN C:RS()
(COMMAND "REVSURF")
)
(DEFUN C:RF()
(COMMAND "RULESURF")
)
(DEFUN C:TS()
(COMMAND "TABSURF")
)
(DEFUN C:S1()
(COMMAND "SETVAR" "SURFTAB1")
)
(DEFUN C:S2()
(COMMAND "SETVAR" "SURFTAB2")
)
(DEFUN C:3M()
(COMMAND "3DMESH")
)
(DEFUN C:3P()
(COMMAND "3DPOLY")
)
(defun C:X (/ p l n e os as ns st s nsl osl sl si chf chm cont)
(setq chm 0 p (ssget)) ; Select objects
(if p (progn  ; If any objects selected
(setq cont t)
(while cont
(setq osl (strlen (setq os (getstring "\nOld string: " t))))
(if (= osl 0)
(princ "Null input invalid")
(setq cont nil)
)
)
(setq nsl (strlen (setq ns (getstring "\nNew string: " t))))
(setq l 0 n (sslength p))
(while (< l n)  ; For each selected object...
(if (= "TEXT"   ; Look for TEXT entity type (group 0)
(cdr (assoc 0 (setq e (entget (ssname p l))))))
(progn
(setq chf nil si 1)
(setq s (cdr (setq as (assoc 1 e))))
(while (= osl (setq sl (strlen
(setq st (substr s si osl)))))
(if (= st os)
(progn
(setq s (strcat (substr s 1 (1- si)) ns
(substr s (+ si osl))))
(setq chf t) ; Found old string
(setq si (+ si nsl))
)
(setq si (1+ si))
)
)
(if chf (progn  ; Substitute new string for old
(setq e (subst (cons 1 s) as e))
(entmod e) ; Modify the TEXT entity
(setq chm (1+ chm))
))
)
)
(setq l (1+ l))
)
))
(princ "Changed ") ; Print total lines changed
(princ chm)
(princ " text lines.")
(terpri)
)
