{************************************************************************
 ************************************************************************

PROGRAM DXFCHECK   (FREEWARE)

  written by Werner Gre, Hannover Germany, 17.12.94
  on Turbo Pascal 5.5

  This program solves a problem that AutoCad(r) has with very large handles.
  If these handles exeed the amount of 'FFFFFFFFFFFFFFF' AutoCad tries to
  begin again with 'F00000000000000', which causes double handles,
  or in some cases even causes a fatal crash down.

  DXFCHECK will set down all handles to their smallest possible value
  starting with '1'.
  DXFCHECK removes lonely POLYLINE-VERTICES, since this is one of the most
  common errors on reading DXF files.

  You may use the programm like this:

  1. Make a DXF-file of your drawing.

  2. On DOS-prompt call:
     DXFCHECK <filename> [</r>]
     where <filename> is a filename without extension (.dxf assumed)
     and the facultative </r>-switch causes the program to
     remove all handles!

  3. Start Autocad with ACAD <filename>=

  4. In AutoCad use DXFIN <filename>

     DXFCHECK check's the input-file for POLYLINE-VERTEX errors but it
     will only work with DXF-files written by AutoCad!

*************************************************************************
*************************************************************************}

program dxfdown;

uses dos,crt,tbwinf;

const maxlen = 17;

type  refptr = ^refrec;                 {We need a dynamic pointer structure}
      refrec = record                   {since we don't know how many}
          oldref : string[maxlen];      {cross-handles will exist.}
          newref : string[maxlen];
          next   : refptr;
      end;
      bufptr = ^linebuffer;
      linebuffer = record
          line : string;
          next : bufptr;
      end;

var refs,p,wurzel  : refptr;
    buffer,b,bwurz : bufptr;
    neuref         : string[maxlen];
    infile,
    outfile        : text;
    wref           : boolean;
    wline          : byte;

{****** Converting strings to upper case *******}
function ucase(st:string):string;
var i : byte;
begin
  for i:=1 to length(st) do st[i]:=upcase(st[i]);
  ucase:=st;
end;

{****** Finding then next hexadecimal value of a given hex-string }
function nexthex(hex : string):string;
var l        : byte;
    ovf      : boolean;
    hexchars : string[17];
begin
  hexchars:='0123456789ABCDEF0';
  l:=length(hex);
  ovf:=True;
  while ovf do begin
     if hex[l]=hexchars[16] then begin
         hex[l]:=hexchars[1];
         if l=1 then hex:='0'+ hex;
         if l>1 then dec(l);
       end else begin
         hex[l]:=hexchars[pos(hex[l],hexchars)+1];
         ovf:=false;
     end;
  end;
  nexthex:=hex;
end;

{****** Filling then dynamic structure for for cross-handles }
procedure store(eedref:string);
var ref,p : refptr;
    n     : longint;
begin
   ref:=refs;
   while (ref^.next <> NIL) and (ref^.oldref <> eedref) do ref:=ref^.next;
   if ref^.oldref <> eedref then begin
     ref^.oldref:=eedref;
     neuref:=nexthex(neuref);
     ref^.newref:=neuref;
     new(p);
     fillchar(p^,sizeof(p^),0);
     ref^.next:=p;
   end;
   if wref then title_window(bottom,right,' New HANDSEED: '+neuref+' ');
end;

{****** Is 'st' really a HEX number? *****************************}
function checkhex(st:string):boolean;
var hexchars : string[16];
    n        : byte;
begin
  checkhex:=true;
  hexchars:='0123456789ABCDEF0';
  for n:=1 to length(st) do
     if pos(st[n],hexchars)<1 then  checkhex:=false;
  if length(st)=0 then checkhex:=false;
end;
{****** Finding out whether a handle is referenced by a cross-handle }
function downsize(eedref,dummy:string):string;
var ref : refptr;
    n   : longint;
begin
   ref:=refs;
   while (ref^.next <> NIL) and (ref^.oldref <> eedref) do ref:=ref^.next;
   if ref^.oldref = eedref then begin
       downsize:=ref^.newref;
     end else begin
       if checkhex(eedref) then
           downsize:=dummy else downsize:=eedref;
   end;
end;
function fillbuffer(buf:bufptr;var typ:string):boolean;
label raus;
const pline = 'POLYLINE';      vertex = 'VERTEX';      seqend = 'SEQEND';
      block = 'BLOCK';         endblk = 'ENDBLK';      dxf0   = '  0';
var zeile            : string;
    vertex_count     : longint;
    ende             : boolean;
    bwurz,rbuf       : bufptr;
    eedref       : string[maxlen];

begin
   ende:=false;
   vertex_count:=0;
   fillbuffer:=false;
   repeat
      readln(infile,zeile);
      rbuf:=buf;
      buf^.line:=zeile;
      new(bwurz);
      fillchar(bwurz^,sizeof(bwurz^),0);
      buf^.next:=bwurz;
      buf:=bwurz;
      if zeile=dxf0 then begin
          readln(infile,zeile);
          buf^.line:=zeile;
          new(bwurz);
          fillchar(bwurz^,sizeof(bwurz^),0);
          buf^.next:=bwurz;
          buf:=bwurz;
          if zeile=vertex then begin
             inc(vertex_count);
             if vertex_count>1 then begin
                ende:=true;
                fillbuffer:=true;
                goto raus;
             end;
          end;
          if zeile=seqend then begin
               ende := true;
               if vertex_count>1 then fillbuffer:=true else begin
                  if wline<14 then begin
                      qprint(1,wline,'        Lonely POLYLINE-VERTEX removed!');
                      inc(wline);
                     end else
                      qscrol(scup,'        Lonely POLYLINE-VERTEX removed!');
                  fillbuffer:=false;
                  repeat
                      readln(infile,zeile);
                  until zeile=dxf0;
               end;
               goto raus;
          end;
          if (zeile<>vertex) and (zeile<>seqend) then begin
             ende:=true;
             goto raus;
          end;
      end;
      if (zeile='  5') or (zeile='1005') then begin
           readln(infile,eedref);
           if eedref <> '0' then begin
              eedref:=downsize(eedref,'XX');
              if eedref='XX' then begin
                  eedref:=nexthex(neuref);
                  neuref:=nexthex(neuref);
                  if wref then title_window(bottom,right,' New HANDSEED: '+neuref+' ');
              end;
           end;
           if wref or (not (checkhex(eedref))) then begin
               buf^.line:=eedref;
               new(bwurz);
               fillchar(bwurz^,sizeof(bwurz^),0);
               buf^.next:=bwurz;
               buf:=bwurz;
           end;
           if not wref then buf:=rbuf;
        end else begin
       end;
   until ende;
   raus:
   typ:=zeile;
end;
procedure flushbuffer(buf:bufptr);
begin
  repeat
    writeln(outfile,buf^.line);
    buf:=buf^.next;
  until buf^.next = NIL;
  if length(buf^.line)>0 then writeln(outfile,buf^.line);
end;

{ ****************  MAIN  ******************
  Doing all the stuff like reading parameters,
  opening and closing files, reading, writing etc.}
label start;
const dxfext = '.DXF';
      tmpext = '.$$$';

var params,ptpos : byte;
    dxfin        : string;
    buf          : bufptr;
    zeile,
    typ          : string;
    eedref       : string[maxlen];
    bufok,polytry: boolean;

begin
  params := paramcount;
  clrscr;
  neuref:='1';
  wline:=3;
  wref := true;
  if params >= 1 then dxfin:= paramstr(1) else begin
     write('Filename, extension DXF assumed: ');
     readln(dxfin);
     ptpos:=pos('.',dxfin);
     dxfin:=copy(dxfin,1,1-ptpos);
  end;
  if (params = 2) and (ucase(paramstr(2))='/R') then wref:=false;
  mach_window(5,10,15,60,white,blue,white,2,no,false);
  mark(refs);
  new(wurzel);
  fillchar(wurzel^,sizeof(wurzel^),0);
  title_window(top,mid,'DXFCHECK (c)1994 by  * arso *   Advanced Technologies');
  refs:=wurzel;
  wurzel^.next:=NIL;
  assign(infile,dxfin+dxfext);
  {$i-}
  reset(infile);
  {$i+}
  if ioresult=0 then begin
     if wref then begin
        qprint(1,1,'Step 1, finding cross-handles');
        repeat
          readln(infile,zeile);
          if zeile='1005' then begin
              readln(infile,eedref);
              if (eedref <> '0') then store(eedref);
          end;
        until eof (infile);
        reset(infile);
     end;
     assign(outfile,dxfin+tmpext);
     {$i-}
     rewrite(outfile);
     {$i+}
     if wref then
          qprint(1,2,'Step 2, writing output file')
        else
          qprint(1,2,'Removing handles, writing output file');
     repeat
       readln(infile,zeile);
       start:
       polytry:=false;
       if (zeile='  0') then begin
          mark(b);
             new(bwurz);
             buffer:=bwurz;
             buf:=bwurz;
             fillchar(bwurz^,sizeof(bwurz^),0);
             buf^.line:=zeile;
             new(bwurz);
             fillchar(bwurz^,sizeof(bwurz^),0);
             buf^.next:=bwurz;
             buf:=bwurz;
             readln(infile,typ);
             buf^.line:=typ;
             bufok:=false;
             if typ='POLYLINE' then begin
                new(bwurz);
                fillchar(bwurz^,sizeof(bwurz^),0);
                buf^.next:=bwurz;
                buf:=bwurz;
                polytry:=true;
                bufok:=fillbuffer(buf,typ);
             end else begin
                flushbuffer(buffer);
                readln(infile,zeile);
             end;
             if bufok then begin
                flushbuffer(buffer);
                {zeile:=typ;}
                release(b);
                readln(infile,zeile);
                goto start;
               end else begin
                if polytry then zeile:=typ;
                release(b);
                if polytry then goto start;
             end;
          release(b);
       end;
       if (zeile='  5') or (zeile='1005') then begin
           readln(infile,eedref);
           if eedref <> '0' then begin
              eedref:=downsize(eedref,'XX');
              if eedref='XX' then begin
                  eedref:=nexthex(neuref);
                  neuref:=nexthex(neuref);
              end;
           end;
           if wref or (not (checkhex(eedref))) then begin
               writeln(outfile,zeile);
               writeln(outfile,eedref);
           end;
       end else writeln(outfile,zeile);
       if (not wref) and (zeile='$HANDLING') then begin
           readln(infile,zeile);
           writeln(outfile,zeile);
           readln(infile,zeile);
           writeln(outfile,'     0');
       end;
       if (not wref) and (zeile='$HANDSEED') then begin
           readln(infile,zeile);
           writeln(outfile,zeile);
           readln(infile,zeile);
           writeln(outfile,'     0');
       end;
     until eof(infile);
     if wref then begin
       reset(outfile);
       rewrite(infile);
       if wline<14 then begin
           qprint(1,wline,'Step 3, Adjusting new HANDSEED');
           inc(wline);
          end else
           qscrol(scup,'Step 3, Adjusting new HANDSEED');
       repeat
           readln(outfile,zeile);
           writeln(infile,zeile);
           if zeile='$HANDSEED' then begin
               readln(outfile,zeile);
               writeln(infile,zeile);
               readln(outfile,zeile);
               eedref:=nexthex(neuref);
               if wref then title_window(bottom,right,' New HANDSEED: '+eedref+' ');
               writeln(infile,eedref);
           end;
       until eof(outfile);
       close (infile);
       close(outfile);
       assign(outfile,dxfin+tmpext);
       {$I-}
       erase(outfile);
       {$I+}
     end else begin
       close (infile);
       close(outfile);
       assign(infile,dxfin+dxfext);
       erase(infile);
       assign(outfile,dxfin+tmpext);
       rename(outfile,dxfin+dxfext);
   end;
   end else exit;
   release(refs);
   remove_window;
end.
