;--- DOR.LSP
;   This command will draw parametric doors in parallel line "walls"
;   it gaps the wall for the door symbol and draws the door, jamb, swing
;   and header.  It will also prompt for changing the Swing or Hinge point.
;   All items drawn can be placed on differing layers and colors
;
;           Written by :    M. Kiker 73423,1707
;           Date:           6/1/95
;
;    USE AT YOUR OWN RISK...
;
;
;     Copyright (C) 1995 by Moonlight Software
;
;     Permission to use, copy, modify, and distribute this software 
;     for any purpose and without fee is hereby granted, provided 
;     that the above copyright notice appears in all copies and that 
;     both that copyright notice and this permission notice appear in 
;     all supporting documentation.
;
;     THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED
;     WARRANTY.  ALL IMPLIED WARRANTIES OF FITNESS FOR ANY PARTICULAR
;     PURPOSE AND OF MERCHANTABILITY ARE HEREBY DISCLAIMED.
;     ****************************************************************


(defun catcherr (s)
   (if (/= s "Function cancelled")   ; If an error (such as CTRL-C) occurs
      (princ (strcat "\nError: " s)) ; while this command is active...
   )
   (setq p nil)                      ; Free selection set
   (setq *error* olderr)             ; Restore old *error* handler
   (princ)
)

(Defun C:DOR (/ offdist offdist2)
(setq olderr *error*
      *error* catcherr)
(setvar "cmdecho" 0)
(setq jamblay (getstring "Enter Jamb layer: "))
(setq jambcol (getstring "Enter Jamb color: "))
(setq doorlay (getstring "Enter Door layer: "))
(setq doorcol (getstring "Enter Door color: "))
(setq headlay (getstring "Enter Head layer: "))
(setq headcol (getstring "Enter Head color: "))
(setq swglay (getstring "Enter Swing layer: "))
(setq swgcol (getstring "Enter Swing color: "))
(command "layer" "t" jamblay "t" doorlay "t" headlay "t" swglay "" "")
(initget "Y y")
(setq offdoor (getstring "Do you want to offset the door from a corner? (Yes or No): "))
    (if (or (= offdoor "Y")(= offdoor "y"))
    (progn
    (setq offdoor 1)
    (initget 7)
    (setq OFFDIST (getdist "\nEnter offset distance for door from corner: "))
    )
    (progn
    (setq offdoor nil)              ;set offset value for future test
    (setq OFFDIST 0)                ;set offset to zero
    ))
(Initget 7)
(Setq DOORSIZE (Getdist "\nEnter width of door: "))
(setq OFFDIST2 (+ DOORSIZE OFFDIST)) ; the size of the door plus any offset
(setvar "osmode" 0)
(if (= offdoor 1)
    (progn
    (setvar "osmode" 33)
    (Initget 1)
    (Setq P1 (Getpoint "\nSelect First wall at corner point: "))
    )
    (progn
    (setvar "osmode" 512)
    (Initget 1)
    (Setq P1 (Getpoint "\nSelect First wall at hinge point: "))
    ))
(setvar "Lastpoint" P1)
(setvar "osmode" 128)
(Initget 1)
(Setq P2 (Getpoint "\nSelect opposite wall perpendicular to hinge: "))
(setvar "osmode" 512)
(Initget 1)
(Setq P3 (Getpoint "\nSelect direction of swing on hinge side of wall: "))
(setvar "osmode" 0)
(setq A1 (Angle P1 P3))             ; angle of wall
(setq A2 (Angle P1 P2))             ; angle of header
(if (= offdoor 1)                   ; if it is to be offset
    (progn
    (setq R1 (Polar P1 A1 OFFDIST))
    (setq R2 (Polar P2 A1 OFFDIST))
    (setq R3 (Polar R1 A1 DOORSIZE))
    (setq R4 (Polar R3 A2 (Distance P1 P2)))
    (setq P5 (Polar R1 (+ Pi A2) DOORSIZE))
    )
    (progn                          ; if it is not offset
    (setq R1 P1)
    (setq R2 P2)
    (setq R3 (Polar R1 A1 DOORSIZE))
    (setq R4 (Polar R3 A2 (Distance P1 P2)))
    (setq P5 (Polar R1 (+ Pi A2) DOORSIZE))
    )
) ;if


;--- draw jamb
(Command "layer" "m" jamblay "c" jambcol "" "")
(Command "Break" R1 R3 "Break" R2 R4)
(Command "Line" R1 R2 "")
(setq ssdoor (ssadd (entlast)))
(Command "Line" R3 R4 "")
(ssadd (entlast) ssdoor)

;--- draw door
(Command "layer" "m" doorlay "c" doorcol "" "")
;(Command "Line" R1 P5 "")
         (setq offset 1.0)
         (setq ang1 (angle r1 r3))             ;retrieve angle for door
         (setq ang2 (+ ang1 (/ PI 2)))         ;set perpendicular angle
         (setq pt1 R1)
         (setq pt2 P5)                         ;calc lower right corner of box
         (setq pt3 (polar pt2 ang1 offset))    ;calc upper right corner of box
         (setq pt4 (polar pt1 ang1 offset))    ;calc upper left cornar of box
         (command "pline" pt1 pt2 pt3 pt4 "c") ;draw line around text
(ssadd (entlast) ssdoor)

;--- draw swing
(Command "layer" "m" swglay "c" swgcol "" "")
(Command "Arc" R3 "E" PT3 "D" (Polar R3 (+ Pi A2) doorsize))
(ssadd (entlast) ssdoor)

;--- draw header
(Command "layer" "m" headlay "c" headcol "" "")
(Command "Line" R1 R3 "")
(ssadd (entlast) ssdoor)
(Command "Line" R2 R4 "")
(ssadd (entlast) ssdoor)

;---- Swing door
(initget "S H")
(Setq flip (getstring "\nChange Swing (in/out) or Hinge point (rt/lft)? (S or H): "))
    (if (or (= flip "S")(= flip "s"))
    (swing)
    )
    (if (or (= flip "H")(= flip "h"))
    (hinge)
    )
)
;---- Swing command
(defun swing()
        (setq PNT1 r1)
        (setq PNT2 r2)
        (setq PNT3 r3)
        (setq PNT4 r4)
        (setq H_DIST (distance PNT1 PNT2))
        (setq HH_DIST(/ H_DIST 2.0))
        (setq ANG1 (angle PNT1 PNT2))
        (setq MP1 (polar PNT1 ANG1 HH_DIST))
        (setq MP2 (polar PNT3 ANG1 HH_DIST))
        (command "mirror" ssdoor "" mp1 mp2)
        )

;---- Hinge command
(defun hinge()
        (setq PNT1 r1)
        (setq PNT2 r2)
        (setq PNT3 r3)
        (setq PNT4 r4)
        (setq H_DIST (distance PNT1 PNT3))
        (setq HH_DIST(/ H_DIST 2.0))
        (setq ANG1 (angle PNT1 PNT3))
        (setq MP1 (polar PNT1 ANG1 HH_DIST))
        (setq MP2 (polar PNT2 ANG1 HH_DIST))
        (command "mirror" ssdoor "" mp1 mp2)
        )
 (princ)
