; DIMPL.LSP     
;
; Copyright 1995 Manu-Soft Computer Services
;
; Unsupported freeware, tested in R12 only!
;
; ** Dimension property line distance and bearing **
;
; Inserts PL_DIM.DWG and sets the two attribute values
; to the distance and bearing of the second point
; relative to the base point.  The block color is set
; to magenta (this can be changed near the end of
; this file).
;
;
; ***************************************
; ****  Author:  Owen Wengerd        ****
; ****                               ****
; ****  Manu-Soft Computer Services  ****
; ****  P.O. Box 84                  ****
; ****  Fredericksburg, OH  44627    ****
; ****  (216) 695-5903               ****
; ****  Compu-Serve ID:  71324,3252  ****
; ***************************************


(defun C:DP 

  (/ errexit dimplx findparent angtos_d dindstr findstrf newstr
     p1 p2 bearing len dist switch inspt p)

  (defun errexit (s)
    (princ "\nError:  ")
    (princ s)
    (restore)
  )

  (defun dimplx ()
    (setvar "ATTDIA" (nth 1 oldvar))
    (setvar "CECOLOR" (nth 2 oldvar))
    (setvar "OSMODE" (nth 3 oldvar))
    (setvar "CMDECHO" (car oldvar))
    (setq *error* olderr)
    (princ)
  )

  (defun angtos_d (brg)
    (setq brg (angtos brg 4 4))
    (newstr (newstr brg "d" "%%d ") "'" "' ")
  )

  (defun findparent (ent)
    (while
      (and
        (setq ent (entnext ent))
        (/= (cdr (assoc 0 (setq edata (entget ent)))) "SEQEND")
      )
    )
    (if ent (cdr (assoc -2 edata)))
  )

  (defun findstr (str find len / pos ret match)
    (if len            
      (if (zerop len)
        (defun match (s) (wcmatch s find))
        (defun match (s) (wcmatch (if (substr s 1 len) find)))
      )
      (defun match (s) (= (substr s 1 (strlen find)) find))
    )
    (setq pos (1+ (strlen str)))
    (while (> (setq pos (1- pos)) 0)
      (if (match (substr str pos)) (setq ret (cons pos ret)))
    )
    ret
  )

  (defun findstrf (str find len)
    (car (findstr str find len))
  )

  (defun newstr (str old new / pos)
    (if (setq pos (findstr str old nil))
      (foreach p (reverse pos)
        (setq str
          (strcat (substr str 1 (1- p)) new (substr str (+ p (strlen old))))
        )
      )
      str
    )
  )

;*******  MAIN PROGRAM  ********

  (setq oldvar
    (list
      (getvar "CMDECHO")
      (getvar "ATTDIA")
      (getvar "CECOLOR")
      (getvar "OSMODE")
    )
  )
  (setq olderr  *error*
        restore dimplx
        *error* errexit
  )
  (setvar "CMDECHO" 0)
  (setvar "ATTDIA" 0)
  (setvar "OSMODE" 33)
  (if
    (and
      (setq p1 (getpoint "\nPick base point: "))
      (setq p2 (getpoint p1 "\nPick next point: "))
    )
    (progn
      (setvar "OSMODE" 0)
      (setq inspt (getpoint "Pick approximate text location: ")
            dist (* (getvar "DIMLFAC") (setq len (distance p1 p2)))
            bearing (angle p1 p2)
            inspt (polar p1 bearing
                    (if inspt
                      (* len
                        (/
                          (setq p (distance p1 inspt))
                          (+ p (distance p2 inspt))
                        )
                      )
                      (/ len 2.0)
                    )
                  )
      )
      (if (and (> bearing (/ pi 2.0)) (<= bearing (* pi 1.5)))
        (setq switch (+ bearing pi))
      )
      (setvar "CECOLOR" "MAGENTA") ;Make the block magenta
      (command "._INSERT"
               "PL_DIM"
               inspt
               (* (getvar "DIMTXT") (getvar "DIMSCALE"))
               ""
               (/ (* (if switch switch bearing) 180.0) pi)
               (if switch (angtos_d bearing) (strcat (rtos dist 2 2) "'"))
               (if switch (strcat (rtos dist 2 2) "'") (angtos_d bearing))
      )
      (setvar "ATTDIA" 1)
      (setvar "CECOLOR" (nth 2 oldvar))
      (command "._DDATTE" (entlast))
    )
  )
      
  (restore)
)
