;;;------------------------------------------------------------------------
;;;   DEBUG.LSP / Function: *break*
;;;   Copyright (C) 1995 by Dave Paul, TDS TELECOM - Southeast Region
;;;		CompuServe:	70524,3046
;;;		INTERNET:		70524,3042@compuserve.com
;;;
;;;   Permission to use, copy, modify, and distribute this software
;;;   for any purpose and without fee is hereby granted, provided
;;;   that the above copyright notice appears in all copies and that
;;;   both that copyright notice and this permission notice appear in
;;;   all supporting documentation.
;;;
;;;   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED
;;;   WARRANTY.  ALL IMPLIED WARRANTIES OF FITNESS FOR ANY PARTICULAR
;;;   PURPOSE AND OF MERCHANTABILITY ARE HEREBY DISCLAIMED.
;;;
;;;   Revision date: July 10, 1995
;;;------------------------------------------------------------------------
;;;   DESCRIPTION:
;;;			This function will print to the text screen the value of
;;;			user supplied symbols with their names during the execution
;;;			of the program or function to be tested.  The symbol *test*
;;;			must be set non-nil at the beginning of program or function
;;;			to be tested.  This is a modified routine using input from
;;;			Tony Tanzillo and Michael Weaver.  DEBUG must be loaded along
;;;			with the routine you are testing.
;;;
;;;		USAGE:
;;;			(*break* <breakpoint> <symbol name(s)>)
;;;				breakpoint - a string designating the breakpoint
;;;				symbol name(s) - a variable length list of symbol names
;;;													as strings
;;;
;;;		EXAMPLE:
;;;			(defun function_name ...
;;;				(setq *test* t)
;;;				.
;;;				..... Program Data .....
;;;				.
;;;				(setq test_cnt 1
;;;							test_str "Good Morning"
;;;							test_list '(1 2 3 4 5)
;;;				)
;;;				(*break* "1" '("test_cnt" "test_str" "test_list"))
;;;				.
;;;				..... Program Data .....
;;;				.
;;;			)
;;;
;;;			This example will print out:
;;;			
;;;			*** Breakpoint 1 ***
;;;
;;;			test_cnt ............ 1
;;;			test_str ............ Good Morning
;;;			test_list ........... (1 2 3 4 5)
;;;
;;;			<space> to step to next Breakpoint / X to stop Breakpoints
;;;
;;;
(defun *break* (b_pnt var_list / bp_cnt get)
	(if *test*
	; if *test* is non-nil
		(progn
			(princ (strcat "\n*** Breakpoint " b_pnt " ***\n"))
			;	print breakpoint number or text
			(setq bp_cnt 0)
			;	set breakpoint count to zero
			(while (< bp_cnt (length var_list))
			;	if the breakpoint count is less than the length of the variable list
				(princ (strcat "\n" (nth bp_cnt var_list) " "))
				;	print a newline, the symbol name, and a space
				(repeat (- 20 (strlen (nth bp_cnt var_list))) (princ "."))
				;	print "20 minus the symbol text length" dots (.)
				(princ " ")
				;	print a space before symbol data
				(princ (eval (read (nth bp_cnt var_list))))
				;	print the symbol assignment
				(princ)
				(setq bp_cnt (1+ bp_cnt))
				;	increment the breakpoint count
			)
			(princ "\n\n<Space> to step to next Breakpoint / X to stop Breakpoints\n\n")
	    (if (or (= (setq get (cadr (grread))) 88) (= get 120))
			;	if typed char equals either "X" or "x"
				(setq *test* nil)
			)
		);					end progn
	);					end if *test*
);					end *break*
