; DEMO.LSP - This is short AutoLISP program to demo the functionality of
; DB-ACAD; A AutoCAD application to access dBASE database files.
;
;
;
(PRINC "\nLoading DB-ACAD demo AutoLISP.....")
(XLOAD "DBR11")
(DEFUN fld(num d) (CDR (ASSOC num d)))

; FUNCTION : ADD - This allows the user to select an entity, then grab the
; entity handle and search the database to see if that handle has already
; been entered in.
(DEFUN c:add()
   (IF (SETQ e1 (ENTSEL "\nSelect entity to add to database:"))
      (PROGN
         (SETQ ent (ENTGET (CAR e1)))
         (SETQ enthandle (db_rtrim (fld 5 ent)))   ; Grab entity handle
         (db_close)                                ; close current database
         (db_use "valves.dbf")                     ;Open database
         (IF (db_locate "HANDLE" enthandle)
            (PROGN
               (PRINC "\nEntity already exists in database\n")
               (PRINC "Valve type: ")     (PRINC (db_rtrim (db_getfield "type")))
               (PRINC " - Valve class: ") (PRINC (db_rtrim (db_getfield "class")))
               (PRINC " - Valve rating: ")(PRINC (db_rtrim (db_getfield "rating")))
               (PRINC " - Notes: ")       (PRINC (db_rtrim (db_getfield "notes")))
            )
            (PROGN
               (db_append)
               (db_replace "type"   (GETSTRING "\nEnter valve type: "))
               (db_replace "class"  (GETSTRING "\nEnter valve class: "))
               (db_replace "rating" (GETSTRING "\nEnter valve rating: "))
               (db_replace "notes"  (GETSTRING T "Enter notes: "))
               (db_replace "handle" enthandle)
            )
         )
         (db_close)
      )
      (PROGN
         (PRINC "\nNo entity selected\n")
      )
   )
   (PRINC)
)

(DEFUN c:disp()
   (IF (SETQ e1 (ENTSEL "\nSelect entity to display database record:"))
      (PROGN
         (SETQ ent (ENTGET (CAR e1)))
         (SETQ enthandle (db_rtrim (fld 5 ent)))   ; Grab entity handle
         (db_close)                                ; close current database
         (db_use "valves.dbf")                     ;Open database
         (IF (db_locate "HANDLE" enthandle)
            (PROGN
               (PRINC "\nEntity already exists in database.\n")
               (PRINC "Valve type: ")     (PRINC (db_rtrim (db_getfield "type")))
               (PRINC " - Valve class: ") (PRINC (db_rtrim (db_getfield "class")))
               (PRINC " - Valve rating: ")(PRINC (db_rtrim (db_getfield "rating")))
               (PRINC " - Notes: ")       (PRINC (db_rtrim (db_getfield "notes")))
            )
            (PRINC "\nEntity has no database record.\n")
         )
         (db_close)
      )
      (PROGN
         (PRINC "\nNo entity selected.\n")
      )
   )
   (PRINC)
)

; Function to search through the complete database and if the record is found
; return T otherwise nil. If a search is true the database pointer is left
; the record required.
(DEFUN db_locate(field value)
   (db_top)
   (SETQ found nil)
   (WHILE (AND (NOT (db_eof))
              (NOT found)
          )
      (SETQ fvalue (db_rtrim (db_getfield field)))
      (IF (= fvalue value)
         (SETQ found T)
         (db_skip 1)
      )
   )
   (SETQ found found)
)

; FUNCTION : VALVELIST - A command to display on the AutoCAD text screen all
; entries in the database.
;
(DEFUN C:VALVELIST()
   (IF (db_use "valves.dbf")
      (PROGN
         (db_top)
         (WHILE (NOT (db_eof))
            (PRINC "\nType: ")     (PRINC (db_rtrim (db_getfield "type")))
            (PRINC " - Class: ") (PRINC (db_rtrim (db_getfield "class")))
            (PRINC " - Rating: ")(PRINC (db_rtrim (db_getfield "rating")))
            (PRINC " - Notes: ")       (PRINC (db_rtrim (db_getfield "notes")))
            (db_skip 1)
         )
         (db_close)
      )
      (PRINC "\nERROR : Trouble opening VALVES.DBF\n")
   )
)
(PRINC "Complete\n")(PRINC)
