;Permission is given by author to use and edit freely.

;With this program you may select multiple entities, it will filter out 
;non-text items and change the text - style, size, and width - to what 
;is desired. (the style must be loaded).

;Author: D. Smith
;Aug 8, 1994
;----------------------------------------------------------------------------

(defun c:ctsize ( / oldecho style chk sz wd n i ent type new new2 new3 old old2 old3)
  (COMMAND "UNDO" "E")
  (setq oldecho (getvar "CMDECHO"))
  (setvar "CMDECHO" 0)
  (setq ss (ssget)
        style (getstring "\nEnter new text Style <default>: "))
  (if (/= style "") (progn      ;;CHECK TO SEE IF VALID STYLE
    (setq chk (tblsearch "style" style))
    (if (= chk nil) (princ "\n **> Invalid Style or Style Not Loaded <**"))))
  (setq sz (getdist "\nEnter new Size <default>: ")
        wd (getdist "\nEnter new Width <default>: ") 
        n (sslength ss)
        i 0)
  (repeat n                   ;;LOOPS FOR EACH ITEM IN SET
    (setq ent (entget (ssname ss i))
          i (+ 1 i)                 ;;CHECK & SELECT ONLY TEXT 
          type (assoc 0 ent))
    (if (= "TEXT" (cdr type)) (progn
      (if sz (progn                  ;;CHANGE TEXT SIZE
        (setq old (assoc 40 ent)     ;;SUBSTITUTE NEW FOR OLD AND UPDATE ENTITY
	      new (cons (car old) sz)
	      ent (subst new old ent))
	(entmod ent)))
      (if wd (progn                  ;;CHANGE TEXT WIDTH
	(setq old2 (assoc 41 ent)
	      new2 (cons (car old2) wd)
	      ent (subst new2 old2 ent))
	(entmod ent)))
      (if style (progn               ;;CHANGE TEXT STYLE   
	(setq old3 (assoc 7 ent)
	      new3 (cons (car old3) style)
	      ent (subst new3 old3 ent))
	(entmod ent)))
      )) 
    ) 
(setvar "CMDECHO" oldecho)
(princ "\nDone!") (princ)
)





































