;                             CTOS.lsp
;                Michael K. Weaver CIS #71461,1775
;                       Copy To Other Space
;                         Wed 06-23-1993 
;               Copywrite (c) Michael K. Weaver 1993


;With tilemode turned off this routine will copy entities from the
;current space to the other space.  This is done taking into account
;the model view zoom scale factor and user coordinate systems.  The
;copied entities will be aligned with the model view just as they
;were in thier original space.


(defun c:ctos(;                         Copy entities To Other Space
  /;                    no formal arguments
  rtd;                  radians to degrees, internal function
  *error*;              local error handler
  olderr;                       old error handler
  cmdecho;                      original cmdecho setting
  undo;                         undo flag
  ucsold;                       ucs flag (if true then the model space ucs
        ;                       was changed by the routine and needs to be
        ;                       restored.
  ss1;                          selection set of entities to copy
  ss2;                          selection set of viewport entities
  pt1;                          base point
  pt1ms;                        model space equivalent of pt1
  pt1ps;                        paper space equivalent of pt1
  psucsrot;                     rotation angle of ucs in paper space
  msucsrot;                     rotation angle of ucs in model space
  indx;                         counter for loop through viewport entities
  sslen;                        number of viewport entities
  vp;                           viewport entity name
  vplist;                       entity list for vp
  vpstat;                       viewport status (cdr assoc 68 vplist)
  xdata;                        extended entity data for vp
  twangle;                      view twist angle
  inssf;                        insertion scale factor
 );                     end of local variable list
 (setq olderr *error*)
 ; Local Functions 
 ;radians to degrees
 (defun rtd (a);                        CONVERT RADIANS TO DEGREES
    (/ (* a 180.0) pi)
 )

 (defun *error*(st);                    error handler for c:ctos
  (if undo 
   (progn
    (command)
    (command)
    (command)
    (command "undo" "e" "u")
   )
  )
  (if cmdecho (setvar "cmdecho" cmdecho))
  (princ st)
  (setq *error* olderr)
 )

;  START MAIN ROUTINE 
 (if (= (getvar "tilemode") 1)
  (princ "\nThis routine is invalid  with tilemode set to 1. ")
  (progn;                       tilemode is 0
   (setq
    olderr *error*
    cmdecho (getvar "cmdecho")
    expert (getvar "expert")
    undo T
   )
   (if #test (setq *error* olderr) (setvar "cmdecho" 0))
   (command "undo" "g")
   (if (= (getvar "cvport") 1)
    (progn; you are in paper space  
     (if (setq
       ss1 (princ "\nSelect entities to copy to model space: ")
       ss1 (ssget)
      );                        end setq
      (progn;                   paper space entities selected
       (setq
        pt1 '(0 0 0)
        psucsrot (rtd (angle '(0 0) (getvar "ucsxdir")))
        pt1ms (trans (trans pt1 1 2) 3 2)
       );                    end setq
       (setvar "expert" 6)
       (command "mspace" "ucs" "s" "ctos")
       (command "ucs" "v")
       (setq
        ucsold T
        pt1ms (trans pt1ms 2 1)
        msucsrot (rtd (angle '(0 0 0) (getvar "ucsxdir")))
       )
       (command ".pspace")
       (command ".block" "temp")
;      (if (tblsearch "block" "temp")
;       (command "y")
;      )
       (command pt1 ss1 "" "oops")
       (command ".mspace")
       (setq
        ss2 (ssget "X" '((0 . "viewport")))
        indx -1
        sslen (sslength ss2)
       )
       (while (> sslen (setq indx (1+ indx)))
        (setq
         vp (ssname ss2 indx)
         vplist (entget vp '("acad"))
         vpstat (cdr (assoc 68 vplist))
         indx (if (= vpstat 1) sslen indx)
        )
       );                     end while looking for the active viewport
       (setq
        xdata (cdadr (assoc -3 vplist))
        twangle (rtd (getvar "viewtwist"))
        inssf (/ 1.0 (mvsf vp))
       )
       (command "insert" "temp" pt1ms inssf "" (+ (- 0 twangle) psucsrot (- 0 msucsrot)))
       (command "ucs" "r" "ctos" "ucs" "r" "ctos")
       (setq ucsold nil)
       (command ".explode" (entlast))
       (initget 1 "Yes No")
       (command "pspace")
       (if (= "No" (getkword "\nErase original entities?Yes/No "))
        nil
        (command ".erase" ss1 "")
       )
      );                        end progn entities selected
     );                         end if paper space entities selected
    );                          end progn you are in paper space
    (progn;                     you are in model space
     (if (setq
       ss1 (princ "\nSelect entities to copy to paper space: ")
       ss1 (ssget)
      )
      (progn
       (command "ucs" "s" "ctos")
       (if (tblsearch "ucs" "ctos") (command "y"))
       (command "ucs" "v")
       (setq
        ucsold T
        pt1 '(0 0 0)
        twangle (rtd (getvar "viewtwist"))
        pt1ps (trans (trans pt1 1 2) 2 3)
        msucsrot(rtd (angle '(0 0) (getvar "ucsxdir")))
       )
       (command "pspace")
       (setq pt1ps (trans pt1ps 2 1))
       (command "mspace")
       (command ".block" "temp")
       (if (tblsearch "block" "temp")
        (command "y")
       )
       (command pt1 ss1 "" "oops")
       (setq
        ss2 (ssget "X" '((0 . "viewport")))
        indx -1
        sslen (sslength ss2)
       )
       (while (> sslen (setq indx (1+ indx)))
        (setq
         vp (ssname ss2 indx)
         vplist (entget vp '("acad"))
         vpstat (cdr (assoc 68 vplist))
         indx (if (= vpstat 1) sslen indx)
        );                                       end setq
       );                                        end while
       (command "pspace")
       (setq
        psucsrot(rtd (angle '(0 0) (getvar "ucsxdir")))
        inssf (mvsf vp)
       )
       (if *break* (*break* "This is a test"))
       (command "insert" "temp")
       (command "sc" inssf)
       (command "rot" (- twangle (* -1 msucsrot) psucsrot))
       (command pt1ps)
       (command ".explode" (entlast))
       (command "mspace")
       (command "ucs" "r" "ctos" "ucs" "r" "ctos")
       (initget 1 "Yes No")
       (if (= "No" (getkword "\nErase original entities?Yes/No "))
        nil
        (command ".erase" ss1 "")
       );                                end if erase ss1?
      );                                   end progn entities selected
     );                                    end if entities selected??
    );                          end progn you are in model space
   );                           end if
   (setvar "expert" expert)
   (command "undo" "e")
   (setq undo nil)
   (setvar "cmdecho" cmdecho)
   (setq *error* olderr)
  );                            end progn
 );                             end if
 (princ)
);                              end ctos


(defun mvsf(;           Model View Scale Factor subroutine
  ent;                          viewport entity name
  /;                            no formal arguments
  vpxdata;                      viewport extended entity data
  ms_height;                    model view height (in model space)
  ps_height;                    paper space viewport height
  mvsf;                         Model View Scale Factor
  entxdata;                     get extended entity data
 )
; SUBROUTINES 
 (defun entxdata(; get entity data with extended data.  By Tony Tanzillo
   ent;                          entity name
   appid;                        name of the registered application
   /;                    end of formal arguments
   d;                            extended entity data
  );                     end of local variable list
  (if (and
    (setq d (entget ent (list appid)));    entity list retrieved
    (setq d (assoc -3 d));                 extended entity data exists
    (cdadr d);                             extended entity data retrieved
   );                                      end of condition
   (cdadr d)
  );                                       end if
 );                                        end entxdata
 (setq
  vpxdata (entxdata ent "acad")          ;Get extended entity data
  ms_height (cdr (nth 6 vpxdata))          ;MS view height.
  ps_height (cdr (assoc 41 (entget ent)));PS viewport height
 )
 (/ ps_height ms_height)
)

(progn
 (princ " C:CTOS Copy To Other Space *** Michael Weaver CIS #71461,1775")
 (princ)
)
