/*this program executes a specified lisp routine for each drawing in a
  directory that matches the specified file name mask.  The program is
  executed as follows:  CREATSCR <filename mask> <directory1> <directory2>
  <directory3> ... <lisp routine>.
  The program reads the filename mask and adds .DWG extension to it.
  It then reads the directories specified in the command line and creates
  a script file that causes AutoCAD to load each drawing in the specified
  directories and execute the lisp routine specified at the end of the command
  line.  A batch file named CADSCR must be used to start AutoCAD with the
   script file.  The script file is created with the assumption that it is
   started from the command line.  See the AutoCAD reference manual for
   an explanation of the script file */


/* on the command line specify the complete path name for each directory, and
   last specify the lisp file to run.  Do not put the lsp extension on the
   file, and the routine to execute is must be the same name as the lisp file
   with (DEFUN C:)*/
/*done 4/14/88*/
#include <dos.h>
#include <dir.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <process.h>

extern int errno;
extern char *sys_errlist[];

void createscript(FILE *scrfile,struct ffblk *cfile,char *cdir,
		  char *lisproutine);
/*this function recieves the script file pointer, the current file block,
  the current directory, and the lisproutine name.  All DWG file names are
  read and the script file is created to modify the drawings with the
  specified lisp routine*/

 void main(int argc,char *argv[])
 {
 struct ffblk filestructure;
 int directorycount,nomorefiles;
 char currentdirectory[40];
 FILE *scriptfile;
 char filemask[16];
 sprintf(filemask,"\\%s.dwg",argv[1]);
 scriptfile=fopen("C:\\ACAD\\AUTOSCR.SCR","w");
 for (directorycount=2;directorycount<argc-1;directorycount++)
   {/*for all directories specified*/
   strcpy(currentdirectory,argv[directorycount]);
   strcat(currentdirectory,filemask); /*get only drawing files*/
   nomorefiles=findfirst(currentdirectory,&filestructure,FA_ARCH);
   if (nomorefiles==-1)
      fprintf(stderr,sys_errlist[errno]);
   else
      createscript(scriptfile,&filestructure,currentdirectory,argv[argc-1]);
   }
fprintf(scriptfile,"0\r");
fclose(scriptfile);
}

void createscript(FILE *scrfile,struct ffblk *cfile,char *cdir,
		  char *lisproutine)
{
char directory[40];
char scriptline[80],filename[13],*extension;
int endofdir;
strcpy(directory,cdir);
extension=strrchr(directory,'\\'); /*eliminate the *.dwg for the script file*/
*(extension+1)='\0';
/*get all drawing files in directory cdir*/
for (endofdir=0;!endofdir;)
   {/*as long as there are files endofdir will be 0*/
   strcpy(filename,cfile->ff_name);
   extension=strchr(filename,'.');
   *extension='\0'; /*eliminate extension on drawing name*/
   sprintf(scriptline,"2\r%s%s\r(LOAD \042%s\042)\r%s\rEND\r",directory,
   filename,lisproutine,lisproutine);/*creates script command as follows
	 2<CR>path/drawing<CR>(LOAD "lisproutine")<CR>lisproutine<CR>END<CR>*/
   fprintf(scrfile,scriptline);
   endofdir=findnext(cfile);
   if (endofdir)
      fprintf(stderr,"Directory %s processed\n",cdir);
   }
}
