; PROGRAM NAME: CONST

; PURPOSE: Draws construction lines at various locations and offsets

; Copyright (C) 1991, CAD Consulting Services
;	Programmer: Steve McGuinness:
; Home Phone: (203) 757-7365

; Permission to use, copy, modify, and distribute this software and its
; documentation for any purpose and without fee is hereby granted.  

; HISTORY LOG:
;	7-1-90	 David Knapp -Initial Coding
;	8-4-90	 Steve McGuinness - Modular Design, Code & Command Reduction
;	8-9-90	 Dave Knapp - Corrected OACL Offset distances (via DTR)
;	11-10-91 Steve McGuinness - Code reduction

; COMMANDS DEFINED:
;	OHVCL	Draws both Hor. & Vert. lines through a point
;	OHCL	Draws a Horizontal line through a point
;	OVCL	Draws a Vertical line through a point
;	OACL	Draws a Diagonal line through a point

; MODULES DEFINED:
;	GENERR	General error handling routine
;	DTR	Degrees to radians
;	RTD	Radians to degrees
;	CONST	Main Routine for above commands
;	GETINFO	Gets offset point and distance
;	CLINE	Draws the construction lines
;	GETPTS	Gets enpoints of lines at screen edge

;PROGRAM CODE:

(defun c:OHVCL ()	(const "B"))
(defun c:OHCL ()	(const "H"))
(defun c:OVCL ()	(const "V"))
(defun c:OACL ()	(const "A"))

(defun GENERR (s)
   (if (/= s "Function cancelled")
      (princ (strcat "\nError: " s))
   )
   (setq tset nil); Free selection set
   (setq *error* olderr)
   (princ)
)

(defun DTR (A) (* PI (/ A 180.0)))
(defun RTD (R)	(* R (/ 180.0 PI)))

(defun CONST (type / cmde clay flat cpt rang cang cdist olderr)
	(setq
		olderr *error*
		*error* generr
		cmde (getvar "cmdecho")
	)
	(setvar "cmdecho" 0)
	(graphscr)
	(getinfo type)
	(cline type)
	(setvar "cmdecho" cmde)
 (setq *error* olderr)
	(princ)
)

(defun GETINFO (type / temp)
	(initget 1)
	(setq cpoint (getpoint "\nPick location of line: "))
	(cond 
		((eq type "A")
			(initget 1)
			(setq
				rang (getangle cpoint "\nEnter angle of line: ")
				rang (rtd rang)
				cang (strcat "<" (rtos rang))
			)
		)
		((eq type "H")
			(setq rang 90 cang "<90")
		)
		((eq type "V")
			(setq rang 0 cang "<0")
		)
	)
)

(defun CLINE (type / x y xmin xmax ymin ymax cdist newpt)
	(setq
		xmax (car (getvar "vsmax"))
		xmin (car (getvar "vsmin"))
		ymax (cadr (getvar "vsmax"))
		ymin (cadr (getvar "vsmin"))
	)
	(cond
		((eq type "B")
			(setq x (car cpoint) y (cadr cpoint))
			(command "line" (list xmin y) (list xmax y) "")	
			(command "line" (list x ymin) (list x ymax) "")
		)
		(t 
			(while (setq cdist 
					 (getreal "\nEnter Distance to Offset <Return to Exit>: "))
				(setq newpt (polar cpoint (dtr rang) cdist))
				(setq x (car newpt) y (cadr newpt))
				(cond
					((eq type "H")
						(command "line" (list xmin y) (list xmax y) "")
					)
					((eq type "V")
						(command "line" (list x ymin) (list x ymax) "")
					)
					((eq type "A")
						(setq newpt (polar cpoint (dtr (+ 90 rang)) cdist))
						(setq ptlist (getpts))
						(command "line" (car ptlist) (cadr ptlist) "")
					)
					(t (princ "\nUnknown Conditional Option: ")
						(princ type)
					)
				)
			)
		)
	)
)

(defun GETPTS (/ llpt ulpt urpt lrpt c1pt c2pt int1 int2 int3 int4 ptlist)

	(setq
		llpt (getvar "vsmin")
		ulpt (list (car (getvar "vsmin")) (cadr (getvar "vsmax")))
		urpt (getvar "vsmax")
		lrpt (list (car (getvar "vsmax")) (cadr (getvar "vsmin")))
		c1pt (polar newpt (dtr rang) 1000)
		c2pt (polar newpt (dtr (+ 180 rang)) 1000)
		int1 (inters llpt ulpt c1pt c2pt)
		int2 (inters ulpt urpt c1pt c2pt)
		int3 (inters urpt lrpt c1pt c2pt)
		int4 (inters lrpt llpt c1pt c2pt)
	)
	(cond
		((and int1 int2) (setq ptlist (list int1 int2)))
		((and int1 int3) (setq ptlist (list int1 int3)))
		((and int1 int4) (setq ptlist (list int1 int4)))
		((and int2 int3) (setq ptlist (list int2 int3)))
		((and int2 int4) (setq ptlist (list int2 int4)))
		((and int3 int4) (setq ptlist (list int3 int4)))
	)
	(setq ptlist ptlist)
)
