;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; File: CONNECT.LSP  Copyright (C) Ben Olasov 1994 olasov@cs.columbia.edu ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; load-time variable clean up / garbage collection
(setq c:connect nil c:ct nil  connect_plines nil  translate_pts nil 
      extract_value nil  userstr nil  pos_in_list nil  c:rd nil 
      c:sync nil  sync nil  aux_close nil  list_verts nil 
      set_la nil  redraw_pln nil  _pline nil  l_left nil 
      divide_pline nil  ss2nodelist nil  list_verts nil  make_la nil 
      origin_pt nil  ecs2ucs nil)  (gc)

(defun c:connect (/ shp1* shp2*)
       (setvar "cmdecho" 0)
       (setq shp1* (user_ent (list "POLYLINE" "CIRCLE" "ARC")
                             "\nfirst polygon: "))
       (setq shp2* (user_ent (list "POLYLINE" "CIRCLE" "ARC")
                             "\npolygon to join: "))
       (connect_plines shp1* shp2*)
       'done)

(defun connect_plines (pl1 pl2 / i_ pl_pts1 pl_pts2 pl_pts_l)
       (setq i_ 0
             force? nil
             eq_vtxlsts nil
             pl_pts1 (translate_pts (collect_vertices pl1) pl1)
             pl_pts2 (translate_pts (collect_vertices pl2) pl2)
             #pts1 (length pl_pts1)
             #pts2 (length pl_pts2))
       (if (and pl_pts1 pl_pts2)
           (progn (gc)
             (if (/= #PTS1 #PTS2)
               (progn (princ (strcat
                               "\nconnect_plines: unequal vertex list lengths: "
                               (itoa #pts1) " & "
                               (itoa #pts2)))
                      (setq eq_vtxlsts nil
                            force? (userstr (if force? force? "Y")
                                    "\nForce equal vertex list lengths [Y N]"))
                      (if (equal force? "Y")
                          (progn (setq force_method (strcase
                                       (userstr (if force_method
                                                    force_method
                                                    "O")
                         "\nForce method [O]ffset or [E]qual division")))
                                 (if (equal force_method "O")
                                     ;; use polar vertex offsets
                                     (setq %offst_d (distance (car pl_pts1)
                                                              (car pl_pts2))
                                           %bp (centroid pl_pts1) 
                                           offst_d (userdist (car pl_pts1)
                                                             (if offst_d
                                                                 offst_d
                                                                 %offst_d)
                                                             "Offset distance")
                                           pl_pts2 (offset_verts pl_pts1
                                                                 %bp
                                                                 offst_d))
                                     ;; use equal contour division
                                     (setq pl_pts1
                                           (divide_pline pl1
                                                         (max #PTS1 #PTS2)
                                                         (ecs2ucs
                                                             (origin_pt pl1)
                                                             pl1))
                                           pl_pts2 
                                           (divide_pline pl2
                                                         (max #PTS1 #PTS2)
                                                         (ecs2ucs
                                                             (origin_pt pl2)
                                                             pl2)))))))
                (setq eq_vtxlsts 'T))
        (if (or eq_vtxlsts (equal force? "Y"))
            (progn (setq pl_pts_l (length pl_pts1))
                   (command "3dmesh" pl_pts_l 2)
                   (repeat pl_pts_l
                           (if (equal force? "Y")
                               (setq _pl_pt_1 (nth i_ pl_pts1)
                                     _pl_pt_2 (nth i_ pl_pts2))
                               (setq _pl_pt_1 (nth i_ pl_pts1)
                                     _pl_pt_2 (nth i_ pl_pts2)))
                          (command _pl_pt_1 _pl_pt_2)
                          (setq i_ (1+ i_))))))))

;; translate a list of coordinate triplets from UCS(%EN%) to UCS
(defun translate_pts (%ptl% %en% / ntrans)
       (defun ntrans (%v%)
              (trans %v% %en% 1))
       (mapcar 'ntrans %ptl%))

;; returns sequence position of item in list
;; compatible with NTH
(defun pos_in_list (item lst)
        (if (null (member item lst))
            nil
            (- (length lst) (length (member item lst)))))

;;; C:RDP redraws a selected polylines with straight segments
;;; joining a specified number of equidistant nodes.
(defun c:rdp ()
       (setq *shp1* (user_ent (list "POLYLINE" "LINE") "\ncontour to redraw: "))
       (setq op (trans (origin_pt *shp1*) *shp1* 1)
             res (userint  (if res res 80) "\nResolution")
             plnds (divide_pline *shp1* res op)
             del_old? (strcase (userstr (if del_old? del_old? "N")
                "\nDelete original contour after redraw [Y N]")))
       (_pline plnds)
       (if (/= del_old? "N")
           (entdel *shp1*))
       (setq *shp1* nil)       
       (setq plnds nil)
 'done)
 
;; C:OFP offsets a selected polyline contour
(defun c:ofp (/ %pl %plpts %basp)
       (modes '("cmdecho" "blipmode"))
       (setq %pl (user_ent (list "POLYLINE")
                           "\nSelect a pline for polar offset: ")
             %plpts (list_verts %pl)
             %basp (centroid %plpts)
             %offst_d (userdist %basp
                                (if %offst_d
                                    %offst_d
                                    (distance (car %plpts) (cadr %plpts)))
                                "Offset distance")
             %plpts (offset_verts %plpts %basp %offst_d))
        (setvar "blipmode" 0)
        (setvar "cmdecho" 0)
        (_pline %plpts)
        (moder)
        (terpri) 'done)

;; SS2NODELIST returns a simple list of the origin points of the members
;; of selection set SS.
;; [used for collecting the coordinate values of point entities created
;; by the divide command].
(defun ss2nodelist (ss / *ent* pt pts &i ssl)
       (if (or (null ss) (/= (type ss) 'PICKSET)) nil
           (progn (setq &i 0
                        ssl (sslength ss))
                  (while (/= &i ssl)
                         (setq ent (ssname ss &i)
                               *ent* (entget ent)
                               pt (cdr (assoc 10 *ent*))
                               pts (cons pt pts))
                         (setq &i (1+ &i))))) pts)

;; C:SYNC brings two polylines contours having different directions of vertex
;; placement into correspondence by redefining the direction of vertex 
;; placement.
(defun c:sync (/ %pln_ss%)
       (princ "\nSelect plines to sync: ")
       (setq %pln_ss% (ssget))
       (sync %pln_ss%)
       (setq %pln_ss% nil)  'done)

(defun sync (pln_ss / # pln_ssl curr_la pln_ pln_pts rfp)
       (cond ((null pln_ss) nil)
             ((not (equal (type pln_ss) 'pickset)) nil)
             ((= (sslength pln_ss) 0) nil)
             (T (setq # 0
                      pln_ssl (sslength pln_ss)
                      curr_la (getvar "clayer"))
                (repeat pln_ssl
                        (setq pln_ (ssname pln_ss #)
                              pln_pts_ (aux_close
                                           (translate_pts
                                              (list_verts pln_)
                                              pln_))
                              rfp (l_left pln_pts_))
                        (set_la pln_)
                        (redraw_pln rfp pln_pts_ pln_)
                        (setq # (1+ #)))
                (command "layer" "s" curr_la "")))
       (terpri))

(defun aux_close (&&vrts)
       (if &&vrts
           (if (not (equal (car &&vrts) (last &&vrts)))
               (reverse (cons (car &&vrts) (reverse &&vrts)))
               &&vrts)))

(defun set_la (%e%)
       (if %e%
           (progn (setq %clay (getvar "clayer")
                        %elay (cdr (assoc 8 (entget %e%))))
                  (if (not (equal %clay %elay))
                      (command "layer" "t" %elay "on" %elay "s" %elay "")))))

(defun redraw_pln (rfpt %plns% _e)
       (setq %%plns% %plns%)
       (if (not (equal rfpt (car %%plns%)))
           (progn (while (not (equal rfpt (car %%plns%)))
                         (setq %%plns%
                              (append (cdr %%plns%)
                                      (list (car %%plns%)))))
                  (_pline %%plns%))
           (_pline %plns%)))

(defun _pline (pnts)
       (if (and pnts (listp pnts))
           (progn (command "pline")
                  (foreach pt pnts (if pt (command pt)))
                  (command "")))
       (entlast))

(defun l_left (verts / _xmax _ymin tmplst ll_pt)
       (setq _xmin (apply 'min (mapcar 'car verts)))
       (foreach vert verts
                (if (equal (car vert) _xmin)
                    (setq tmplst
                          (if tmplst (cons vert tmplst)
                                     (list vert)))))
       (setq _ymin (apply 'min (mapcar 'cadr tmplst))
             ll_pt (nth (pos_in_list _ymin (mapcar 'cadr tmplst)) tmplst)))

(defun divide_pline (enm n_vrts_ _pt_  / pt_ss pt_l$$)
       (command "undo" "c" "one")
       (setq clayer (getvar "clayer"))
       (make_la "$PT$")
       (command "divide" _pt_ (1+ n_vrts_))
       (setq pt_ss (ssget "x" (list (cons 0 "POINT")
                                    (cons 8 "$PT$")))
             pt_l$$ (ss2nodelist pt_ss)
             pt_ss nil)
       (gc)
       (command "undo" "1")
       (command "undo" "1")
       (command "undo" "1")
       (make_la clayer)  pt_l$$)

;; SS2NODELIST returns a list of the origin points
;; of the members of SS
(defun ss2nodelist (ss / *ent* pt pts &i ssl)
       (if (or (null ss) (/= (type ss) 'PICKSET)) nil
           (progn (setq &i 0
                        ssl (sslength ss))
                  (while (/= &i ssl)
                         (setq ent (ssname ss &i)
                               *ent* (entget ent)
                               pt (cdr (assoc 10 *ent*))
                               pts (cons pt pts))
                         (setq &i (1+ &i))))) pts)

(defun list_verts (polyln / __ent *polyln* ##pt ##pts)
       (if (= (cdr (assoc 0 (setq *polyln* (entget polyln)))) "POLYLINE")
           (progn (setq __ent (entnext polyln))
                  (while (setq *ent* (entget __ent)
                               ##pt (cdr (assoc 10 *ent*))
                               crv_fit_bit (cdr (assoc 70 *ent*)))
                         (if (/= crv_fit_bit 1) ;; test for artificial nodes
                             (setq ##pts (cons ##pt ##pts)))
                         (setq __ent (entnext __ent))))
           (princ "\n_list_verts: not a polyline."))
       (if ##pts (reverse ##pts)))

(defun make_la (%nam%)
       (if %nam%
           (progn (setq %clay (getvar "clayer"))
                  (if (layerp %nam%)
                      (if (not (equal %clay %nam%))
                          (command "layer""t"%nam%"on"%nam%"s"%nam%""))
                      (command "layer" "m" %nam% "")))))

(defun origin_pt (pln)
       (if (equal (cdr (assoc 0 (entget pln))) "POLYLINE")
           (cdr (assoc 10 (entget (entnext pln))))
           (cdr (assoc 10 (entget pln)))))

(defun ecs2ucs (%p% %e%)
       (trans %p% %e% 1))

;;; returns 'T if layer exists, nil otherwise
(defun layerp (layername)
       (if (null layername) nil
           (if (member (strcase layername) (listify_layers))
               'T nil)))

;;; returns a list of all layers in drawing
(defun listify_layers (/ layer layers nam)
       (setq layer (cdr (assoc 2 (tblnext "layer" T))) ;;rewind layer table
             layers (list  layer))
       (while (setq layer (tblnext "layer")) ;;construct layer list
              (setq nam (cdr (assoc 2 layer))
                    layers (cons nam layers))) layers)

(defun offset_verts (%vrts% %bp% %dlt%)
       (defun _polar (%%p)
              (polar %%p (angle %bp% %%p) %dlt%))
       (mapcar '_polar %vrts%))

;; returns the 2D or 3d centroid of a list of vertices
(defun centroid (verts / num_verts x_avg y_avg z_avg centrd)
       (if (or (null verts)
               (null (listp verts)))
           nil
           (setq num_verts (length verts)
                 x_avg (/ (apply '+ (mapcar 'car verts)) num_verts)
                 y_avg (/ (apply '+ (mapcar 'cadr verts)) num_verts)
                 z_avg (/ (apply '+ (mapcar 'caddr verts)) num_verts)
                 centrd (list x_avg y_avg z_avg))) centrd)

(defun extract_value (key enm) 
       (if enm (cdr (assoc key (entget enm)))))

(defun userstr (dflt prmpt / var) ;;DFLT and PRMPT are strings
       (setq var (getstring t (if (and dflt (/= dflt ""))
                                (strcat prmpt " <" dflt ">: ")
                                (strcat prmpt ": "))))
       (cond ((/= var "") var)
             ((and dflt (= var "")) dflt)
             (T dflt)))

(defun userint (dflt prmpt / var)
       (if (setq var
                 (getint (if dflt (strcat prmpt " <" (itoa dflt) ">: ")
                                  (strcat prmpt ": ")))) var dflt))

(defun userdist (refpt dflt prmpt / var)
       (if (setq var
                 (getdist (if refpt refpt)
                          (if dflt (strcat prmpt " <" (rtos dflt 2 5) ">: ")
                                   (strcat prmpt ": ")))) var dflt))

(defun user_ent (ent_type_lst _prm / __ent)
      (while (not (member (extract_value 0 
                                        (setq __ent (car (entsel _prm))))
                ent_type_lst))) __ent)

;; from AutoDesk
(defun modes (a)
   (setq mlst '())
   (repeat (length a)
      (setq mlst (append mlst (list (list (car a) (getvar (car a))))))
      (setq a (cdr a))))

;; from AutoDesk
(defun moder ()
   (repeat (length mlst)
      (setvar (caar mlst) (cadar mlst))
      (setq mlst (cdr mlst))))

(defun collect_vertices (polyln / __ent *polyln* ##pt ##pts)
       (if (= (cdr (assoc 0 (setq *polyln* (entget polyln)))) "POLYLINE")
           (progn (setq __ent (entnext polyln))
                  (while (setq *ent* (entget __ent)
                               ##pt (cdr (assoc 10 *ent*)))
                         (setq ##pts (cons ##pt ##pts)
                               __ent (entnext __ent)))
                         (if (and (equal (cdr (assoc 70 (entget polyln))) 1)
                                  (not (equal (car ##pts) (last ##pts))))
                             (setq ##pts (reverse (cons (car ##pts)
                                                        (reverse ##pts))))))
           (if (= (cdr (assoc 0 (setq *polyln* (entget polyln)))) "LINE")
               (setq ##pts (list (extract_value 10 polyln)
                                 (extract_value 11 polyln)))
               (princ "\ncollect_vertices: not a POLYLINE.")))
       (if ##pts (setq np (length ##pts)))
       ##pts)

(setq cv collect_vertices)

(defun midpt (p1 p2)
       (polar p1 (angle p1 p2) (/ (distance p1 p2) 2.0)))

(defun inside (p_ vtx_lst / ints i max_x max_y)
       (setq ints 0
             i 0
             num_vtx (length vtx_lst)
             max_x (apply 'max (mapcar 'car vtx_lst))
             max_y (apply 'max (mapcar 'cadr vtx_lst))
             exterior_pt (list (* max_x 2.0) (* max_y 2.0)))
       (repeat (1- num_vtx)
               (if (= i (1- num_vtx))
                   (setq vt1 (nth i vtx_lst)
                         vt2 (nth 0 vtx_lst))
                   (setq vt1 (nth i vtx_lst)
                         vt2 (nth (1+ i) vtx_lst)))
               (if (inters p_ exterior_pt vt1 vt2)
                   (setq ints (1+ ints)))
               (setq i (1+ i)))
       (if (= (rem ints 2) 0)
           nil 'T))

;; C:FILLPLN fills a countour with a surface constructed of
;; 3dface entities.
(defun c:fillpln ()
       (setq %pl (user_ent (list "POLYLINE")
                 "\nSelect a pline contour to fill with 3dfaces: "))
       (if %pl (fillcontour (collect_vertices %pl))))

(defun fillcontour (vtx-list / v1 v2 v3 old_v1)
       (cond ((null vtx-list) nil)
             ((null (listp vtx-list)) nil)
             ((member nil (mapcar 'listp vtx-list)) nil)
             (T (while (caddr vtx-list)
                       (if v1 (setq old_v1 v1))
                       (setq v1 (car vtx-list))
                       (setq v2 (cadr vtx-list))
                       (setq v3 (caddr vtx-list))
                       (setq mp-v1-v2 (midpt v1 v2))
                       (setq mp-v2-v3 (midpt v2 v3))
                       (setq mp-v1-v3 (midpt v1 v3))
                       (if old-v1
                           (progn (setq mp-v1old-v1 (midpt v1old v1)
                                        mp-v1old-v2 (midpt v1old v2)
                                        mp-v1old-v3 (midpt v1old v3))
                                  (if (and (inside mp-v1old-v1 vtx-list)
                                           (inside mp-v1old-v2 vtx-list)
                                           (inside mp-v1-v2 vtx-list))
                                      (command "3dface" old_v1 v1 v2 "" ""))
                                  (if (and (inside mp-v1old-v1 vtx-list)
                                           (inside mp-v1old-v3 vtx-list)
                                           (inside mp-v1-v2 vtx-list))
                                      (command "3dface" old_v1 v2 v3 "" ""))
                                      ))
                        (if (and (inside mp-v1-v2 vtx-list)
                                 (inside mp-v2-v3 vtx-list)
                                 (inside mp-v1-v2 vtx-list))
                            (command "3dface" v1 v2 v3 "" ""))
                (if (and vtx-list (cdr vtx-list))
                    (setq vtx-list (cdr vtx-list)))))))

(defun c:ct ()
       (c:connect))

(princ "\nCommand level function C:CONNECT loaded - 
type CONNECT to connect two polyline contours with a 3DMESH.") 
(princ)

