(prompt "Loading CLOUD utility...")
(defun C:CLOUD ( / mark p1 e1 e2 bulge vx data)
   (setvar "cmdecho" 0)
   (setq p1 (getpoint "Polyline <Clockwise>... First point: ")
   )                                                  ;setq calculations

   (command "PLINE" p1 "W" "0" "")                    ;draw polyline
   (while p1
      (command p1)
      (setq p1 (getpoint p1 "\NTo point: "))
   )                                                  ;while
   (command "C")

   (setq e1 (entlast)                                 ;save it
         e2 (entget e1)                               ;get it
         bulge (list (cons 42 -0.5))                  ;build cloud
         vx (cdr (assoc -1 e2))                       ;set for lookup
         vx (entnext vx)                              ;get next one
   )                                                  ;setq calculations
   (while vx                                          ;if something there
      (setq data (entget vx)                          ;get what's there
            data (append data bulge)                  ;tag to bulge
      )                                               ;setq calculations
      (entmod data)                                   ;change entity
      (setq vx (entnext vx))                          ;get next one
   )                                                  ;while
   (entupd e1)                                        ;update entity

   (setvar "cmdecho" 1)
   (gc) (princ)
)                                                     ;defun

