; CFKEY.LSP
; From program by Ed Batson

;This lisp routine allows you to "program" the function keys on your
;keyboard to issue AutoCAD commands.  To save the programmed keys beyond
;the current editing session, save the program lets you save the key
;definitions in a .BAT file.

;The command DEVICE=ANSI.SYS must be in the config.sys file.

;To make full use of this program, I recommend the following:
;Try it out by using the load command and typing ckfey at the
;command prompt.

;When you have a function key combination you like, save it
;under a bat file extension.  Then call the bat file before loading Autocad.

;Caution: when you decide to change a function key, save it under a
;different file name.  Otherwise you will only be saving the key
;that has been redefined.  After you save it you can use a text 
;editor to modify the original file to match your new key combination.
;I'm sorry about that but what can you expect for free.

;The program has another quirk.  It changes the screen colors.
;You can change the colors to whatever you like by referring to your DOS
;manual.  Let me know if you need help doing this. 

;The escape sequences that are loaded each time remain in effect
;until the system is rebooted or you reset them using the Reset option
;of the CFKEY program.

;The programs Mark & Release we use to get rid of TSR's will not work
;with this program because it is not a TSR.  Therefore I have included
;a reset batch file for those who don't want to loose the DOS function 
;key settings when not using Autocad.  This file should be included 
;after the acad program line in the batch file used to start
;Autocad.

;Here is a sample batch file called a.bat on my system:

;SET ACAD=C:\ACAD;C:\ACAD\SAMPLE;C:\ACAD\ADS;C:\LIB;C:\ACAD\LISP
;SET ACADCFG=C:\ACAD
;CD \ACAD\DWGS
;CALL CFKEY1
;ACAD %1 %2
;CALL CFKEY2

;Well that's about it,  Good luck!

;----------------------------------------------

(defun c:cfkey (/ ch ch2 y_r y_b w_g w_r b_w)
(defun fkeyerr (s)
(if fopn (setq fopn (close fopn)))
(princ (strcat "\nProgram: "s))
(setq *error* olderr)
(prin1)
)
(setq olderr *error* *error* fkeyerr)
(command "sh" "cls")
(setq y_r "\e[33;41;1m" w_b "\e[37;44;1m" w_g "\e[37;42;1m" w_r "\e[37;41;1m"
      b_w "\e[34;47;1m")
;listf======================
      (defun listf ()
      (prompt "\e[2J")
      (princ "\n\t Function key settings created in current drawing session.\n")
       (if (/= f1 nil)(print (strcat "F1 "(eval f1))))
       (if (/= f2 nil)(print (strcat "F2 "(eval f2))))
       (if (/= f3 nil)(print (strcat "F3 "(eval f3))))
       (if (/= f4 nil)(print (strcat "F4 "(eval f4))))
       (if (/= f5 nil)(print (strcat "F5 "(eval f5))))
       (if (/= f6 nil)(print (strcat "F6 "(eval f6))))
       (if (/= f7 nil)(print (strcat "F7 "(eval f7))))
       (if (/= f8 nil)(print (strcat "F8 "(eval f8))))
       (if (/= f9 nil)(print (strcat "F9 "(eval f9))))
       (if (/= f10 nil)(print (strcat "F10 "(eval f10))))
       (if (/= f11 nil)(print (strcat "F11 "(eval f11))))
       (if (/= f12 nil)(print (strcat "F12 "(eval f12))))
       )
;writef=====================
      (defun writef (/ fnam fopn yn w_r w_b)
       (setq w_r "\e[37;41;1m" w_b "\e[37;44;1m")
       (princ (strcat
                "\n\tNOTE: Use the  .BAT  extension to make the saved file"
                "\n\ta  BATCH  file, (or save as a text file and "
                "\n\tuse the TYPE command to execute at the DOS prompt.)"
                "\n\n\t"w_r"[ Be sure to include the file extension. ]"w_b))
       (setq fnam (getstring 1 "\n\tFile name to save F-KEY settings to: "))
        (if (findfile fnam)
         (setq yn (strcase(getstring "\nFile exists..Overwrite ? Y/N: ")))
        )
       (if (or (= yn "Y") (null(findfile fnam)))
        (progn
       (setq fopn (open fnam "w"))
       (write-line "@echo off" fopn)
       (if (/= f1 nil)(write-line (strcat "ECHO "(eval f1))fopn))
       (if (/= f2 nil)(write-line (strcat "ECHO "(eval f2))fopn))
       (if (/= f3 nil)(write-line (strcat "ECHO "(eval f3))fopn))
       (if (/= f4 nil)(write-line (strcat "ECHO "(eval f4))fopn))
       (if (/= f5 nil)(write-line (strcat "ECHO "(eval f5))fopn))
       (if (/= f6 nil)(write-line (strcat "ECHO "(eval f6))fopn))
       (if (/= f7 nil)(write-line (strcat "ECHO "(eval f7))fopn))
       (if (/= f8 nil)(write-line (strcat "ECHO "(eval f8))fopn))
       (if (/= f9 nil)(write-line (strcat "ECHO "(eval f9))fopn))
       (if (/= f10 nil)(write-line (strcat "ECHO "(eval f10))fopn))
       (if (/= f11 nil)(write-line (strcat "ECHO "(eval f11))fopn))
       (if (/= f12 nil)(write-line (strcat "ECHO "(eval f12))fopn))
       (setq fopn (close fopn))
       (prompt "\e[2J")
       (princ (strcat "\n\t\t"w_r"F-KEY settings written to "fnam w_b))
        );endprog
        (progn
         (prompt "\e[2J")
         (princ (strcat "\n\n\t\t\t"w_r"Save F-KEY settings"w_b"\n\n"))
         (writef)
        )
       );endif
      );end writef
;readf======================
      (defun readf (/ fnam fex)
       (setq w_r "\e[37;41;1m" w_b "\e[37;44;1m")
       (setq fnam (getstring 1 "\n\n\t\tFile name: "))
       (if (setq fex (findfile fnam))
             (progn
                (setq fex (substr fex (- (strlen fex) 3)))
                (if (/= fex ".BAT")
                 (command "type" fnam)
                 (command "shell" fnam)
                )
                (prompt "\e[2J")
                (princ (strcat "\n\t\t"w_r"F Keys set to "fnam w_b))
             )
             (progn
              (prompt "\e[2J")
              (prompt "\n\t\t<file not found.>\n\n")
              (princ (strcat "\n\t\t"w_r"Set F-KEYs to..."w_b))
              (readf)
             )
       )
      );end readf
;reset==================== 
   (defun resetf (/ key kn f1r f2r f3r f4r f5r f6r f7r f8r f9r f10r f11r f12r)
   (setq
     f1r "\e[0;59;0;59p"  f2r "\e[0;60;0;60p"  f3r "\e[0;61;0;61p"
     f4r "\e[0;62;0;62p"  f5r "\e[0;63;0;63p"  f6r "\e[0;64;0;64p"
     f7r "\e[0;65;0;65p"  f8r "\e[0;66;0;66p"  f9r "\e[0;67;0;67p"
     f10r "\e[0;68;0;68p" f11r "\e[0;133;0;133p"  f12r "\e[0;134;0;134p"
   )
  (setq key (eval(read(strcat "F"(setq kn(getstring "\n\t\tFkey No: F"))"r"))))
   (princ key)
   (princ (strcat "\n\t\tF"kn" is reset to DOS/AutoCAD defaults. . ."))
   );end resetf
;set=====================
   (defun setf (/ key cmd kn qt cr
                  f1k f2k f3k f4k f5k f6k f7k f8k f9k f10k f11k f12k)
   (setq       
        f1k "\e[0;59;"  f2k "\e[0;60;" f3k "\e[0;61;" f4k "\e[0;62;"
        f5k "\e[0;63;"  f6k "\e[0;64;" f7k "\e[0;65;" f8k "\e[0;66;"
        f9k "\e[0;67;"  f10k "\e[0;68;" f11k "\e[0;133;" f12k "\e[0;134;"
         qt "\042"  cr ";13p"
   )
   (setq key (eval(read(strcat "F"(setq kn(getstring "\n\t\tFkey No: F"))"k"))))
   (setq cmd
        (getstring 1 (strcat "\n\t[use space bar for ENTER between commands]"
                      "\n\n\t Command<s> for F"kn" to execute\n\n\t: ")))
   (set (read (strcat "F" kn))(strcat key qt cmd qt cr))
   (princ (strcat key qt cmd qt cr))
   (princ (strcat "\n\t\t\t F"kn" is "cmd))
   );end setf
;==============================================================================
;                        MAIN PROGRAM
(princ (strcat "\n\n\t\t\t" b_w "  CfKey.lsp Ver 1.1  BTC  " w_b))
(princ (strcat"\n\t\t\t" w_r" Function key customizing." w_b))
(princ "\n\n\t\t\t     [ ^C = Quit ]")
(initget 1 "R S F H L")
(setq ch
 (getkword
     (strcat "\n\n\t\t\t"y_r"R"w_b"eset/"y_r"S"w_b"et/"y_r"F"w_b"ile/"
                       y_r"L"w_b"ist: ")))
 (cond 
  ((= ch "L")(listf))
  ((= ch "S")(setf))  ;Set fkey chosen, to execute command given
  ((= ch "R")(resetf));Reset fkey chosen, to dos default
  ((= ch "F")       ;file management
    (progn
     (prompt "\e[2J")
     (princ (strcat "\n\n\n\t\t\t"b_w" *  File Utilities  * "w_b))
     (initget 1 "R W")
     (setq ch2
     (getkword (strcat "\n\n\n\t\t\t"y_r"R"w_b"ead/"y_r"W"w_b"rite: ")))
     (if (= ch2 "R")(readf))
     (if (= ch2 "W")(writef))
    );end prog F
  )
 );end cond
(setq *error* olderr)
(prin1)
)