;COMMERCIAL CAM DIVISION EMERSON ELECTRIC CO.
; (JAN 1987  CADENCE)
;
(defun DTR (A)
	(* pi (/ A 180.0))
)
(defun CAMDATA (/ VP1 BASER BETAX DELTAX)
	(setq P0 0.0 PLIST nil LLIST nil TLIST nil ALIST nil)
	(setq P0 (getpoint "\ncenter point of cam: "))
	(setq BASER (getdist P0 "\ncam base radius: "))
	(setq VP1 (polar P0 0.0 BASER))
	(setq FOLRAD (getdist VP1 "\nfollower radius: "))
	(setq DISPL (getdist VP1 "\ncam displacement in inches: "))
	(setq BETAX (getreal "\ncam motion period in degrees: "))
	(setq DELTAX (getreal "\nhow many steps per degree: "))
	(setq ANGB (DTR (getreal "\noffset in degrees: ")))
	(setq A1 (* BETAX DELTAX))   ;steps per period
	(setq BETA (DTR BETAX))      ;period in radians
	(setq DELTA (/ BETA A1))     ;radians per step
	(setq ANGA 0.0)		     ;cam angle (radians) to calculate
	(setq RAD (+ BASER FOLRAD))  ;initial distance of follower from cam center
	(setq THIGH (/ FOLRAD 2.0))  ;text spacing & height
)
(defun CALCAM (/ VLP VLT ANGX DIFF DISPLA POINTX)
	(setq DIFF (/ ANGA BETA))		; % of period
	(setq ANGX (+ ANGA ANGB))		;angle including offset
	(setq DISPLA (+ RAD (* DISPL
			(- (* 0.43990 DIFF) (* 0.035010 (sin (* 4.0 pi DIFF)))))))
	(setq POINTX (polar P0 ANGX DISPLA))	;center of follower
	(command "CIRCLE" POINTX FOLRAD)	;draw follower
	(setq VLP (polar P0 ANGX (+ DISPLA (* 4.0 FOLRAD))))
	(setq VLT (polar P0 ANGX (+ DISPLA (* 4.5 FOLRAD))))
	(setq LLIST (append LLIST (list VLP)))
	(setq PLIST (append PLIST (list (polar P0 ANGX (- DISPLA FOLRAD)))))
	(setq ALIST (append ALIST (list (/ (* 180.0 ANGX) pi))))
	(setq TLIST (append TLIST (list VLT)))
	(setq ANGA (+ ANGA DELTA))		;increase ANGA by step size
)
(defun CALCAM1 (/ VLP VLT ANGX DIFF DISPLA POINTX)
	(setq DIFF (/ ANGA BETA))		; % of period
	(setq ANGX (+ ANGA ANGB))		;angle including offset
	(setq DISPLA (+ RAD (* DISPL (+ 0.280050 (- (* 0.43990 DIFF)
			(* 0.315050 (cos (* (/ pi 3.0) (- (* 4.0 DIFF) 0.5)))))))))
	(setq POINTX (polar P0 ANGX DISPLA))    ;center of follower
	(command "CIRCLE" POINTX FOLRAD)	;draw follower
	(setq VLP (polar P0 ANGX (+ DISPLA (* 4.0 FOLRAD))))
	(setq VLT (polar P0 ANGX (+ DISPLA (* 4.5 FOLRAD))))
	(setq LLIST (append LLIST (list VLP)))
	(setq PLIST (append PLIST (list (polar P0 ANGX (- DISPLA FOLRAD)))))
	(setq ALIST (append ALIST (list (/ (* 180.0 ANGX) pi))))
	(setq TLIST (append TLIST (list VLT)))
	(setq ANGA (+ ANGA DELTA))		;increase ANGA by step size
)
(defun drawcam (/ VL VP1 VP2 VPN)
	(setq X 0.0)				;loop step counter
	(while (<= X (/ A1 8))  		;loop for 1/8 of the period
		(CALCAM)
		(setq X (1+ X))
	)
	(while (<= X A1)			;loop for the rest of the period
		(CALCAM1)
		(setq X (1+ X))
	)
	(setq VL (length PLIST) VPN 0)
	(command "LAYER" "M" "CAMLINE" ""
		"POINT" P0
		"LINE" "TAN" (nth 0 PLIST))
	(while (< (setq VPN (1+ VPN)) VL)
		(command "TAN" (nth VPN PLIST))
	)
	(setq VPN -1 VL (1- VL))
	(command ""
		"LAYER" "M" "CAMDIM" "")
	(while (< (setq VPN (1+ VPN)) VL)
		(command "LINE" P0 (nth VPN LLIST) "")
	)
	(setq VPN -1)
	(while (< (setq VPN (1+ VPN)) VL)
		(command "TEXT" (nth VPN TLIST) THIGH (nth VPN ALIST)
			(strcat (rtos (nth VPN ALIST) 2 1) "%%D"))
	)
)
(defun C:cam (/ SBLIP SCMDE)
	(CAMDATA)				;get parameters
	(setq SBLIP (getvar "BLIPMODE") SCMDE (getvar "CMDECHO"))
	(setvar "BLIPMODE" 0)
	(setvar "CMDECHO" 0)
	(command "LAYER" "M" "CAMPATH" "")
	(drawcam)
	(setvar "CMDECHO" SCMDE)
	(setvar "BLIPMODE" SBLIP)
	(prompt "\nfor all your cam needs contact")
	(prompt "\n***** CAMCO 312-459-5200 *****")
)
                                                                                                                  