;FS-HELP.PRG
;C. Jennings / Fitting Solutions
;
;
;This program's purpose in life is to allow reading of R12-format
;help files from R13.






;caller program sample code
 ;(fs-help
 ;  "c:/fitsol/piper/"
 ;  1
 ;  "piper-sn"
 ;  ""
 ;)

;main program
(defun fs-help
  (
    fsh-ppath ;fs-help program path name
    fsh-fpath ;help file path name, formatted \\dir\\dir\\
    fsh-fname ;help file prefix (no .hlp)
    fsh-tname ;help file topic name
    / ifile iline num fsh-id fsh-fpath
  )

  ;;;if fsh-fpath = 1, it's the same as fsh-ppath
  (if (= fsh-fpath 1)
    (setq fsh-fpath fsh-ppath)
  )

  ;;;set the error handler
  (setq fsh-olderr *error*)
  (if (/= fsdebug "X")(setq *error* fsh-error))

  ;;;THIS IS THE ONLY TEST WE ARE USING:
  ;;;if ACAD R12...
  (if (not (getvar "pickstyle"))

    ;;;do it the regular way...
    (acad_helpdlg (strcat fsh-ppath fsh-fname) fsh-tname)

    ;;;otherwise, that's why we're here...
    (progn

      ;;;build the index list
      (setq ifile (open (strcat fsh-fpath fsh-fname ".hdx") "r")
            fsh-xlist '()
      )
      (read-line ifile)
      (while (setq iline (read-line ifile))
        (setq num 1)
        (while (/= " " (substr iline num 1))
          (setq num (+ 1 num))
        )
        (setq iline (substr iline 1 (- num 1)))
;       (if (/= iline "END_HELP")
          (setq fsh-xlist (append fsh-xlist (list iline)))
;       )
      )
      (close ifile)

      ;;;set the topic number
      (if (= fsh-tname "")
        (setq fsh-topic "T")
        (setq fsh-topic
          (itoa
            (-
              (length fsh-xlist)
              (length (member fsh-tname fsh-xlist))
            )
          )
        )
      )

      ;;;set up the dialog
      (if (< (setq fsh-id (load_dialog (strcat fsh-ppath "fs-help.dcl"))) 0)
        (exit)
      )
      (new_dialog "fs_help" fsh-id)
      (action_tile "fsh_index" "(fsh-index)")
      (action_tile "fsh_next" "(fsh-next)")
      (action_tile "fsh_prev" "(fsh-prev)")
      (action_tile "fsh_item" "(fsh-item $value)")
      (action_tile "fsh_top" "(fsh-top)")
      (if
        (or
          (= fsh-topic "T")
          (/= (atoi fsh-topic) (length fsh-xlist))
        )
        (fsh-gettopic fsh-topic)
        (set_tile "error"
          (strcat "No help found for " fsh-tname " in " fsh-fname ".hlp")
        )
      )
      (mode_tile "fsh_item" 2)
      (start_dialog)
      (unload_dialog fsh-id)
    )
  )
  (fsh-clear)
  (princ)
)

;;;topic viewer
(defun fsh-gettopic (num / ifile iline)
  (set_tile "error" " ")
  (setq ifile (open (strcat fsh-fpath fsh-fname ".hlp") "r"))
  (if (= num "T")
    (progn
      (read-line ifile)
      (setq topic-name "")
    )
    (progn
      (setq topic-name (nth (atoi num) fsh-xlist))
      (setq fsh-ltopic topic-name)
      (while (/= (setq iline (read-line ifile)) (strcat "\\" topic-name))
        nil
      )
    )
  )
  (start_list "fsh_list")
  (while
    (and
      (setq iline (read-line ifile))
      (/= (substr iline 1 1) "\\")
    )
    (add_list iline)
  )
  (end_list)
  (close ifile)
  (set_tile "fsh_item" topic-name)
  (if (/= num "T")
    (progn
      (if (= (+ 1 (atoi num))(length fsh-xlist))
        (mode_tile "fsh_next" 1)
        (mode_tile "fsh_next" 0)
      )
    )
  )
  (if
    (or
      (= num "T")
      (= (atoi num) 0)
    )
    (mode_tile "fsh_prev" 1)
    (mode_tile "fsh_prev" 0)
  )
)

;;;handle typed-in topics
(defun fsh-item (item / inum item)
  (setq item (strcase item))
  (if (setq inum (member item fsh-xlist))
    (progn
      (setq fsh-topic (itoa (- (length fsh-xlist) (length inum))))
      (fsh-gettopic fsh-topic)
    )
    (progn
      (if fsh-ltopic (set_tile "fsh_item" fsh-ltopic))
      (if (/= fsh-topic "T")
        (set_tile "error" (strcat "No help found for " item " in " fsh-fname ".hlp"))
      )
    )
  )
)

;;;go to top of the file
(defun fsh-top ()
  (setq fsh-topic "T")
  (fsh-gettopic "T")
  (mode_tile "fsh_item" 2)
)

;;;go to next item in the file
(defun fsh-next ()
  (if (= fsh-topic "T")
    (setq fsh-topic "-1")
  )
  (if (< (+ (atoi fsh-topic) 1) (length fsh-xlist))
    (progn
      (setq fsh-topic (itoa (+ 1 (atoi fsh-topic))))
      (fsh-gettopic fsh-topic)
    )
  )
  (mode_tile "fsh_item" 2)
)

;;;go to previous item in the file
(defun fsh-prev ()
  (if (> (atoi fsh-topic) 0)
    (progn
      (setq fsh-topic (itoa (- (atoi fsh-topic) 1)))
      (fsh-gettopic fsh-topic)
    )
    (fsh-gettopic "T")
  )
  (mode_tile "fsh_item" 2)
)

;;;select topic from the index
(defun fsh-index ( / what_next)
  (new_dialog "fs_index" fsh-id)
  (start_list "fsh_index_list")
  (mapcar 'add_list fsh-xlist)
  (end_list)
  (set_tile "fsh_pattern" "*")
  (action_tile "fsh_pattern" "(fsh-newin $value)")
  (action_tile "fsh_index_list" "(setq fsh-topic $value)")
  (setq what_next (start_dialog))
  (if (= what_next 1)
    (fsh-gettopic fsh-topic)
  )
  (mode_tile "fsh_item" 2)
)

;;;handle typed-in topic patterns
(defun fsh-newin (val / new-list)
  (setq new-list '())
  (foreach item fsh-xlist
    (if (wcmatch item (strcase val))
      (setq new-list (append new-list (list item)))
    )
  )
  (if (= 0 (length new-list))
    (setq new-list '("No Entries"))
  )
  (start_list "fsh_index_list")
  (mapcar 'add_list new-list)
  (end_list)
)

;;;clear the variables
(defun fsh-clear ()
  (setq fsh-topic nil
        fsh-ltopic nil
        fsh-xlist nil
        topic-name nil
        *error* fsh-olderr
        fsh-olderr nil
  )
)

;;;error handler
(defun fsh-error (msg)
  (fsh-clear)
  (term_dialog)
  (princ msg)
  (princ)
)


